/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.configurations;

import org.eclipse.vtp.framework.common.configurations.CommonConstants;
import org.eclipse.vtp.framework.core.IConfiguration;
import org.w3c.dom.Element;

public class VariableMappingConfiguration
implements IConfiguration,
CommonConstants {
    public static final int TYPE_NONE = 0;
    public static final int TYPE_STATIC = 1;
    public static final int TYPE_EXPRESSION = 2;
    public static final int TYPE_VARIABLE = 3;
    private int type = 0;
    private String value = null;
    private String scriptingLangugage = null;

    public int getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String getScriptingLangugage() {
        return this.scriptingLangugage;
    }

    public void setNoValue() {
        this.type = 0;
        this.scriptingLangugage = null;
        this.value = null;
    }

    public void setStaticValue(String value) {
        this.type = 1;
        this.value = value == null ? "" : value;
        this.scriptingLangugage = null;
    }

    public void setExpressionValue(String expression, String scriptingLangugage) {
        this.type = 2;
        this.value = expression == null ? "" : expression;
        this.scriptingLangugage = scriptingLangugage == null ? "" : scriptingLangugage;
    }

    public void setVariableValue(String variableName) {
        this.type = 3;
        this.value = variableName == null ? "" : variableName;
        this.scriptingLangugage = null;
    }

    public void load(Element configurationElement) {
        String typeName = configurationElement.getAttribute("type");
        this.type = typeName.length() == 0 ? 0 : ("none".equalsIgnoreCase(typeName) ? 0 : ("static".equalsIgnoreCase(typeName) ? 1 : ("expression".equalsIgnoreCase(typeName) ? 2 : ("variable".equalsIgnoreCase(typeName) ? 3 : Integer.parseInt(typeName)))));
        this.value = this.type == 0 ? null : configurationElement.getAttribute("value");
        this.scriptingLangugage = this.type == 2 ? configurationElement.getAttribute("scripting-language") : null;
    }

    public void save(Element configurationElement) {
        switch (this.type) {
            case 1: {
                configurationElement.setAttribute("type", "static");
                configurationElement.setAttribute("value", this.value);
                break;
            }
            case 2: {
                configurationElement.setAttribute("type", "expression");
                configurationElement.setAttribute("value", this.value);
                configurationElement.setAttribute("scripting-language", this.scriptingLangugage);
                break;
            }
            case 3: {
                configurationElement.setAttribute("type", "variable");
                configurationElement.setAttribute("value", this.value);
                break;
            }
            default: {
                configurationElement.setAttribute("type", "none");
            }
        }
    }
}

