/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.vtp.framework.common.IBrand;
import org.eclipse.vtp.framework.common.IBrandRegistry;
import org.eclipse.vtp.framework.common.IScriptable;
import org.eclipse.vtp.framework.common.configurations.BrandConfiguration;
import org.eclipse.vtp.framework.common.support.ScriptableArray;

public class BrandRegistry
implements IBrandRegistry,
IScriptable {
    private final Brand defaultBrand;
    private final Map<String, Brand> brandsByName;
    private final Map<String, Brand> brandsById;

    public BrandRegistry(BrandConfiguration configuration) {
        this.defaultBrand = new Brand(configuration, null);
        HashMap<String, Brand> brandsByName = new HashMap<String, Brand>();
        HashMap<String, Brand> brandsById = new HashMap<String, Brand>();
        LinkedList<Brand> toIndex = new LinkedList<Brand>();
        toIndex.add(this.defaultBrand);
        while (!toIndex.isEmpty()) {
            Brand brand = (Brand)toIndex.removeFirst();
            brandsByName.put(brand.getName(), brand);
            brandsById.put(brand.getId(), brand);
            int i = 0;
            while (i < brand.children.length) {
                toIndex.addLast(brand.children[i]);
                ++i;
            }
        }
        this.brandsByName = Collections.unmodifiableMap(new HashMap(brandsByName));
        this.brandsById = Collections.unmodifiableMap(new HashMap(brandsById));
    }

    @Override
    public IBrand getDefaultBrand() {
        return this.defaultBrand;
    }

    @Override
    public IBrand getBrand(String name) {
        return this.brandsByName.get(name);
    }

    @Override
    public IBrand getBrandById(String id) {
        return this.brandsById.get(id);
    }

    @Override
    public final String getName() {
        return "Brands";
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public Object toValue() {
        return null;
    }

    @Override
    public String[] getPropertyNames() {
        ArrayList<String> propNames = new ArrayList<String>();
        for (Map.Entry<String, Brand> entry : this.brandsByName.entrySet()) {
            propNames.add(entry.getKey());
        }
        return propNames.toArray(new String[this.brandsByName.size()]);
    }

    @Override
    public final String[] getFunctionNames() {
        return new String[]{"getBrand"};
    }

    @Override
    public final Object invokeFunction(String name, Object[] arguments) {
        if ("getBrand".equals(name) && arguments != null && arguments.length > 0 && arguments[0] != null) {
            Brand brand = this.defaultBrand;
            String nameString = arguments[0].toString();
            String[] parts = nameString.split("[\\./\\\\]");
            int i = 0;
            while (i < parts.length) {
                block5: {
                    if (i != 0 || !parts[i].equals("Default")) {
                        Brand[] brandArray = brand.children;
                        int n = brand.children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Brand b = brandArray[n2];
                            if (b.getName().equals(parts[i])) {
                                brand = b;
                                break block5;
                            }
                            ++n2;
                        }
                        return null;
                    }
                }
                ++i;
            }
            return brand;
        }
        return null;
    }

    @Override
    public final boolean hasItem(int index) {
        return false;
    }

    @Override
    public final boolean hasEntry(String name) {
        return this.brandsByName.containsKey(name);
    }

    @Override
    public final Object getItem(int index) {
        return null;
    }

    @Override
    public final Object getEntry(String name) {
        return this.brandsByName.get(name);
    }

    @Override
    public final boolean setItem(int index, Object value) {
        return false;
    }

    @Override
    public final boolean setEntry(String name, Object value) {
        return false;
    }

    @Override
    public final boolean clearItem(int index) {
        return false;
    }

    @Override
    public final boolean clearEntry(String name) {
        return false;
    }

    public static void main(String[] args) {
        String[] parts;
        String nameString = "brand1.brand2/brand3\\brand4";
        String[] stringArray = parts = nameString.split("[\\./\\\\]");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            System.out.println(part);
            ++n2;
        }
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    private static final class Brand
    implements IBrand,
    IScriptable {
        final String id;
        final String name;
        final Brand parent;
        final Brand[] children;
        final ScriptableArray childArray;

        Brand(BrandConfiguration configuration, Brand parent) {
            this.id = configuration.getId();
            this.name = configuration.getName();
            this.parent = parent;
            BrandConfiguration[] childConfigss = configuration.getChildren();
            if (childConfigss != null) {
                this.children = new Brand[childConfigss.length];
                int i = 0;
                while (i < childConfigss.length) {
                    this.children[i] = new Brand(childConfigss[i], this);
                    ++i;
                }
            } else {
                this.children = new Brand[0];
            }
            this.childArray = new ScriptableArray("children", this.children);
        }

        @Override
        public boolean isDefault() {
            return this.parent == null;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public IBrand getParentBrand() {
            return this.parent;
        }

        @Override
        public IBrand[] getChildBrands() {
            IBrand[] brands = new IBrand[this.children.length];
            System.arraycopy(this.children, 0, brands, 0, this.children.length);
            return brands;
        }

        @Override
        public boolean hasValue() {
            return true;
        }

        @Override
        public Object toValue() {
            return this.name;
        }

        @Override
        public String[] getFunctionNames() {
            return new String[0];
        }

        @Override
        public Object invokeFunction(String name, Object[] arguments) {
            return null;
        }

        @Override
        public boolean hasItem(int index) {
            return false;
        }

        @Override
        public String[] getPropertyNames() {
            return new String[]{"name", "id", "parent", "children"};
        }

        @Override
        public boolean hasEntry(String name) {
            return "name".equals(name) || "id".equals(name) || "parent".equals(name) || "children".equals(name);
        }

        @Override
        public Object getItem(int index) {
            return null;
        }

        @Override
        public Object getEntry(String name) {
            if ("name".equals(name)) {
                return this.name;
            }
            if ("id".equals(name)) {
                return this.id;
            }
            if ("parent".equals(name)) {
                return this.parent;
            }
            if ("children".equals(name)) {
                return this.childArray;
            }
            return null;
        }

        @Override
        public boolean setItem(int index, Object value) {
            return false;
        }

        @Override
        public boolean setEntry(String name, Object value) {
            return false;
        }

        @Override
        public boolean clearItem(int index) {
            return false;
        }

        @Override
        public boolean clearEntry(String name) {
            return false;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public boolean isMutable() {
            return false;
        }
    }
}

