/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.services;

import org.eclipse.vtp.framework.common.IBrand;
import org.eclipse.vtp.framework.common.IBrandRegistry;
import org.eclipse.vtp.framework.common.IBrandSelection;
import org.eclipse.vtp.framework.common.IScriptable;
import org.eclipse.vtp.framework.core.ISessionContext;

public class BrandSelection
implements IBrandSelection,
IScriptable {
    private static final String ATTRIBUTE_KEY = "SelectedBrand";
    private final ISessionContext context;
    private final IBrandRegistry brandRegistry;

    public BrandSelection(ISessionContext context, IBrandRegistry brandRegistry) {
        this.context = context;
        this.brandRegistry = brandRegistry;
    }

    @Override
    public final IBrand getSelectedBrand() {
        Object name = this.context.getAttribute(ATTRIBUTE_KEY);
        if (name == null) {
            name = this.context.getInheritedAttribute(ATTRIBUTE_KEY);
        }
        if (name == null) {
            return this.brandRegistry.getDefaultBrand();
        }
        IBrand brand = this.brandRegistry.getBrand(name.toString());
        if (brand == null) {
            return this.brandRegistry.getDefaultBrand();
        }
        return brand;
    }

    @Override
    public final boolean setSelectedBrand(IBrand brand) {
        if (brand == null) {
            this.context.clearAttribute(ATTRIBUTE_KEY);
        } else {
            IBrand toSelect = this.brandRegistry.getBrand(brand.getName());
            if (toSelect == null) {
                return false;
            }
            this.context.setAttribute(ATTRIBUTE_KEY, (Object)toSelect.getName());
            this.context.info("Set brand to:" + toSelect.getName());
        }
        return true;
    }

    @Override
    public final String getName() {
        return ATTRIBUTE_KEY;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public Object toValue() {
        return this.getSelectedBrand();
    }

    @Override
    public final String[] getFunctionNames() {
        return new String[0];
    }

    @Override
    public final Object invokeFunction(String name, Object[] arguments) {
        return null;
    }

    @Override
    public final boolean hasItem(int index) {
        return false;
    }

    @Override
    public final boolean hasEntry(String name) {
        return "value".equals(name);
    }

    @Override
    public String[] getPropertyNames() {
        return new String[]{"value"};
    }

    @Override
    public final Object getItem(int index) {
        return null;
    }

    @Override
    public final Object getEntry(String name) {
        if ("value".equals(name)) {
            return this.getSelectedBrand();
        }
        return null;
    }

    @Override
    public final boolean setItem(int index, Object value) {
        return false;
    }

    @Override
    public final boolean setEntry(String name, Object value) {
        if ("value".equals(name) && value instanceof IBrand) {
            this.setSelectedBrand((IBrand)value);
            return true;
        }
        return false;
    }

    @Override
    public final boolean clearItem(int index) {
        return false;
    }

    @Override
    public final boolean clearEntry(String name) {
        if ("value".equals(name)) {
            this.setSelectedBrand(null);
            return true;
        }
        return false;
    }

    @Override
    public boolean isMutable() {
        return false;
    }
}

