/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.services;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vtp.framework.common.IDataObject;
import org.eclipse.vtp.framework.common.IScriptingEngine;
import org.eclipse.vtp.framework.common.IScriptingService;
import org.eclipse.vtp.framework.common.IStringObject;
import org.eclipse.vtp.framework.common.IVariableRegistry;
import org.eclipse.vtp.framework.common.commands.ControllerCommand;
import org.eclipse.vtp.framework.common.commands.ExitCommand;
import org.eclipse.vtp.framework.common.commands.ForwardCommand;
import org.eclipse.vtp.framework.common.commands.IncludeCommand;
import org.eclipse.vtp.framework.common.configurations.AssignmentConfiguration;
import org.eclipse.vtp.framework.common.configurations.DispatchConfiguration;
import org.eclipse.vtp.framework.common.configurations.ExitConfiguration;
import org.eclipse.vtp.framework.common.configurations.VariableMappingConfiguration;
import org.eclipse.vtp.framework.common.controller.IController;
import org.eclipse.vtp.framework.common.controller.IDispatcher;
import org.eclipse.vtp.framework.common.controller.IExitDispatcher;
import org.eclipse.vtp.framework.common.controller.IForwardDispatcher;
import org.eclipse.vtp.framework.common.controller.IIncludeDispatcher;
import org.eclipse.vtp.framework.spi.ICommand;
import org.eclipse.vtp.framework.spi.ICommandProcessor;
import org.eclipse.vtp.framework.util.Guid;

public class Controller
implements IController {
    private final ICommandProcessor commandProcessor;
    private final IVariableRegistry variableRegistry;
    private final IScriptingService scriptingService;

    public Controller(ICommandProcessor commandProcessor, IVariableRegistry variableRegistry, IScriptingService scriptingService) {
        this.commandProcessor = commandProcessor;
        this.variableRegistry = variableRegistry;
        this.scriptingService = scriptingService;
    }

    private String resolveVariableMapping(VariableMappingConfiguration configuration) {
        switch (configuration.getType()) {
            case 1: {
                String staticName = Guid.createGUID();
                IStringObject staticVariable = (IStringObject)this.variableRegistry.createVariable("String");
                staticVariable.setValue(configuration.getValue());
                this.variableRegistry.setVariable(staticName, staticVariable);
                return staticName;
            }
            case 2: {
                IScriptingEngine engine = this.scriptingService.createScriptingEngine(configuration.getScriptingLangugage());
                Object result = engine.execute(configuration.getValue());
                if (result == null) {
                    return null;
                }
                String expressionName = Guid.createGUID();
                if (result instanceof IDataObject) {
                    this.variableRegistry.setVariable(expressionName, (IDataObject)result);
                } else {
                    IStringObject expressionVariable = (IStringObject)this.variableRegistry.createVariable("String");
                    expressionVariable.setValue(result.toString());
                    this.variableRegistry.setVariable(expressionName, expressionVariable);
                }
                return expressionName;
            }
            case 3: {
                return configuration.getValue();
            }
        }
        return null;
    }

    @Override
    public IForwardDispatcher createForward(DispatchConfiguration configuration) {
        return new ForwardDispatcher(configuration);
    }

    @Override
    public IExitDispatcher createExit(ExitConfiguration configuration, AssignmentConfiguration[] assignments) {
        return new ExitDispatcher(configuration, assignments);
    }

    @Override
    public IIncludeDispatcher createInclude(DispatchConfiguration configuration) {
        return new IncludeDispatcher(configuration);
    }

    private abstract class AbstractDispatcher
    implements IDispatcher {
        private AbstractDispatcher() {
        }

        abstract ControllerCommand createCommand();

        @Override
        public final boolean enqueue() {
            ControllerCommand command = this.createCommand();
            if (command == null) {
                return false;
            }
            return Controller.this.commandProcessor.enqueue((ICommand)command);
        }

        @Override
        public final boolean process() throws IllegalStateException {
            ControllerCommand command = this.createCommand();
            if (command == null) {
                return false;
            }
            return Controller.this.commandProcessor.process((ICommand)command);
        }
    }

    private final class ExitDispatcher
    extends AbstractDispatcher
    implements IExitDispatcher {
        private final ExitConfiguration configuration;
        private final AssignmentConfiguration[] assignments;

        ExitDispatcher(ExitConfiguration configuration, AssignmentConfiguration[] assignments) {
            this.configuration = configuration;
            this.assignments = assignments;
        }

        @Override
        ControllerCommand createCommand() {
            ExitCommand command = new ExitCommand();
            command.setExitValue(this.configuration.getValue());
            if (this.assignments != null) {
                int i = 0;
                while (i < this.assignments.length) {
                    command.setVariableValues(this.assignments[i].getName(), "");
                    ++i;
                }
            }
            return command;
        }
    }

    private final class ForwardDispatcher
    extends AbstractDispatcher
    implements IForwardDispatcher {
        private final DispatchConfiguration configuration;

        ForwardDispatcher(DispatchConfiguration configuration) {
            this.configuration = configuration;
        }

        @Override
        ControllerCommand createCommand() {
            ForwardCommand command = new ForwardCommand();
            command.setTargetProcessURI(this.configuration.getTargetProcessURI());
            String[] variableNames = this.configuration.getVariableNames();
            int i = 0;
            while (i < variableNames.length) {
                String localVariableName = Controller.this.resolveVariableMapping(this.configuration.getVariableMapping(variableNames[i]));
                if (localVariableName != null) {
                    command.setVariableValue(variableNames[i], localVariableName);
                }
                ++i;
            }
            return command;
        }
    }

    private final class IncludeDispatcher
    extends AbstractDispatcher
    implements IIncludeDispatcher {
        private final DispatchConfiguration configuration;
        private final Map<String, String[]> parameters = new HashMap<String, String[]>();

        IncludeDispatcher(DispatchConfiguration configuration) {
            this.configuration = configuration;
        }

        @Override
        ControllerCommand createCommand() {
            IncludeCommand command = new IncludeCommand();
            command.setTargetProcessURI(this.configuration.getTargetProcessURI());
            String[] variableNames = this.configuration.getVariableNames();
            int i = 0;
            while (i < variableNames.length) {
                String localVariableName = Controller.this.resolveVariableMapping(this.configuration.getVariableMapping(variableNames[i]));
                if (localVariableName != null) {
                    command.setVariableValue(variableNames[i], localVariableName);
                }
                ++i;
            }
            String[] outgoing = this.configuration.getOutgoingPaths();
            int i2 = 0;
            while (i2 < outgoing.length) {
                String[] names = this.configuration.getOutgoingDataNames(outgoing[i2]);
                int j = 0;
                while (j < names.length) {
                    command.setOutgoingDataValue(outgoing[i2], names[j], this.configuration.getOutgoingDataValue(outgoing[i2], names[j]));
                    ++j;
                }
                ++i2;
            }
            for (Map.Entry<String, String[]> entry : this.parameters.entrySet()) {
                command.setParameterValues(entry.getKey(), entry.getValue());
            }
            return command;
        }

        @Override
        public void setParameterValue(String name, String value) {
            String[] stringArray;
            if (name == null) {
                return;
            }
            if (value == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = value;
            }
            this.setParameterValues(name, stringArray);
        }

        @Override
        public void setParameterValues(String name, String[] values) {
            if (name == null) {
                return;
            }
            if (values == null) {
                this.parameters.remove(name);
            } else {
                this.parameters.put(name, values);
            }
        }
    }
}

