/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.services;

import org.eclipse.vtp.framework.common.IDataObject;
import org.eclipse.vtp.framework.common.IDataType;
import org.eclipse.vtp.framework.common.IValueObject;
import org.eclipse.vtp.framework.common.IVariableStorage;
import org.eclipse.vtp.framework.util.Guid;

public abstract class DataObject
implements IDataObject {
    private IVariableStorage variableStorage;
    final String id;
    final IDataType type;
    boolean secured = false;

    protected DataObject(IVariableStorage variableStorage, String id, IDataType type) {
        this.variableStorage = variableStorage;
        this.id = id == null ? "variable.records." + Guid.createGUID() : id;
        this.type = type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    protected Object load() {
        Object[] record = this.variableStorage.getRecord(this.id);
        if (record == null) {
            return null;
        }
        Object[] value = (Object[])record[1];
        this.secured = (Boolean)value[0];
        return value[1];
    }

    protected void save(Object value) throws IllegalStateException {
        if (this.isReadOnly()) {
            throw new IllegalStateException();
        }
        this.variableStorage.setRecord(this.id, this.type, new Object[]{new Boolean(this.secured), value});
    }

    @Override
    public final IDataType getType() {
        return this.type;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSecured() {
        return this.secured;
    }

    @Override
    public void setSecured(boolean secured) {
        Object load = this.load();
        this.secured = secured;
        this.save(load);
    }

    @Override
    public IDataObject getField(String fieldName) {
        return null;
    }

    @Override
    public boolean setField(String fieldName, IDataObject variable) {
        return false;
    }

    @Override
    public boolean isEqualTo(Object object) {
        return this.equals(object);
    }

    @Override
    public boolean isGreaterThan(Object object) {
        return false;
    }

    @Override
    public boolean isGreaterThanOrEqualTo(Object object) {
        return this.isGreaterThan(object) || this.isEqualTo(object);
    }

    @Override
    public boolean isLessThan(Object object) {
        return false;
    }

    @Override
    public boolean isLessThanOrEqualTo(Object object) {
        return this.isLessThan(object) || this.isEqualTo(object);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IDataObject)) {
            return false;
        }
        return this.id.equals(((IDataObject)obj).getId());
    }

    @Override
    public final String getName() {
        return this.id;
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public Object toValue() {
        return null;
    }

    @Override
    public String[] getFunctionNames() {
        return new String[]{"getType", "isReadOnly", "isEqualTo", "isGreaterThan", "isGreaterThanOrEqualTo", "isLessThan", "isLessThanOrEqualTo", "isSecured", "toString"};
    }

    @Override
    public String[] getPropertyNames() {
        return this.type.getFieldNames();
    }

    @Override
    public Object invokeFunction(String name, Object[] arguments) throws Exception {
        if ("getType".equals(name)) {
            return this.getType();
        }
        if ("isReadOnly".equals(name)) {
            return this.isReadOnly() ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("isSecured".equals(name)) {
            return this.isSecured() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (arguments.length > 0) {
            if ("isEqualTo".equals(name)) {
                return this.isEqualTo(arguments[0]) ? Boolean.TRUE : Boolean.FALSE;
            }
            if ("isGreaterThan".equals(name)) {
                return this.isGreaterThan(arguments[0]) ? Boolean.TRUE : Boolean.FALSE;
            }
            if ("isGreaterThanOrEqualTo".equals(name)) {
                return this.isGreaterThanOrEqualTo(arguments[0]) ? Boolean.TRUE : Boolean.FALSE;
            }
            if ("isLessThan".equals(name)) {
                return this.isLessThan(arguments[0]) ? Boolean.TRUE : Boolean.FALSE;
            }
            if ("isLessThanOrEqualTo".equals(name)) {
                return this.isLessThanOrEqualTo(arguments[0]) ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        if ("toString".equals(name)) {
            return this.toString();
        }
        return null;
    }

    @Override
    public boolean hasItem(int index) {
        return false;
    }

    @Override
    public boolean hasEntry(String name) {
        return this.getField(name) != null;
    }

    @Override
    public Object getItem(int index) {
        return null;
    }

    @Override
    public Object getEntry(String name) {
        return this.getField(name);
    }

    @Override
    public boolean setItem(int index, Object value) {
        return false;
    }

    @Override
    public boolean setEntry(String name, Object value) {
        if (value instanceof IDataObject) {
            return this.setField(name, (IDataObject)value);
        }
        IDataObject variable = this.getField(name);
        if (variable == null) {
            variable = this.variableStorage.createVariable(this.type.getFieldType(name));
            this.setField(name, variable);
        }
        if (variable instanceof IValueObject) {
            ((IValueObject)variable).setValue(value);
        }
        return true;
    }

    @Override
    public boolean clearItem(int index) {
        return false;
    }

    @Override
    public boolean clearEntry(String name) {
        return this.setField(name, null);
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    protected IVariableStorage getStorage() {
        return this.variableStorage;
    }
}

