/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.framework.common.IDataType;
import org.eclipse.vtp.framework.common.IDataTypeRegistry;
import org.eclipse.vtp.framework.common.IExternalDataType;
import org.eclipse.vtp.framework.common.IScriptable;
import org.eclipse.vtp.framework.common.configurations.DataTypeConfiguration;
import org.eclipse.vtp.framework.common.configurations.FieldConfiguration;
import org.eclipse.vtp.framework.common.support.ScriptableArray;
import org.osgi.framework.Bundle;

public class DataTypeRegistry
implements IDataTypeRegistry,
IScriptable {
    private final Map<String, IDataType> dataTypes;

    public DataTypeRegistry(IExtensionRegistry extensionRegistry, DataTypeConfiguration[] configurations) {
        DataType type;
        HashMap<String, DataType> dataTypes = new HashMap<String, DataType>();
        IConfigurationElement[] elements = extensionRegistry.getConfigurationElementsFor("org.eclipse.vtp.framework.common.dataTypes");
        int i = 0;
        while (i < elements.length) {
            type = new DataType(elements[i]);
            dataTypes.put(type.getName(), type);
            if (elements[i].getName().equals("object-implementation")) {
                String typeClassName = elements[i].getAttribute("factory-class");
                Bundle contributor = Platform.getBundle((String)elements[i].getContributor().getName());
                IExternalDataType factory = null;
                try {
                    factory = (IExternalDataType)contributor.loadClass(typeClassName).newInstance();
                    type.setExternalFactory(factory);
                    type.setExternal(true);
                }
                catch (Exception e) {
                    dataTypes.remove(type.getName());
                    e.printStackTrace();
                }
            }
            ++i;
        }
        i = 0;
        while (i < configurations.length) {
            type = new DataType(configurations[i]);
            dataTypes.put(type.getName(), type);
            ++i;
        }
        String zero = String.valueOf(0);
        dataTypes.put("Array", new DataType("Array", "length", "Number", zero));
        dataTypes.put("Map", new DataType("Map"));
        dataTypes.put("Boolean", new DataType("Boolean"));
        dataTypes.put("Date", new DataType("Date"));
        dataTypes.put("Decimal", new DataType("Decimal"));
        dataTypes.put("Number", new DataType("Number"));
        dataTypes.put("String", new DataType("String", "length", "Number", zero));
        this.dataTypes = Collections.unmodifiableMap(new HashMap(dataTypes));
    }

    @Override
    public final IDataType getDataType(String typeName) throws NullPointerException {
        if (typeName == null) {
            throw new NullPointerException("typeName");
        }
        return this.dataTypes.get(typeName);
    }

    @Override
    public final String getName() {
        return "DataTypes";
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public Object toValue() {
        return null;
    }

    @Override
    public final String[] getFunctionNames() {
        return new String[0];
    }

    @Override
    public final Object invokeFunction(String name, Object[] arguments) {
        return null;
    }

    @Override
    public final boolean hasItem(int index) {
        return false;
    }

    @Override
    public String[] getPropertyNames() {
        ArrayList<String> propNames = new ArrayList<String>();
        for (Map.Entry<String, IDataType> entry : this.dataTypes.entrySet()) {
            propNames.add(entry.getKey());
        }
        return propNames.toArray(new String[propNames.size()]);
    }

    @Override
    public final boolean hasEntry(String name) {
        return this.getDataType(name) != null;
    }

    @Override
    public final Object getItem(int index) {
        return null;
    }

    @Override
    public final Object getEntry(String name) {
        return this.getDataType(name);
    }

    @Override
    public final boolean setItem(int index, Object value) {
        return false;
    }

    @Override
    public final boolean setEntry(String name, Object value) {
        return false;
    }

    @Override
    public final boolean clearItem(int index) {
        return false;
    }

    @Override
    public final boolean clearEntry(String name) {
        return false;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    private final class DataType
    implements IDataType,
    IScriptable {
        private final String name;
        private final Field[] fields;
        private final Field primaryField;
        private final ScriptableArray fieldArray;
        private boolean external = false;
        private IExternalDataType factory;

        DataType(String name) {
            this.name = name;
            this.fields = new Field[0];
            this.primaryField = null;
            this.fieldArray = new ScriptableArray("fields", this.fields);
        }

        DataType(String name, String fieldName, String fieldTypeName, String fieldInitialValue) {
            this(name, fieldName, fieldTypeName, fieldInitialValue, false);
        }

        DataType(String name, String fieldName, String fieldTypeName, String fieldInitialValue, boolean fieldSecured) {
            this.name = name;
            this.fields = new Field[]{new Field(fieldName, fieldTypeName, fieldInitialValue, fieldSecured)};
            this.primaryField = null;
            this.fieldArray = new ScriptableArray("fields", this.fields);
        }

        DataType(DataTypeConfiguration configuration) {
            this.name = configuration.getName();
            FieldConfiguration[] fieldConfigs = configuration.getFields();
            this.fields = new Field[fieldConfigs.length];
            String primaryFieldName = configuration.getPrimaryField();
            Field primaryField = null;
            int i = 0;
            while (i < fieldConfigs.length) {
                this.fields[i] = new Field(fieldConfigs[i].getName(), fieldConfigs[i].getType(), fieldConfigs[i].getInitialValue(), fieldConfigs[i].isSecured());
                if (this.fields[i].getName().equals(primaryFieldName)) {
                    primaryField = this.fields[i];
                }
                ++i;
            }
            this.primaryField = primaryField;
            this.fieldArray = new ScriptableArray("fields", this.fields);
        }

        DataType(IConfigurationElement configuration) {
            this.name = configuration.getAttribute("name");
            IConfigurationElement[] fieldConfigs = configuration.getChildren("field");
            this.fields = new Field[fieldConfigs.length];
            String primaryFieldName = configuration.getAttribute("primary-field");
            Field primaryField = null;
            int i = 0;
            while (i < fieldConfigs.length) {
                this.fields[i] = new Field(fieldConfigs[i].getAttribute("name"), fieldConfigs[i].getAttribute("type"), fieldConfigs[i].getAttribute("initial-value"), fieldConfigs[i].getAttribute("secured") != null ? Boolean.parseBoolean(fieldConfigs[i].getAttribute("secured")) : false);
                if (this.fields[i].getName().equals(primaryFieldName)) {
                    primaryField = this.fields[i];
                }
                ++i;
            }
            this.primaryField = primaryField;
            this.fieldArray = new ScriptableArray("fields", this.fields);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String[] getFieldNames() {
            String[] fieldNames = new String[this.fields.length];
            int i = 0;
            while (i < this.fields.length) {
                fieldNames[i] = this.fields[i].name;
                ++i;
            }
            return fieldNames;
        }

        @Override
        public String getPrimaryFieldName() {
            return this.primaryField == null ? null : this.primaryField.name;
        }

        @Override
        public IDataType getFieldType(String fieldName) {
            int i = 0;
            while (i < this.fields.length) {
                if (this.fields[i].name.equals(fieldName)) {
                    return this.fields[i].getType();
                }
                ++i;
            }
            return null;
        }

        @Override
        public String getFieldInitialValue(String fieldName) {
            int i = 0;
            while (i < this.fields.length) {
                if (this.fields[i].name.equals(fieldName)) {
                    return this.fields[i].initalValue;
                }
                ++i;
            }
            return null;
        }

        @Override
        public boolean isFieldSecured(String fieldName) {
            int i = 0;
            while (i < this.fields.length) {
                if (this.fields[i].name.equals(fieldName)) {
                    return this.fields[i].secured;
                }
                ++i;
            }
            return false;
        }

        @Override
        public boolean isArrayType() {
            return "Array".equals(this.name);
        }

        public boolean isMapType() {
            return "Map".equals(this.name);
        }

        @Override
        public boolean isComplexType() {
            return !this.isArrayType() && !this.isMapType() && !this.isSimpleType();
        }

        @Override
        public boolean isSimpleType() {
            return "Boolean".equals(this.name) || "Date".equals(this.name) || "Decimal".equals(this.name) || "Number".equals(this.name) || "String".equals(this.name);
        }

        @Override
        public boolean isExternalType() {
            return this.external;
        }

        public void setExternal(boolean external) {
            this.external = external;
        }

        @Override
        public final IExternalDataType getExternalFactory() {
            return this.factory;
        }

        public void setExternalFactory(IExternalDataType factory) {
            this.factory = factory;
        }

        @Override
        public boolean hasValue() {
            return true;
        }

        @Override
        public Object toValue() {
            return this.name;
        }

        @Override
        public String[] getFunctionNames() {
            return new String[]{"isArray", "isComplex", "isSimple", "isMap"};
        }

        @Override
        public Object invokeFunction(String name, Object[] arguments) {
            if ("isArray".equals(name)) {
                return this.isArrayType() ? Boolean.TRUE : Boolean.FALSE;
            }
            if ("isMap".equals(name)) {
                return this.isMapType() ? Boolean.TRUE : Boolean.FALSE;
            }
            if ("isComplex".equals(name)) {
                return this.isComplexType() ? Boolean.TRUE : Boolean.FALSE;
            }
            if ("isSimple".equals(name)) {
                return this.isSimpleType() ? Boolean.TRUE : Boolean.FALSE;
            }
            return null;
        }

        @Override
        public boolean hasItem(int index) {
            return false;
        }

        @Override
        public String[] getPropertyNames() {
            return new String[]{"name", "fields"};
        }

        @Override
        public boolean hasEntry(String name) {
            return "name".equals(name) || "fields".equals(name);
        }

        @Override
        public Object getItem(int index) {
            return null;
        }

        @Override
        public Object getEntry(String name) {
            if ("name".equals(name)) {
                return this.name;
            }
            if ("fields".equals(name)) {
                return this.fieldArray;
            }
            return null;
        }

        @Override
        public boolean setItem(int index, Object value) {
            return false;
        }

        @Override
        public boolean setEntry(String name, Object value) {
            return false;
        }

        @Override
        public boolean clearItem(int index) {
            return false;
        }

        @Override
        public boolean clearEntry(String name) {
            return false;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public boolean isMutable() {
            return false;
        }

        private final class Field
        implements IScriptable {
            final String name;
            final String typeName;
            final String initalValue;
            final boolean secured;

            Field(String name, String typeName, String initalValue, boolean secured) {
                this.name = name;
                this.typeName = typeName;
                this.initalValue = initalValue;
                this.secured = secured;
            }

            IDataType getType() {
                return DataTypeRegistry.this.getDataType(this.typeName);
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public boolean hasValue() {
                return true;
            }

            @Override
            public Object toValue() {
                return this.name;
            }

            @Override
            public String[] getFunctionNames() {
                return new String[0];
            }

            @Override
            public Object invokeFunction(String name, Object[] arguments) {
                return null;
            }

            @Override
            public boolean hasItem(int index) {
                return false;
            }

            @Override
            public String[] getPropertyNames() {
                return new String[]{"name", "type", "initialValue", "secured"};
            }

            @Override
            public boolean hasEntry(String name) {
                return "name".equals(name) || "type".equals(name) || "initalValue".equals(name) || "secured".equals(name);
            }

            @Override
            public Object getItem(int index) {
                return null;
            }

            @Override
            public Object getEntry(String name) {
                if ("name".equals(name)) {
                    return this.name;
                }
                if ("type".equals(name)) {
                    return this.getType();
                }
                if ("initalValue".equals(name)) {
                    return this.initalValue;
                }
                if ("secured".equals(name)) {
                    return new Boolean(this.secured);
                }
                return null;
            }

            @Override
            public boolean setItem(int index, Object value) {
                return false;
            }

            @Override
            public boolean setEntry(String name, Object value) {
                return false;
            }

            @Override
            public boolean clearItem(int index) {
                return false;
            }

            @Override
            public boolean clearEntry(String name) {
                return false;
            }

            public String toString() {
                return this.name;
            }

            @Override
            public boolean isMutable() {
                return false;
            }
        }
    }
}

