/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.services;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.vtp.framework.common.IArrayObject;
import org.eclipse.vtp.framework.common.IBooleanObject;
import org.eclipse.vtp.framework.common.IDataObject;
import org.eclipse.vtp.framework.common.IDataType;
import org.eclipse.vtp.framework.common.IDataTypeRegistry;
import org.eclipse.vtp.framework.common.IDateObject;
import org.eclipse.vtp.framework.common.IDecimalObject;
import org.eclipse.vtp.framework.common.ILastResult;
import org.eclipse.vtp.framework.common.IMapObject;
import org.eclipse.vtp.framework.common.INumberObject;
import org.eclipse.vtp.framework.common.IScriptable;
import org.eclipse.vtp.framework.common.IStringObject;
import org.eclipse.vtp.framework.common.IVariableRegistry;
import org.eclipse.vtp.framework.common.IVariableStorage;
import org.eclipse.vtp.framework.common.services.DataObject;
import org.eclipse.vtp.framework.common.support.CustomDataField;
import org.eclipse.vtp.framework.common.support.CustomDataType;
import org.eclipse.vtp.framework.core.ILogger;
import org.eclipse.vtp.framework.core.ISessionContext;
import org.eclipse.vtp.framework.util.DateHelper;

public class VariableRegistry
implements IVariableRegistry,
IScriptable,
IVariableStorage {
    private final ISessionContext context;
    private final IDataTypeRegistry dataTypeRegistry;
    private final Map<String, IDataObject> variables = new HashMap<String, IDataObject>();
    private final ILastResult lastResult;

    public VariableRegistry(ISessionContext context, IDataTypeRegistry dataTypeRegistry, ILastResult lastResult) {
        this.context = context;
        this.dataTypeRegistry = dataTypeRegistry;
        this.lastResult = lastResult;
    }

    @Override
    public ILogger getLogger() {
        return this.context;
    }

    private IDataObject createObject(IDataType type, boolean secured) {
        return this.createObject(type, null, secured);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDataObject createObject(IDataType type, String id) {
        IDataObject variable = null;
        variable = type.equals(this.dataTypeRegistry.getDataType(type.getName())) ? (type.isExternalType() ? type.getExternalFactory().createInstance(this, type, null) : ("Array".equals(type.getName()) ? new ArrayObject(id) : ("Map".equals(type.getName()) ? new MapObject(id) : ("Boolean".equals(type.getName()) ? new BooleanObject(id) : ("Date".equals(type.getName()) ? new DateObject(id) : ("Decimal".equals(type.getName()) ? new DecimalObject(id) : ("Number".equals(type.getName()) ? new NumberObject(id) : ("String".equals(type.getName()) ? new StringObject(id) : new ComplexObject(type))))))))) : new ComplexObject(type);
        Map<String, IDataObject> map = this.variables;
        synchronized (map) {
            this.variables.put(variable.getId(), variable);
        }
        return variable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDataObject createObject(IDataType type, Object initialValue, boolean secured) {
        IDataObject variable = null;
        variable = type.equals(this.dataTypeRegistry.getDataType(type.getName())) ? (type.isExternalType() ? type.getExternalFactory().createInstance(this, type, null) : ("Array".equals(type.getName()) ? new ArrayObject() : ("Map".equals(type.getName()) ? new MapObject() : ("Boolean".equals(type.getName()) ? new BooleanObject(initialValue) : ("Date".equals(type.getName()) ? new DateObject(initialValue) : ("Decimal".equals(type.getName()) ? new DecimalObject(initialValue) : ("Number".equals(type.getName()) ? new NumberObject(initialValue) : ("String".equals(type.getName()) ? new StringObject(initialValue) : new ComplexObject(type))))))))) : new ComplexObject(type);
        variable.setSecured(secured);
        Map<String, IDataObject> map = this.variables;
        synchronized (map) {
            this.variables.put(variable.getId(), variable);
        }
        return variable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDataObject loadObject(String id) {
        IDataObject variable = null;
        Map<String, IDataObject> map = this.variables;
        synchronized (map) {
            Object[] record;
            variable = this.variables.get(id);
            if (variable == null && (record = this.getRecord(id)) != null) {
                IDataType type = (IDataType)record[0];
                variable = type.isExternalType() ? type.getExternalFactory().createInstance(this, type, id) : ("Array".equals(type.getName()) ? new ArrayObject(id) : ("Map".equals(type.getName()) ? new MapObject(id) : ("Boolean".equals(type.getName()) ? new BooleanObject(id) : ("Date".equals(type.getName()) ? new DateObject(id) : ("Decimal".equals(type.getName()) ? new DecimalObject(id) : ("Number".equals(type.getName()) ? new NumberObject(id) : ("String".equals(type.getName()) ? new StringObject(id) : new ComplexObject(id, type))))))));
                this.variables.put(id, variable);
            }
        }
        return variable;
    }

    @Override
    public Object[] getRecord(String id) {
        Object attribute = this.context.getAttribute(id);
        if (!(attribute instanceof Object[])) {
            return null;
        }
        Object[] record = (Object[])attribute;
        if (record.length != 2) {
            return null;
        }
        if (!(record[0] instanceof String)) {
            return null;
        }
        String typeName = (String)record[0];
        if (typeName.startsWith("!")) {
            CustomDataType type = null;
            String[] array = typeName.substring(0).split(",");
            CustomDataField[] fields = new CustomDataField[array.length - 2];
            int i = 2;
            while (i < array.length) {
                String[] field = array[i].split(":", -1);
                fields[i - 2] = new CustomDataField(field[0], this.dataTypeRegistry.getDataType(field[1]), field[2], Boolean.parseBoolean(field[3]));
                ++i;
            }
            type = new CustomDataType(array[0], array[1].length() == 0 ? null : array[1], fields);
            return new Object[]{type, record[1]};
        }
        IDataType type = this.dataTypeRegistry.getDataType(typeName);
        if (type == null) {
            return null;
        }
        return new Object[]{type, record[1]};
    }

    @Override
    public void setRecord(String id, IDataType type, Object value) {
        if (type.equals(this.dataTypeRegistry.getDataType(type.getName()))) {
            this.context.setAttribute(id, (Object)new Object[]{type.getName(), value});
        } else {
            StringBuffer b = new StringBuffer("!");
            b.append(type.getName());
            b.append(',');
            if (type.getPrimaryFieldName() != null) {
                b.append(type.getPrimaryFieldName());
            }
            String[] fields = type.getFieldNames();
            int i = 0;
            while (i < fields.length) {
                b.append(',');
                b.append(fields[i]);
                b.append(':');
                b.append(type.getFieldType(fields[i]).getName());
                b.append(':');
                b.append(type.getFieldInitialValue(fields[i]));
                b.append(':');
                b.append(Boolean.toString(type.isFieldSecured(fields[i])));
                ++i;
            }
            this.context.setAttribute(id, (Object)new Object[]{b.toString(), value});
        }
    }

    @Override
    public final IDataObject createVariable(String typeName) throws IllegalArgumentException, NullPointerException {
        return this.createVariable(typeName, false);
    }

    @Override
    public final IDataObject createVariable(String typeName, boolean secured) throws IllegalArgumentException, NullPointerException {
        IDataType type = this.dataTypeRegistry.getDataType(typeName);
        if (type == null) {
            throw new IllegalArgumentException("typeName: " + typeName);
        }
        return this.createVariable(type, secured);
    }

    @Override
    public final IDataObject createVariable(String typeName, String id) throws IllegalArgumentException, NullPointerException {
        IDataType type = this.dataTypeRegistry.getDataType(typeName);
        if (type == null) {
            throw new IllegalArgumentException("typeName: " + typeName);
        }
        return this.createVariable(type, id);
    }

    @Override
    public final IDataObject createVariable(IDataType type) throws IllegalArgumentException, NullPointerException {
        return this.createVariable(type, false);
    }

    @Override
    public final IDataObject createVariable(IDataType type, boolean secured) throws IllegalArgumentException, NullPointerException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        return this.createObject(type, secured);
    }

    @Override
    public final IDataObject createVariable(IDataType type, String id) throws IllegalArgumentException, NullPointerException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        return this.createObject(type, id);
    }

    @Override
    public final String[] getVariableNames() {
        String[] storageKeys = this.context.getAttributeNames();
        LinkedList<String> variableNames = new LinkedList<String>();
        int i = 0;
        while (i < storageKeys.length) {
            if (storageKeys[i].startsWith("variable.entries.")) {
                variableNames.add(storageKeys[i].substring("variable.entries.".length()));
            }
            ++i;
        }
        return variableNames.toArray(new String[variableNames.size()]);
    }

    @Override
    public final IDataObject getVariable(String name) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        StringTokenizer st = new StringTokenizer(name, ".");
        if (!st.hasMoreTokens()) {
            return null;
        }
        String rootName = st.nextToken();
        String id = (String)this.context.getAttribute("variable.entries." + rootName);
        if (id == null) {
            return null;
        }
        IDataObject variable = this.loadObject(id);
        while (variable != null && st.hasMoreTokens()) {
            variable = variable.getField(st.nextToken());
        }
        return variable;
    }

    @Override
    public final void setVariable(String name, IDataObject variable) throws IllegalArgumentException, NullPointerException {
        StringTokenizer st;
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (variable == null) {
            throw new NullPointerException("variable");
        }
        IDataObject currentObject = this.getVariable(name);
        if (currentObject != null && currentObject.isSecured()) {
            variable.setSecured(true);
        }
        if (!(st = new StringTokenizer(name, ".")).hasMoreTokens()) {
            return;
        }
        String rootName = st.nextToken();
        if (!st.hasMoreTokens()) {
            this.context.setAttribute("variable.entries." + rootName, (Object)variable.getId());
        } else {
            String id = (String)this.context.getAttribute("variable.entries." + st.nextToken());
            if (id == null) {
                return;
            }
            IDataObject parent = this.loadObject(id);
            String childName = st.nextToken();
            while (parent != null && st.hasMoreTokens()) {
                parent = parent.getField(childName);
                childName = st.nextToken();
            }
            if (parent != null) {
                parent.setField(childName, variable);
            }
        }
    }

    @Override
    public final void clearVariable(String name) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.context.clearAttribute("variable.entries." + name);
    }

    @Override
    public final String getName() {
        return "Variables";
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public Object toValue() {
        return null;
    }

    @Override
    public String[] getPropertyNames() {
        return new String[0];
    }

    @Override
    public String[] getFunctionNames() {
        return new String[]{"create"};
    }

    @Override
    public final Object invokeFunction(String name, Object[] arguments) {
        if ("create".equals(name)) {
            if (arguments.length < 1) {
                return null;
            }
            IDataType type = null;
            type = arguments[0] instanceof IDataType ? (IDataType)arguments[0] : this.dataTypeRegistry.getDataType(String.valueOf(arguments[0]));
            if (type == null) {
                return null;
            }
            return this.createVariable(type);
        }
        return null;
    }

    @Override
    public final boolean hasItem(int index) {
        return false;
    }

    @Override
    public final boolean hasEntry(String name) {
        return "LastResult".equals(name) || this.getVariable(name) != null;
    }

    @Override
    public final Object getItem(int index) {
        return null;
    }

    @Override
    public final Object getEntry(String name) {
        if ("LastResult".equals(name)) {
            return this.lastResult;
        }
        return this.getVariable(name);
    }

    @Override
    public final boolean setItem(int index, Object value) {
        return false;
    }

    @Override
    public final boolean setEntry(String name, Object value) {
        if ("LastResult".equals(name)) {
            return false;
        }
        if (value == null) {
            return this.clearEntry(name);
        }
        if (value instanceof IDataObject) {
            this.setVariable(name, (IDataObject)value);
            return true;
        }
        IDataObject variable = this.getVariable(name);
        if (variable == null) {
            variable = this.createVariable("String");
            this.setVariable(name, variable);
        }
        if (variable instanceof SimpleObject) {
            ((SimpleObject)variable).setEntry("value", value);
        }
        return true;
    }

    @Override
    public final boolean clearItem(int index) {
        return false;
    }

    @Override
    public final boolean clearEntry(String name) {
        this.clearVariable(name);
        return true;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    private final class ArrayObject
    extends DataObject
    implements IArrayObject {
        final NumberObject lengthField;

        ArrayObject() {
            super(VariableRegistry.this, null, VariableRegistry.this.dataTypeRegistry.getDataType("Array"));
            this.lengthField = new NumberObject(VariableRegistry.this){

                @Override
                public boolean isReadOnly() {
                    return true;
                }

                @Override
                public Integer getValue() {
                    return new Integer(((String[])ArrayObject.this.load()).length);
                }
            };
            this.save(new String[0]);
        }

        ArrayObject(String id) {
            super(VariableRegistry.this, id, VariableRegistry.this.dataTypeRegistry.getDataType("Array"));
            this.lengthField = new /* invalid duplicate definition of identical inner class */;
            if (this.load() == null) {
                this.save(new String[0]);
            }
        }

        @Override
        public INumberObject getLength() {
            return this.lengthField;
        }

        @Override
        public IDataObject getElement(int index) throws IndexOutOfBoundsException {
            if (index < 0) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            String[] itemIDs = (String[])this.load();
            if (index >= itemIDs.length) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            return itemIDs[index] == null ? null : VariableRegistry.this.loadObject(itemIDs[index]);
        }

        @Override
        public void addElement(IDataObject item) throws IllegalArgumentException, IllegalStateException {
            if (item != null && !(item instanceof DataObject)) {
                throw new IllegalArgumentException("item");
            }
            String[] oldIDs = (String[])this.load();
            String[] newIDs = new String[oldIDs.length + 1];
            System.arraycopy(oldIDs, 0, newIDs, 0, oldIDs.length);
            newIDs[oldIDs.length] = item == null ? null : item.getId();
            this.save(newIDs);
        }

        @Override
        public void insertElement(int index, IDataObject item) throws IllegalArgumentException, IllegalStateException, IndexOutOfBoundsException {
            if (index < 0) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            if (item != null && !(item instanceof DataObject)) {
                throw new IllegalArgumentException("item");
            }
            String[] oldIDs = (String[])this.load();
            if (index > oldIDs.length) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            String[] newIDs = new String[oldIDs.length + 1];
            if (index > 0) {
                System.arraycopy(oldIDs, 0, newIDs, 0, index);
            }
            String string = newIDs[index] = item == null ? null : item.getId();
            if (index < oldIDs.length) {
                System.arraycopy(oldIDs, index, newIDs, index + 1, oldIDs.length - index);
            }
            this.save(newIDs);
        }

        @Override
        public void setElement(int index, IDataObject item) throws IllegalArgumentException, IllegalStateException, IndexOutOfBoundsException {
            if (index < 0) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            if (item != null && !(item instanceof DataObject)) {
                throw new IllegalArgumentException("item");
            }
            String[] oldIDs = (String[])this.load();
            if (index >= oldIDs.length) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            String[] newIDs = new String[oldIDs.length];
            System.arraycopy(oldIDs, 0, newIDs, 0, oldIDs.length);
            newIDs[index] = item == null ? null : item.getId();
            this.save(newIDs);
        }

        @Override
        public void removeElement(int index) throws IllegalStateException, IndexOutOfBoundsException {
            if (index < 0) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            String[] oldIDs = (String[])this.load();
            if (index >= oldIDs.length) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            String[] newIDs = new String[oldIDs.length - 1];
            if (index > 0) {
                System.arraycopy(oldIDs, 0, newIDs, 0, index);
            }
            if (index < newIDs.length) {
                System.arraycopy(oldIDs, index + 1, newIDs, index, newIDs.length - index);
            }
            this.save(newIDs);
        }

        @Override
        public IDataObject getField(String fieldName) {
            return "length".equals(fieldName) || "numberOfItems".equals(fieldName) ? this.lengthField : super.getField(fieldName);
        }

        @Override
        public boolean isEqualTo(Object object) {
            if (super.isEqualTo(object)) {
                return true;
            }
            if (!(object instanceof IArrayObject)) {
                return false;
            }
            IArrayObject other = (IArrayObject)object;
            String[] itemIDs = (String[])this.load();
            if (itemIDs.length != other.getLength().getValue()) {
                return false;
            }
            int i = 0;
            while (i < itemIDs.length) {
                IDataObject theirs;
                IDataObject ours = itemIDs[i] == null ? null : VariableRegistry.this.loadObject(itemIDs[i]);
                if (ours != (theirs = other.getElement(i))) {
                    if (ours == null || theirs == null) {
                        return false;
                    }
                    if (!ours.isEqualTo(theirs)) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }

        @Override
        public boolean hasItem(int index) {
            return index >= 0 && index < ((String[])this.load()).length;
        }

        @Override
        public Object getItem(int index) {
            try {
                return this.getElement(index);
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }

        @Override
        public boolean setItem(int index, Object value) {
            if (!(value instanceof IDataObject)) {
                try {
                    IStringObject dataObject = (IStringObject)VariableRegistry.this.createVariable("String");
                    dataObject.setValue(value);
                    value = dataObject;
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (index == ((String[])this.load()).length) {
                this.addElement((IDataObject)value);
                return true;
            }
            try {
                this.setElement(index, (IDataObject)value);
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
            return true;
        }

        @Override
        public boolean clearItem(int index) {
            try {
                this.removeElement(index);
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
            return true;
        }

        @Override
        public String toString() {
            StringBuffer buffer = new StringBuffer().append('[');
            String[] itemIDs = (String[])this.load();
            int i = 0;
            while (i < itemIDs.length) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(itemIDs[i] == null ? null : VariableRegistry.this.loadObject(itemIDs[i]));
                ++i;
            }
            return buffer.append(']').toString();
        }

        @Override
        public String[] getFunctionNames() {
            List<String> superFunctionNames = Arrays.asList(super.getFunctionNames());
            ArrayList<String> functionNames = new ArrayList<String>();
            functionNames.addAll(superFunctionNames);
            functionNames.add("add");
            functionNames.add("remove");
            functionNames.add("insert");
            functionNames.add("removeObject");
            String[] retArray = new String[functionNames.size()];
            System.arraycopy(functionNames.toArray(), 0, retArray, 0, functionNames.size());
            return retArray;
        }

        @Override
        public Object invokeFunction(String name, Object[] arguments) throws Exception {
            if ("remove".equals(name)) {
                try {
                    return this.clearItem(Integer.parseInt((String)arguments[0]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                if ("add".equals(name)) {
                    return this.setItem(this.lengthField.getValue(), arguments[0]);
                }
                if ("insert".equals(name)) {
                    try {
                        if (arguments[1] instanceof IDataObject) {
                            this.insertElement(Integer.parseInt((String)arguments[0]), (IDataObject)arguments[1]);
                        } else {
                            IStringObject dataObject = (IStringObject)VariableRegistry.this.createVariable("String");
                            dataObject.setValue(arguments[1]);
                            IStringObject ido = dataObject;
                            this.insertElement(Integer.parseInt((String)arguments[0]), ido);
                        }
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if ("removeObject".equals(name)) {
                    try {
                        return this.removeObject(arguments[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return super.invokeFunction(name, arguments);
        }

        public boolean removeObject(Object obj) {
            if (!(obj instanceof IDataObject)) {
                return false;
            }
            String[] itemIDs = (String[])this.load();
            int b = 0;
            while (b < itemIDs.length) {
                IDataObject ido = VariableRegistry.this.loadObject(itemIDs[b]);
                if (ido.isEqualTo(obj)) {
                    return this.clearItem(b);
                }
                ++b;
            }
            return false;
        }
    }

    private final class BooleanObject
    extends SimpleObject<Boolean>
    implements IBooleanObject {
        BooleanObject() {
            super(null, VariableRegistry.this.dataTypeRegistry.getDataType("Boolean"));
        }

        BooleanObject(Object initialValue) {
            super(null, VariableRegistry.this.dataTypeRegistry.getDataType("Boolean"));
            if (!this.setValue(initialValue)) {
                this.setValue(null);
            }
        }

        BooleanObject(String id) {
            super(id, VariableRegistry.this.dataTypeRegistry.getDataType("Boolean"));
            if (this.getValue() == null) {
                this.setValue(null);
            }
        }

        @Override
        Boolean coerce(Object obj) {
            if (obj == null) {
                return Boolean.FALSE;
            }
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            if (obj instanceof IBooleanObject) {
                return ((IBooleanObject)obj).getValue();
            }
            if (obj instanceof Number) {
                return ((Number)obj).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            if (obj instanceof INumberObject) {
                return ((INumberObject)obj).getValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            String string = obj.toString();
            if ("true".equalsIgnoreCase(string)) {
                return Boolean.TRUE;
            }
            if ("yes".equalsIgnoreCase(string)) {
                return Boolean.TRUE;
            }
            if ("on".equalsIgnoreCase(string)) {
                return Boolean.TRUE;
            }
            if ("1".equalsIgnoreCase(string)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(string)) {
                return Boolean.FALSE;
            }
            if ("no".equalsIgnoreCase(string)) {
                return Boolean.FALSE;
            }
            if ("off".equalsIgnoreCase(string)) {
                return Boolean.FALSE;
            }
            if ("0".equalsIgnoreCase(string)) {
                return Boolean.FALSE;
            }
            return null;
        }

        @Override
        public Boolean getValue() {
            return (Boolean)this.load();
        }

        @Override
        public boolean setValue(Object value) throws IllegalStateException {
            Boolean coerced = this.coerce(value);
            if (coerced == null) {
                return false;
            }
            this.save(coerced);
            return true;
        }

        @Override
        public Object getEntry(String name) {
            if ("value".equals(name)) {
                return this.getValue();
            }
            return super.getEntry(name);
        }

        @Override
        public boolean setEntry(String name, Object value) {
            if ("value".equals(name)) {
                return this.setValue(value);
            }
            return super.setEntry(name, value);
        }
    }

    private final class ComplexObject
    extends DataObject {
        private final String[] fieldNames;

        ComplexObject(IDataType type) {
            super(VariableRegistry.this, null, type);
            this.fieldNames = type.getFieldNames();
            String[] fieldIDs = new String[this.fieldNames.length];
            int i = 0;
            while (i < this.fieldNames.length) {
                fieldIDs[i] = VariableRegistry.this.createObject(type.getFieldType(this.fieldNames[i]), type.getFieldInitialValue(this.fieldNames[i]), type.isFieldSecured(this.fieldNames[i])).getId();
                ++i;
            }
            this.save(fieldIDs);
        }

        ComplexObject(String id, IDataType type) {
            super(VariableRegistry.this, id, type);
            this.fieldNames = type.getFieldNames();
            String[] fieldIDs = (String[])this.load();
            if (fieldIDs == null) {
                fieldIDs = new String[this.fieldNames.length];
                int i = 0;
                while (i < this.fieldNames.length) {
                    fieldIDs[i] = VariableRegistry.this.createObject(type.getFieldType(this.fieldNames[i]), type.getFieldInitialValue(this.fieldNames[i]), type.isFieldSecured(this.fieldNames[i])).getId();
                    ++i;
                }
                this.save(fieldIDs);
            }
        }

        @Override
        public IDataObject getField(String fieldName) {
            int i = 0;
            while (i < this.fieldNames.length) {
                if (this.fieldNames[i].equals(fieldName)) {
                    String id = ((String[])this.load())[i];
                    if (id == null) {
                        return null;
                    }
                    return VariableRegistry.this.loadObject(id);
                }
                ++i;
            }
            return null;
        }

        @Override
        public boolean setField(String fieldName, IDataObject variable) {
            if (variable != null) {
                if (!(variable instanceof DataObject)) {
                    return false;
                }
                if (!variable.getType().equals(this.type.getFieldType(fieldName))) {
                    return false;
                }
            }
            int i = 0;
            while (i < this.fieldNames.length) {
                if (this.fieldNames[i].equals(fieldName)) {
                    if (this.type.isFieldSecured(fieldName)) {
                        variable.setSecured(this.type.isFieldSecured(fieldName));
                    }
                    String[] oldIDs = (String[])this.load();
                    String[] newIDs = new String[oldIDs.length];
                    System.arraycopy(oldIDs, 0, newIDs, 0, oldIDs.length);
                    newIDs[i] = variable == null ? null : variable.getId();
                    this.save(newIDs);
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public boolean isEqualTo(Object object) {
            if (super.isEqualTo(object)) {
                return true;
            }
            if (!(object instanceof IDataObject)) {
                return false;
            }
            IDataObject other = (IDataObject)object;
            if (!this.type.equals(other.getType())) {
                return false;
            }
            String[] fieldIDs = (String[])this.load();
            int i = 0;
            while (i < this.fieldNames.length) {
                IDataObject theirs;
                IDataObject ours = fieldIDs[i] == null ? null : VariableRegistry.this.loadObject(fieldIDs[i]);
                if (ours != (theirs = other.getField(this.fieldNames[i]))) {
                    if (ours == null || theirs == null) {
                        return false;
                    }
                    if (!ours.isEqualTo(theirs)) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }

        @Override
        public boolean hasValue() {
            return this.type.getPrimaryFieldName() != null;
        }

        @Override
        public Object toValue() {
            return this.getField(this.type.getPrimaryFieldName());
        }

        @Override
        public String[] getFunctionNames() {
            String[] superFunctions = super.getFunctionNames();
            String[] result = new String[superFunctions.length + 3];
            System.arraycopy(superFunctions, 0, result, 0, superFunctions.length);
            result[superFunctions.length] = "getFieldCount";
            result[superFunctions.length + 1] = "getFieldValue";
            result[superFunctions.length + 2] = "setFieldValue";
            return result;
        }

        @Override
        public Object invokeFunction(String name, Object[] arguments) throws Exception {
            if ("getFieldCount".equals(name)) {
                return this.fieldNames.length;
            }
            if (arguments.length == 1 && "getFieldValue".equals(name)) {
                String fieldName = this.coerceFieldName(arguments[0]);
                return fieldName == null ? null : this.getEntry(fieldName);
            }
            if (arguments.length == 2 && "setFieldValue".equals(name)) {
                String fieldName = this.coerceFieldName(arguments[0]);
                return fieldName == null ? null : Boolean.valueOf(this.setEntry(fieldName, arguments[1]));
            }
            return super.invokeFunction(name, arguments);
        }

        private String coerceFieldName(Object obj) {
            int index = -1;
            if (obj instanceof Number) {
                index = ((Number)obj).intValue();
            } else if (obj instanceof INumberObject) {
                index = ((INumberObject)obj).getValue();
            } else {
                try {
                    index = Integer.parseInt(obj.toString());
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            return index < 0 || index >= this.fieldNames.length ? null : this.fieldNames[index];
        }

        @Override
        public String toString() {
            StringBuffer buffer = new StringBuffer(this.type.getName()).append('{');
            String[] fieldIDs = (String[])this.load();
            int i = 0;
            while (i < this.fieldNames.length) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(this.fieldNames[i]).append('=').append(fieldIDs[i] == null ? null : VariableRegistry.this.loadObject(fieldIDs[i]));
                ++i;
            }
            return buffer.append('}').toString();
        }
    }

    private final class DateObject
    extends SimpleObject<Calendar>
    implements IDateObject {
        DateObject() {
            super(null, VariableRegistry.this.dataTypeRegistry.getDataType("Date"));
        }

        DateObject(Object initialValue) {
            super(null, VariableRegistry.this.dataTypeRegistry.getDataType("Date"));
            if (!this.setValue(initialValue)) {
                this.setValue(null);
            }
        }

        DateObject(String id) {
            super(id, VariableRegistry.this.dataTypeRegistry.getDataType("Date"));
        }

        @Override
        Calendar coerce(Object obj) {
            Calendar cal = Calendar.getInstance();
            if (obj == null) {
                return cal;
            }
            if (obj instanceof Calendar) {
                return (Calendar)obj;
            }
            if (obj instanceof Date) {
                cal.setTime((Date)obj);
                return cal;
            }
            if (obj instanceof Long) {
                cal.setTimeInMillis((Long)obj);
                return cal;
            }
            if (obj instanceof IDateObject) {
                return ((IDateObject)obj).getValue();
            }
            if (obj instanceof String) {
                String inValue = (String)obj;
                VariableRegistry.this.context.debug("So the date is supposed to be: " + inValue);
                cal = DateHelper.parseDate((String)inValue);
                return cal;
            }
            return null;
        }

        @Override
        public Calendar getValue() {
            Calendar cal = Calendar.getInstance();
            String val = (String)this.load();
            cal = DateHelper.parseDate((String)val);
            return cal;
        }

        @Override
        public boolean setValue(Object value) throws IllegalStateException {
            Calendar cal = this.coerce(value);
            if (cal == null) {
                return false;
            }
            this.save(DateHelper.toDateString((Calendar)cal));
            return true;
        }

        @Override
        public Object getEntry(String name) {
            if ("value".equals(name)) {
                return this.getValue();
            }
            return super.getEntry(name);
        }

        @Override
        public boolean setEntry(String name, Object value) {
            if ("value".equals(name)) {
                return this.setValue(value);
            }
            return super.setEntry(name, value);
        }

        @Override
        public String toString() {
            Calendar cal = this.getValue();
            return DateHelper.toDateString((Calendar)cal);
        }
    }

    private final class DecimalObject
    extends SimpleObject<BigDecimal>
    implements IDecimalObject {
        DecimalObject() {
            super(null, VariableRegistry.this.dataTypeRegistry.getDataType("Decimal"));
        }

        DecimalObject(Object initialValue) {
            super(null, VariableRegistry.this.dataTypeRegistry.getDataType("Decimal"));
            if (!this.setValue(initialValue)) {
                this.setValue(null);
            }
        }

        DecimalObject(String id) {
            super(id, VariableRegistry.this.dataTypeRegistry.getDataType("Decimal"));
            if (this.getValue() == null) {
                this.setValue(null);
            }
        }

        @Override
        BigDecimal coerce(Object obj) {
            if (obj == null) {
                return BigDecimal.valueOf(0L);
            }
            if (obj instanceof BigDecimal) {
                return (BigDecimal)obj;
            }
            if (obj instanceof BigInteger) {
                new BigDecimal((BigInteger)obj);
            }
            if (obj instanceof Float || obj instanceof Double) {
                return BigDecimal.valueOf(((Number)obj).doubleValue());
            }
            if (obj instanceof Number) {
                return BigDecimal.valueOf(((Number)obj).longValue());
            }
            if (obj instanceof IDecimalObject) {
                return ((IDecimalObject)obj).getValue();
            }
            if (obj instanceof INumberObject) {
                return BigDecimal.valueOf(((INumberObject)obj).getValue().longValue());
            }
            try {
                return new BigDecimal(obj.toString());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        @Override
        public BigDecimal getValue() {
            return (BigDecimal)this.load();
        }

        @Override
        public boolean setValue(Object value) throws IllegalStateException {
            BigDecimal coerced = this.coerce(value);
            if (coerced == null) {
                return false;
            }
            this.save(coerced);
            return true;
        }

        @Override
        public Object getEntry(String name) {
            if ("value".equals(name)) {
                return this.getValue();
            }
            return super.getEntry(name);
        }

        @Override
        public boolean setEntry(String name, Object value) {
            if ("value".equals(name)) {
                return this.setValue(value);
            }
            return super.setEntry(name, value);
        }
    }

    private final class MapObject
    extends DataObject
    implements IMapObject {
        MapObject() {
            super(VariableRegistry.this, null, VariableRegistry.this.dataTypeRegistry.getDataType("Map"));
            this.save(new String[0]);
        }

        MapObject(String id) {
            super(VariableRegistry.this, id, VariableRegistry.this.dataTypeRegistry.getDataType("Map"));
            if (this.load() == null) {
                this.save(new String[0]);
            }
        }

        @Override
        public String[] getPropertyNames() {
            ArrayList<String> propNames = new ArrayList<String>();
            String[] oldIDs = (String[])this.load();
            int i = 0;
            while (i < oldIDs.length - 1) {
                propNames.add(oldIDs[i]);
                i += 2;
            }
            return propNames.toArray(new String[propNames.size()]);
        }

        @Override
        public INumberObject getSize() {
            INumberObject size = (INumberObject)VariableRegistry.this.createVariable("Number");
            size.setValue(new Integer(((String[])this.load()).length / 2));
            return size;
        }

        @Override
        public IDataObject getField(String key) {
            if (key == null) {
                throw new IllegalArgumentException("Key cannot be NULL.");
            }
            String[] tuples = (String[])this.load();
            if (tuples.length % 2 != 0) {
                throw new IllegalStateException("The map has become inconsistent.");
            }
            int i = 0;
            while (i < tuples.length - 1) {
                if (tuples[i].equals(key)) {
                    return VariableRegistry.this.loadObject(tuples[i + 1]);
                }
                i += 2;
            }
            return super.getField(key);
        }

        @Override
        public boolean setField(String key, IDataObject item) {
            if (key == null) {
                throw new IllegalArgumentException("Key cannot be NULL.");
            }
            if (item != null && !(item instanceof DataObject)) {
                throw new IllegalArgumentException("item");
            }
            String[] oldIDs = (String[])this.load();
            int i = 0;
            while (i < oldIDs.length - 1) {
                if (key.equals(oldIDs[i])) {
                    oldIDs[i + 1] = item == null ? null : item.getId();
                    this.save(oldIDs);
                    return true;
                }
                i += 2;
            }
            String[] newIDs = new String[oldIDs.length + 2];
            System.arraycopy(oldIDs, 0, newIDs, 0, oldIDs.length);
            newIDs[oldIDs.length] = key;
            newIDs[oldIDs.length + 1] = item == null ? null : item.getId();
            this.save(newIDs);
            return true;
        }

        @Override
        public boolean setEntry(String name, Object value) {
            if (value instanceof IDataObject) {
                return this.setField(name, (IDataObject)value);
            }
            IDataObject variable = this.getField(name);
            if (variable == null) {
                variable = VariableRegistry.this.createVariable("String");
                this.setField(name, variable);
            }
            if (variable instanceof SimpleObject) {
                ((SimpleObject)variable).setEntry("value", value);
            }
            return true;
        }

        @Override
        public Map<String, IDataObject> getValues() {
            HashMap<String, IDataObject> ret = new HashMap<String, IDataObject>();
            String[] oldIDs = (String[])this.load();
            int i = 0;
            while (i < oldIDs.length - 1) {
                ret.put(oldIDs[i], VariableRegistry.this.loadObject(oldIDs[i + 1]));
                i += 2;
            }
            return ret;
        }

        @Override
        public void removeElement(String key) throws IllegalStateException, IndexOutOfBoundsException {
            if (key == null) {
                throw new IllegalArgumentException("Key cannot be NULL.");
            }
            String[] oldIDs = (String[])this.load();
            int i = 0;
            while (i < oldIDs.length - 1) {
                if (oldIDs[i].equals(key)) {
                    String[] newIDs = new String[oldIDs.length - 2];
                    if (i > 0) {
                        System.arraycopy(oldIDs, 0, newIDs, 0, i);
                    }
                    if (oldIDs.length - 2 - i > 0) {
                        System.arraycopy(oldIDs, i + 2, newIDs, i, oldIDs.length - 2 - i);
                    }
                    this.save(newIDs);
                    return;
                }
                i += 2;
            }
        }

        @Override
        public boolean isEqualTo(Object object) {
            if (super.isEqualTo(object)) {
                return true;
            }
            if (!(object instanceof IMapObject)) {
                return false;
            }
            IMapObject other = (IMapObject)object;
            return other == this;
        }

        @Override
        public String toString() {
            StringBuffer buffer = new StringBuffer().append('[');
            String[] itemIDs = (String[])this.load();
            int i = 0;
            while (i < itemIDs.length) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(itemIDs[i] == null ? null : VariableRegistry.this.loadObject(itemIDs[i]));
                ++i;
            }
            return buffer.append(']').toString();
        }

        @Override
        public String[] getFunctionNames() {
            List<String> superFunctionNames = Arrays.asList(super.getFunctionNames());
            ArrayList<String> functionNames = new ArrayList<String>();
            functionNames.addAll(superFunctionNames);
            functionNames.add("put");
            functionNames.add("get");
            functionNames.add("remove");
            functionNames.add("size");
            String[] retArray = new String[functionNames.size()];
            System.arraycopy(functionNames.toArray(), 0, retArray, 0, functionNames.size());
            return retArray;
        }

        @Override
        public Object invokeFunction(String name, Object[] arguments) throws Exception {
            if ("remove".equals(name)) {
                try {
                    this.removeElement((String)arguments[0]);
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if ("put".equals(name)) {
                try {
                    return this.setField((String)arguments[0], (IDataObject)arguments[1]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if ("get".equals(name)) {
                try {
                    return this.getField((String)arguments[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if ("size".equals(name)) {
                return this.getSize();
            }
            return super.invokeFunction(name, arguments);
        }
    }

    private class NumberObject
    extends SimpleObject<Integer>
    implements INumberObject {
        NumberObject() {
            super(null, VariableRegistry.this.dataTypeRegistry.getDataType("Number"));
        }

        NumberObject(Object initialValue) {
            super(null, VariableRegistry.this.dataTypeRegistry.getDataType("Number"));
            if (!this.setValue(initialValue)) {
                this.setValue(null);
            }
        }

        NumberObject(String id) {
            super(id, VariableRegistry.this.dataTypeRegistry.getDataType("Number"));
            if (this.getValue() == null) {
                this.setValue(null);
            }
        }

        @Override
        Integer coerce(Object obj) {
            if (obj == null) {
                return new Integer(0);
            }
            if (obj instanceof Integer) {
                return (Integer)obj;
            }
            if (obj instanceof Number) {
                return new Integer(((Number)obj).intValue());
            }
            if (obj instanceof INumberObject) {
                return ((INumberObject)obj).getValue();
            }
            try {
                return new Integer(obj.toString());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public Integer getValue() {
            return (Integer)this.load();
        }

        @Override
        public boolean setValue(Object value) throws IllegalStateException {
            Integer coerced = this.coerce(value);
            if (coerced == null) {
                return false;
            }
            this.save(coerced);
            return true;
        }

        @Override
        public Object getEntry(String name) {
            if ("value".equals(name)) {
                return this.getValue();
            }
            return super.getEntry(name);
        }

        @Override
        public boolean setEntry(String name, Object value) {
            if ("value".equals(name)) {
                return this.setValue(value);
            }
            return super.setEntry(name, value);
        }
    }

    private abstract class SimpleObject<T extends Comparable<T>>
    extends DataObject {
        SimpleObject(String id, IDataType type) {
            super(VariableRegistry.this, id, type);
        }

        abstract T coerce(Object var1);

        @Override
        public final boolean isEqualTo(Object object) {
            if (super.isEqualTo(object)) {
                return true;
            }
            if (object == null) {
                return false;
            }
            Object other = this.coerce(object);
            if (other == null) {
                return false;
            }
            return other.compareTo((Object)this.toValue()) == 0;
        }

        @Override
        public final boolean isGreaterThan(Object object) {
            if (object == this) {
                return false;
            }
            if (object == null) {
                return false;
            }
            Object other = this.coerce(object);
            if (other == null) {
                return false;
            }
            return other.compareTo((Object)this.toValue()) < 0;
        }

        @Override
        public final boolean isGreaterThanOrEqualTo(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            Object other = this.coerce(object);
            if (other == null) {
                return false;
            }
            return other.compareTo((Object)this.toValue()) <= 0;
        }

        @Override
        public final boolean isLessThan(Object object) {
            if (object == this) {
                return false;
            }
            if (object == null) {
                return false;
            }
            Object other = this.coerce(object);
            if (other == null) {
                return false;
            }
            return other.compareTo((Object)this.toValue()) > 0;
        }

        @Override
        public final boolean isLessThanOrEqualTo(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            Object other = this.coerce(object);
            if (other == null) {
                return false;
            }
            return other.compareTo((Object)this.toValue()) >= 0;
        }

        @Override
        public boolean hasValue() {
            return true;
        }

        public T toValue() {
            return (T)((Comparable)this.getEntry("value"));
        }

        @Override
        public final boolean hasEntry(String name) {
            return "value".equals(name) || super.hasEntry(name);
        }

        @Override
        public final boolean clearEntry(String name) {
            if ("value".equals(name)) {
                return this.setEntry(name, null);
            }
            return super.clearEntry(name);
        }

        @Override
        public String toString() {
            return String.valueOf(this.toValue());
        }
    }

    private final class StringObject
    extends SimpleObject<String>
    implements IStringObject {
        final NumberObject lengthField;

        StringObject() {
            super(null, VariableRegistry.this.dataTypeRegistry.getDataType("String"));
            this.lengthField = new NumberObject(VariableRegistry.this){

                @Override
                public boolean isReadOnly() {
                    return true;
                }

                @Override
                public Integer getValue() {
                    return new Integer(StringObject.this.getValue().length());
                }
            };
        }

        StringObject(Object initialValue) {
            super(null, VariableRegistry.this.dataTypeRegistry.getDataType("String"));
            this.lengthField = new /* invalid duplicate definition of identical inner class */;
            if (!this.setValue(initialValue)) {
                this.setValue(null);
            }
        }

        StringObject(String id) {
            super(id, VariableRegistry.this.dataTypeRegistry.getDataType("String"));
            this.lengthField = new /* invalid duplicate definition of identical inner class */;
            if (this.getValue() == null) {
                this.setValue(null);
            }
        }

        @Override
        String coerce(Object obj) {
            if (obj == null) {
                return new String();
            }
            if (obj instanceof IStringObject) {
                return ((IStringObject)obj).getValue();
            }
            return obj.toString();
        }

        @Override
        public INumberObject getLength() {
            return this.lengthField;
        }

        @Override
        public String getValue() {
            return (String)this.load();
        }

        @Override
        public boolean setValue(Object value) throws IllegalStateException {
            String coerced = this.coerce(value);
            if (coerced == null) {
                return false;
            }
            this.save(coerced);
            return true;
        }

        @Override
        public IDataObject getField(String fieldName) {
            return "length".equals(fieldName) ? this.lengthField : super.getField(fieldName);
        }

        @Override
        public Object getEntry(String name) {
            if ("value".equals(name)) {
                return this.getValue();
            }
            return super.getEntry(name);
        }

        @Override
        public boolean setEntry(String name, Object value) {
            if ("value".equals(name)) {
                return this.setValue(value);
            }
            return super.setEntry(name, value);
        }
    }
}

