/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.databases.configurations;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.databases.configurations.DatabaseConstants;
import org.eclipse.vtp.framework.databases.configurations.DatabaseTableConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DatabaseConfiguration
implements IConfiguration,
DatabaseConstants {
    private String name = "";
    private String username = null;
    private String password = null;
    private Set<DatabaseTableConfiguration> tables = new LinkedHashSet<DatabaseTableConfiguration>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public DatabaseTableConfiguration[] getTables() {
        return this.tables.toArray(new DatabaseTableConfiguration[this.tables.size()]);
    }

    public void addTable(DatabaseTableConfiguration table) {
        if (table != null) {
            this.tables.add(table);
        }
    }

    public void removeTable(DatabaseTableConfiguration table) {
        if (table != null) {
            this.tables.remove(table);
        }
    }

    public void load(Element configurationElement) {
        this.name = configurationElement.getAttribute("name");
        this.username = configurationElement.hasAttribute("username") ? configurationElement.getAttribute("username") : null;
        this.password = configurationElement.hasAttribute("password") ? configurationElement.getAttribute("password") : null;
        this.tables.clear();
        NodeList list = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/databases/configurations", "table");
        int i = 0;
        while (i < list.getLength()) {
            Element element = (Element)list.item(i);
            DatabaseTableConfiguration item = new DatabaseTableConfiguration();
            item.load(element);
            this.tables.add(item);
            ++i;
        }
    }

    public void save(Element configurationElement) {
        configurationElement.setAttribute("name", this.name);
        if (this.username != null) {
            configurationElement.setAttribute("username", this.username);
        }
        if (this.password != null) {
            configurationElement.setAttribute("password", this.password);
        }
        String tableName = "table";
        String prefix = configurationElement.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            tableName = String.valueOf(prefix) + ":" + tableName;
        }
        for (DatabaseTableConfiguration item : this.tables) {
            Element element = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/databases/configurations", tableName);
            item.save(element);
            configurationElement.appendChild(element);
        }
    }
}

