/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.databases.configurations;

import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.databases.configurations.DatabaseConstants;
import org.w3c.dom.Element;

public class DatabaseCriteriaConfiguration
implements IConfiguration,
DatabaseConstants {
    public static final int COMPARISON_EQUAL = 0;
    public static final int COMPARISON_NOT_EQUAL = 1;
    public static final int COMPARISON_LESS_THAN = 2;
    public static final int COMPARISON_LESS_THAN_OR_EQUAL = 3;
    public static final int COMPARISON_GREATER_THAN = 4;
    public static final int COMPARISON_GREATER_THAN_OR_EQUAL = 5;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_VARIABLE = 1;
    public static final int TYPE_STATIC = 2;
    private String name = "";
    private int comparison = -1;
    private int type = -1;
    private String value = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public int getComparison() {
        return this.comparison;
    }

    public void setComparison(int comparison) {
        this.comparison = comparison;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void load(Element configurationElement) {
        this.name = configurationElement.getAttribute("name");
        String comparisonStr = configurationElement.getAttribute("comparison");
        this.comparison = "not-equal".equalsIgnoreCase(comparisonStr) ? 1 : ("less-than".equalsIgnoreCase(comparisonStr) ? 2 : ("less-than-or-equal".equalsIgnoreCase(comparisonStr) ? 3 : ("greater-than".equalsIgnoreCase(comparisonStr) ? 4 : ("greater-than-or-equal".equalsIgnoreCase(comparisonStr) ? 5 : 0))));
        String typeStr = configurationElement.getAttribute("type");
        this.type = "variable".equalsIgnoreCase(typeStr) ? 1 : ("static".equalsIgnoreCase(typeStr) ? 2 : 0);
        this.value = configurationElement.hasAttribute("value") ? configurationElement.getAttribute("value") : null;
    }

    public void save(Element configurationElement) {
        configurationElement.setAttribute("name", this.name);
        switch (this.comparison) {
            case 1: {
                configurationElement.setAttribute("comparison", "not-equal");
                break;
            }
            case 2: {
                configurationElement.setAttribute("comparison", "less-than");
                break;
            }
            case 3: {
                configurationElement.setAttribute("comparison", "less-than-or-equal");
                break;
            }
            case 4: {
                configurationElement.setAttribute("comparison", "greater-than");
                break;
            }
            case 5: {
                configurationElement.setAttribute("comparison", "greater-than-or-equal");
                break;
            }
            default: {
                configurationElement.setAttribute("comparison", "equal");
            }
        }
        switch (this.type) {
            case 1: {
                configurationElement.setAttribute("type", "variable");
                break;
            }
            case 2: {
                configurationElement.setAttribute("type", "static");
                break;
            }
            default: {
                configurationElement.setAttribute("type", "none");
            }
        }
        if (this.value != null) {
            configurationElement.setAttribute("value", this.value);
        }
    }
}

