/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine;

import java.lang.reflect.Modifier;

public final class DescriptorUtils {
    public static boolean isValidImplementation(Class type) throws NullPointerException {
        return DescriptorUtils.isValidImplementation(type, Object.class);
    }

    public static boolean isValidImplementation(Class type, Class assignableToType) throws NullPointerException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (assignableToType == null) {
            throw new NullPointerException("assignableToType");
        }
        if (!assignableToType.isAssignableFrom(type)) {
            return false;
        }
        if (type.isPrimitive()) {
            return false;
        }
        if (type.isArray()) {
            return false;
        }
        if (type.isInterface()) {
            return false;
        }
        int modifiers = type.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            return false;
        }
        if (!Modifier.isPublic(modifiers)) {
            return false;
        }
        return type.getConstructors().length > 0;
    }
}

