/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine;

import java.util.LinkedHashMap;
import org.eclipse.vtp.framework.engine.DescriptorUtils;
import org.eclipse.vtp.framework.engine.IdentifierDescriptor;

public final class ServiceDescriptor {
    public static final String SCOPE_PROCESS = "process";
    public static final String SCOPE_SESSION = "session";
    public static final String SCOPE_EXECUTION = "execution";
    public static final String SCOPE_ACTION = "action";
    private final String id;
    private final String name;
    private final String scope;
    private final Class type;
    private final IdentifierDescriptor[] identifiers;

    public ServiceDescriptor(String id, String name, String scope, Class type, IdentifierDescriptor[] identifiers) throws IllegalArgumentException, NullPointerException {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (id.length() == 0) {
            throw new IllegalArgumentException("id");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name");
        }
        if (scope == null) {
            throw new NullPointerException("scope");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (!DescriptorUtils.isValidImplementation(type)) {
            throw new IllegalArgumentException("type");
        }
        if (identifiers == null) {
            throw new NullPointerException("identifiers");
        }
        this.id = id;
        this.name = name;
        if (SCOPE_PROCESS.equalsIgnoreCase(scope)) {
            this.scope = SCOPE_PROCESS;
        } else if (SCOPE_SESSION.equalsIgnoreCase(scope)) {
            this.scope = SCOPE_SESSION;
        } else if (SCOPE_EXECUTION.equalsIgnoreCase(scope)) {
            this.scope = SCOPE_EXECUTION;
        } else if (SCOPE_ACTION.equalsIgnoreCase(scope)) {
            this.scope = SCOPE_ACTION;
        } else {
            throw new IllegalArgumentException("scope");
        }
        this.type = type;
        LinkedHashMap<String, IdentifierDescriptor> map = new LinkedHashMap<String, IdentifierDescriptor>();
        int i = 0;
        while (i < identifiers.length) {
            if (identifiers[i] == null) {
                throw new NullPointerException("identifiers[" + i + "]");
            }
            if (map.containsKey(identifiers[i].getName())) {
                throw new IllegalArgumentException("identifiers[" + i + "]");
            }
            map.put(identifiers[i].getName(), identifiers[i]);
            ++i;
        }
        this.identifiers = map.values().toArray(new IdentifierDescriptor[map.size()]);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getScope() {
        return this.scope;
    }

    public Class getType() {
        return this.type;
    }

    public int getIdentifierCount() {
        return this.identifiers.length;
    }

    public IdentifierDescriptor getIdentifier(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.identifiers.length) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.identifiers[index];
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1)).append('[').append(this.id).append(';').append(this.name).append(';').append(this.scope).append(';').append(this.type).append(';');
        int i = 0;
        while (i < this.identifiers.length) {
            buffer.append(this.identifiers[i].getName()).append(',');
            ++i;
        }
        buffer.setLength(buffer.length() - 1);
        return buffer.append(']').toString();
    }
}

