/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.http;

import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.vtp.framework.core.IReporter;
import org.eclipse.vtp.framework.engine.http.DeploymentSession;
import org.eclipse.vtp.framework.engine.http.HttpUtils;
import org.eclipse.vtp.framework.engine.http.ResultDocument;
import org.eclipse.vtp.framework.interactions.core.media.IResourceManager;
import org.eclipse.vtp.framework.interactions.core.media.IResourceManagerRegistry;
import org.eclipse.vtp.framework.interactions.core.platforms.IDocument;
import org.eclipse.vtp.framework.spi.IProcess;
import org.eclipse.vtp.framework.spi.IProcessDefinition;
import org.eclipse.vtp.framework.spi.IProcessDescriptor;
import org.eclipse.vtp.framework.spi.IProcessEngine;
import org.osgi.framework.Bundle;

public class Deployment
implements IProcessDescriptor,
IResourceManagerRegistry,
HttpSessionListener {
    private final IProcess process;
    private final Dictionary properties;
    private final Bundle contributor;
    private final IReporter reporter;
    private final Map<String, IResourceManager> resources = new HashMap<String, IResourceManager>();
    private final Map<String, DeploymentSession> sessions = new HashMap<String, DeploymentSession>();
    private volatile Method unregisterSessionListener = null;

    public Deployment(IProcessEngine engine, IProcessDefinition definition, Dictionary properties, Bundle contributor, IReporter reporter) {
        this.process = engine.createProcess(definition, (IProcessDescriptor)this);
        this.properties = properties;
        String[] resourceManagerIDs = (String[])properties.get("resources");
        if (resourceManagerIDs != null) {
            int i = 0;
            while (i < resourceManagerIDs.length) {
                this.resources.put(resourceManagerIDs[i], null);
                ++i;
            }
        }
        this.contributor = contributor;
        this.reporter = reporter;
        if (reporter.isReportingEnabled()) {
            Hashtable<String, String> report = new Hashtable<String, String>();
            ((Dictionary)report).put("event", "process.started");
            reporter.report(3, "Process \"" + this.getID() + "\" Started", report);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentSession getActiveSession(String sessionId) {
        Map<String, DeploymentSession> map = this.sessions;
        synchronized (map) {
            return this.sessions.get(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentSession[] getActiveSessions() {
        LinkedList<DeploymentSession> list = new LinkedList<DeploymentSession>();
        Map<String, DeploymentSession> map = this.sessions;
        synchronized (map) {
            list.addAll(this.sessions.values());
        }
        return list.toArray(new DeploymentSession[list.size()]);
    }

    public String getID() {
        String id = (String)this.properties.get("process.id");
        if (id == null) {
            id = (String)this.properties.get("deployment.id");
        }
        return id;
    }

    public String getPath() {
        return HttpUtils.normalizePath((String)this.properties.get("path"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceManager(String resourceManagerID, IResourceManager resourceManager) {
        Map<String, IResourceManager> map = this.resources;
        synchronized (map) {
            if (!this.resources.containsKey(resourceManagerID)) {
                this.resources.put(resourceManagerID, resourceManager);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDocument start(HttpSession httpSession, HttpServletRequest httpRequest, HttpServletResponse httpReesponse, String prefix, int depth, Map<Object, Object> variableValues, Map parameterValues, String entryName, String brand, boolean subdialog) {
        if (this.unregisterSessionListener == null) {
            Deployment deployment = this;
            synchronized (deployment) {
                if (this.unregisterSessionListener == null) {
                    try {
                        Class<?> manager = Thread.currentThread().getContextClassLoader().loadClass("org.eclipse.vtp.framework.webapp.HttpSessionListenerManager");
                        manager.getMethod("addHttpSessionListener", HttpSessionListener.class).invoke(null, this);
                        this.unregisterSessionListener = manager.getMethod("removeHttpSessionListener", HttpSessionListener.class);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        String sessionID = httpSession.getId();
        DeploymentSession session = new DeploymentSession(sessionID, this.process);
        Map<String, DeploymentSession> map = this.sessions;
        synchronized (map) {
            this.sessions.put(sessionID, session);
        }
        ResultDocument result = null;
        session.lock();
        try {
            result = session.start(httpSession, httpRequest, httpReesponse, prefix, depth, variableValues, parameterValues, entryName, brand, subdialog);
        }
        finally {
            session.unlock();
        }
        IDocument document = null;
        if (result == null || result.isTerminated()) {
            document = this.abort(httpSession, httpRequest, httpReesponse, prefix, depth, variableValues, parameterValues);
        }
        if (result != null && result.getDocument() != null) {
            document = result.getDocument();
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDocument next(HttpSession httpSession, HttpServletRequest httpRequest, HttpServletResponse httpReesponse, String prefix, int depth, Map<Object, Object> variableValues, Map parameterValues) {
        String sessionID = httpSession.getId();
        DeploymentSession session = null;
        Map<String, DeploymentSession> map = this.sessions;
        synchronized (map) {
            session = this.sessions.get(sessionID);
            if (session == null) {
                session = new DeploymentSession(sessionID, this.process);
                this.sessions.put(sessionID, session);
            }
        }
        ResultDocument result = null;
        session.lock();
        try {
            result = session.next(httpSession, httpRequest, httpReesponse, prefix, depth, variableValues, parameterValues);
        }
        finally {
            session.unlock();
        }
        IDocument document = null;
        if (result == null || result.isTerminated()) {
            document = this.abort(httpSession, httpRequest, httpReesponse, prefix, depth, variableValues, parameterValues);
        }
        if (result != null && result.getDocument() != null) {
            document = result.getDocument();
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(HttpSession httpSession) {
        String sessionID = httpSession.getId();
        Map<String, DeploymentSession> map = this.sessions;
        synchronized (map) {
            this.sessions.remove(sessionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDocument abort(HttpSession httpSession, HttpServletRequest httpRequest, HttpServletResponse httpReesponse, String prefix, int depth, Map<Object, Object> variableValues, Map parameterValues) {
        Map<String, DeploymentSession> map;
        IDocument iDocument;
        String sessionID = httpSession.getId();
        DeploymentSession session = null;
        Map<String, DeploymentSession> map2 = this.sessions;
        synchronized (map2) {
            session = this.sessions.get(sessionID);
            if (session == null) {
                session = new DeploymentSession(sessionID, this.process);
                this.sessions.put(sessionID, session);
            }
        }
        session.lock();
        try {
            iDocument = session.abort(httpSession, httpRequest, httpReesponse, prefix, depth, variableValues, parameterValues);
            session.unlock();
            map = this.sessions;
        }
        catch (Throwable throwable) {
            session.unlock();
            Map<String, DeploymentSession> map3 = this.sessions;
            synchronized (map3) {
                this.sessions.remove(sessionID);
            }
            throw throwable;
        }
        synchronized (map) {
            this.sessions.remove(sessionID);
        }
        return iDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Deployment deployment = this;
        synchronized (deployment) {
            if (this.unregisterSessionListener != null) {
                try {
                    this.unregisterSessionListener.invoke(null, this);
                    this.unregisterSessionListener = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.reporter.isReportingEnabled()) {
            Hashtable<String, String> report = new Hashtable<String, String>();
            ((Dictionary)report).put("event", "process.stopped");
            ((IReporter)this.process.lookupService(IReporter.class.getName())).report(3, "Process \"" + this.getID() + "\" Stopped", report);
        }
    }

    public String getProcessID() {
        return this.getID();
    }

    public Object getProperty(String propertyName) throws NullPointerException {
        return this.properties.get(propertyName);
    }

    public String[] getServiceIdentifiers() {
        return new String[]{IResourceManagerRegistry.class.getName()};
    }

    public Object getService(String identifier) throws NullPointerException {
        return IResourceManagerRegistry.class.getName().equals(identifier) ? this : null;
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException, NullPointerException {
        return this.contributor.loadClass(className);
    }

    public boolean isSeverityEnabled(int severity) {
        return this.reporter.isSeverityEnabled(severity);
    }

    public boolean isReportingEnabled() {
        return this.reporter.isReportingEnabled();
    }

    public void report(int severity, String[] categories, String message, Dictionary properties) {
        this.reporter.report(severity, categories, message, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getResourceManagerIDs() {
        Map<String, IResourceManager> map = this.resources;
        synchronized (map) {
            return this.resources.keySet().toArray(new String[this.resources.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResourceManager getResourceManager(String resourceManagerID) {
        Map<String, IResourceManager> map = this.resources;
        synchronized (map) {
            return this.resources.get(resourceManagerID);
        }
    }

    public void sessionCreated(HttpSessionEvent se) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent se) {
        Map<String, DeploymentSession> map = this.sessions;
        synchronized (map) {
            DeploymentSession session = this.sessions.remove(se.getSession().getId());
            if (session != null) {
                session.fireDisposedEvent(se.getSession());
            }
        }
    }
}

