/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.vtp.framework.engine.http.HttpConnector;
import org.eclipse.vtp.framework.engine.http.HttpUtils;

public class HttpConnectorServlet
extends HttpServlet {
    private static final int BUFFER_SIZE = 8192;
    private static final long serialVersionUID = 1L;
    private final HttpConnector connector;

    public HttpConnectorServlet(HttpConnector connector) {
        this.connector = connector;
    }

    protected void process(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String pathInfo = HttpUtils.normalizePath(req.getPathInfo());
        if (pathInfo.startsWith("/-/resources")) {
            String resourcePath = pathInfo.substring("/-/resources".length());
            URL resource = this.connector.getResource(resourcePath);
            if (resource == null) {
                resource = this.getServletContext().getResource(resourcePath);
            }
            if (resource == null) {
                res.sendError(404, resourcePath);
                return;
            }
            res.setStatus(200);
            String mimeType = this.connector.getMimeType(resourcePath);
            if (mimeType == null) {
                mimeType = this.getServletContext().getMimeType(resourcePath);
            }
            if (mimeType != null) {
                res.setContentType(mimeType);
            }
            ServletOutputStream output = null;
            try {
                output = res.getOutputStream();
                InputStream input = null;
                try {
                    input = resource.openStream();
                    byte[] b = new byte[8192];
                    int i = input.read(b);
                    while (i >= 0) {
                        output.write(b, 0, i);
                        i = input.read(b);
                    }
                }
                finally {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                output.flush();
                res.flushBuffer();
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return;
        }
        if (pathInfo.startsWith("/-/examine")) {
            this.connector.examine(req, res);
            return;
        }
        this.connector.process(req, res);
    }

    protected void doHead(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
    }

    protected final void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            this.process(req, res);
        }
        catch (Exception e) {
            this.log(e.getMessage(), e);
            res.sendError(500, e.getMessage());
        }
    }

    protected final void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            this.process(req, res);
        }
        catch (Exception e) {
            this.log(e.getMessage(), e);
            res.sendError(500, e.getMessage());
        }
    }
}

