/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.vtp.framework.core.IReporter;
import org.eclipse.vtp.framework.engine.DeploymentAdmin;
import org.eclipse.vtp.framework.engine.ProcessDefinition;
import org.eclipse.vtp.framework.engine.ResourceGroup;
import org.eclipse.vtp.framework.engine.http.HttpConnector;
import org.eclipse.vtp.framework.engine.osgi.OSGiUtils;
import org.eclipse.vtp.framework.spi.IProcessEngine;
import org.eclipse.vtp.framework.util.Guid;
import org.eclipse.vtp.framework.util.SingletonTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.http.HttpService;
import org.osgi.service.log.LogService;

public final class HttpConnectorManager
extends SingletonTracker {
    private final LogService log;
    private final IExtensionRegistry extensionRegistry;
    private final IProcessEngine processEngine;
    private final IReporter reporter;
    private HttpConnectorInstance httpConnectorInstance = null;

    private static Filter createHttpFilter(BundleContext context) {
        String config = context.getProperty("org.eclipse.vtp.framework.engine.http.service");
        try {
            if (config == null) {
                return context.createFilter(String.format("(OBJECTCLASS=%s)", HttpService.class.getName()));
            }
            return context.createFilter(String.format("(&(OBJECTCLASS=%s)(org.eclipse.vtp.framework.engine.http.service=%s))", HttpService.class.getName(), config));
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public HttpConnectorManager(BundleContext context, LogService log, IExtensionRegistry extensionRegistry, IProcessEngine processEngine, IReporter reporter) {
        super(context, HttpConnectorManager.createHttpFilter(context), null);
        this.log = log;
        this.extensionRegistry = extensionRegistry;
        this.processEngine = processEngine;
        this.reporter = reporter;
    }

    private void createHttpConnector(HttpService httpService) {
        this.log.log(4, "Creating HTTP connector...");
        this.httpConnectorInstance = new HttpConnectorInstance(httpService);
        this.httpConnectorInstance.open();
        this.log.log(4, "HTTP connector created.");
    }

    private void releaseHttpConnector() {
        try {
            if (this.httpConnectorInstance != null) {
                this.log.log(4, "Releasing HTTP connector...");
                this.httpConnectorInstance.close();
            }
        }
        finally {
            if (this.httpConnectorInstance != null) {
                this.httpConnectorInstance = null;
                this.log.log(4, "HTTP connector released.");
            }
        }
    }

    public Object selectingService(ServiceReference reference) {
        HttpService service = (HttpService)this.context.getService(reference);
        boolean failed = true;
        try {
            this.createHttpConnector(service);
            failed = false;
        }
        finally {
            if (failed) {
                service = null;
                this.context.ungetService(reference);
            }
        }
        return service;
    }

    public Object changingSelectedService(ServiceReference oldReference, Object oldService, ServiceReference newReference) {
        HttpService newService = (HttpService)this.context.getService(newReference);
        this.releaseHttpConnector();
        boolean failed = true;
        try {
            this.createHttpConnector(newService);
            failed = false;
        }
        finally {
            if (failed) {
                newService = null;
                this.context.ungetService(newReference);
                this.createHttpConnector((HttpService)oldService);
            }
        }
        this.context.ungetService(oldReference);
        return newService;
    }

    public void releasedSelectedService(ServiceReference reference, Object service) {
        try {
            this.releaseHttpConnector();
        }
        finally {
            this.context.ungetService(reference);
        }
    }

    private final class HttpConnectorConfig
    implements ManagedService {
        final HttpConnector connector;

        HttpConnectorConfig(HttpConnector connector) {
            this.connector = connector;
        }

        public void updated(Dictionary properties) throws ConfigurationException {
            this.connector.configure(properties);
        }
    }

    private final class HttpConnectorDeployments
    implements ManagedServiceFactory,
    DeploymentAdmin {
        final HttpConnector connector;

        HttpConnectorDeployments(HttpConnector connector) {
            this.connector = connector;
        }

        public String getName() {
            return this.connector.toString();
        }

        public void updated(String pid, Dictionary properties) throws ConfigurationException {
            this.connector.deploy(pid, properties);
        }

        public void deleted(String pid) {
            this.connector.undeploy(pid);
        }

        @Override
        public String deploy(Dictionary properties) {
            String id = Guid.createGUID();
            try {
                this.updated(id, properties);
            }
            catch (ConfigurationException e) {
                throw new IllegalArgumentException(e);
            }
            return id;
        }

        @Override
        public boolean update(String id, Dictionary properties) {
            try {
                this.updated(id, properties);
            }
            catch (ConfigurationException e) {
                throw new IllegalArgumentException(e);
            }
            return true;
        }

        @Override
        public boolean undelpoy(String id) {
            this.deleted(id);
            return true;
        }
    }

    private final class HttpConnectorInstance
    implements IExtensionChangeHandler {
        final IExtensionPoint definitions;
        final IExtensionPoint resources;
        final HttpConnector httpConnector;
        private DocumentBuilder documentBuilder;
        IExtensionTracker extensionTracker = null;
        ServiceRegistration configRegistration = null;
        ServiceRegistration deploymentsRegistration = null;

        HttpConnectorInstance(HttpService httpService) {
            this.definitions = HttpConnectorManager.this.extensionRegistry.getExtensionPoint("org.eclipse.vtp.framework.engine.definitions");
            this.resources = HttpConnectorManager.this.extensionRegistry.getExtensionPoint("org.eclipse.vtp.framework.engine.resources");
            this.httpConnector = new HttpConnector(HttpConnectorManager.this.log, HttpConnectorManager.this.processEngine, httpService, HttpConnectorManager.this.reporter);
            this.httpConnector.configure(null);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            try {
                this.documentBuilder = factory.newDocumentBuilder();
            }
            catch (Exception e) {
                HttpConnectorManager.this.log.log(1, e.getMessage(), (Throwable)e);
                throw new IllegalStateException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void open() {
            this.extensionTracker = new ExtensionTracker(HttpConnectorManager.this.extensionRegistry);
            HttpConnectorInstance httpConnectorInstance = this;
            synchronized (httpConnectorInstance) {
                IExtensionPoint[] extensionPoints = new IExtensionPoint[]{this.definitions, this.resources};
                this.extensionTracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint[])extensionPoints));
                int i = 0;
                while (i < extensionPoints.length) {
                    IExtension[] extensions = extensionPoints[i].getExtensions();
                    int j = 0;
                    while (j < extensions.length) {
                        this.addExtension(this.extensionTracker, extensions[j]);
                        ++j;
                    }
                    ++i;
                }
            }
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("service.pid", "org.eclipse.vtp.framework.engine.http");
            this.configRegistration = HttpConnectorManager.this.context.registerService(ManagedService.class.getName(), (Object)new HttpConnectorConfig(this.httpConnector), properties);
            properties = new Hashtable();
            properties.put("service.pid", "org.eclipse.vtp.framework.engine.http.deployments");
            this.deploymentsRegistration = HttpConnectorManager.this.context.registerService(new String[]{ManagedServiceFactory.class.getName(), DeploymentAdmin.class.getName()}, (Object)new HttpConnectorDeployments(this.httpConnector), properties);
        }

        void close() {
            try {
                if (this.deploymentsRegistration != null) {
                    this.deploymentsRegistration.unregister();
                }
            }
            finally {
                this.deploymentsRegistration = null;
                try {
                    if (this.configRegistration != null) {
                        this.configRegistration.unregister();
                    }
                }
                finally {
                    this.configRegistration = null;
                    try {
                        if (this.extensionTracker != null) {
                            this.extensionTracker.unregisterHandler((IExtensionChangeHandler)this);
                        }
                    }
                    finally {
                        try {
                            if (this.extensionTracker != null) {
                                this.extensionTracker.close();
                            }
                        }
                        finally {
                            this.extensionTracker = null;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addExtension(IExtensionTracker tracker, IExtension extension) {
            Bundle contributor = OSGiUtils.findBundle(extension.getContributor(), HttpConnectorManager.this.context.getBundles());
            if (contributor == null) {
                return;
            }
            HttpConnectorInstance httpConnectorInstance = this;
            synchronized (httpConnectorInstance) {
                Object[] objects = tracker.getObjects(extension);
                if (objects != null && objects.length > 0) {
                    return;
                }
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int i = 0;
                while (i < elements.length) {
                    block23: {
                        String path;
                        String id = elements[i].getAttribute("id");
                        if (id != null && (path = elements[i].getAttribute("path")) != null) {
                            if (this.definitions.getUniqueIdentifier().equals(extension.getExtensionPointUniqueIdentifier())) {
                                InputStream input = null;
                                try {
                                    try {
                                        input = contributor.getEntry(path).openStream();
                                        this.httpConnector.registerDefinition(id, new ProcessDefinition(this.documentBuilder.parse(input)), contributor);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        HttpConnectorManager.this.log.log(1, e.getMessage(), (Throwable)e);
                                        try {
                                            if (input != null) {
                                                input.close();
                                            }
                                            break block23;
                                        }
                                        catch (IOException iOException) {}
                                        break block23;
                                    }
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (input != null) {
                                            input.close();
                                        }
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                    throw throwable;
                                }
                                try {
                                    if (input != null) {
                                        input.close();
                                    }
                                }
                                catch (IOException iOException) {}
                            } else {
                                this.httpConnector.registerResouces(id, new ResourceGroup(contributor, path));
                            }
                            tracker.registerObject(extension, (Object)id, 0);
                        }
                    }
                    ++i;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeExtension(IExtension extension, Object[] objects) {
            HttpConnectorInstance httpConnectorInstance = this;
            synchronized (httpConnectorInstance) {
                if (objects == null || objects.length == 0) {
                    return;
                }
                int i = 0;
                while (i < objects.length) {
                    if (this.definitions.getUniqueIdentifier().equals(extension.getExtensionPointUniqueIdentifier())) {
                        this.httpConnector.releaseDefinition((String)objects[i]);
                    } else {
                        this.httpConnector.releaseResouces((String)objects[i]);
                    }
                    ++i;
                }
            }
        }
    }
}

