/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.runtime;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vtp.framework.core.IContext;
import org.eclipse.vtp.framework.engine.runtime.Blueprint;
import org.eclipse.vtp.framework.engine.runtime.Builder;
import org.eclipse.vtp.framework.engine.runtime.Component;
import org.eclipse.vtp.framework.engine.runtime.Configuration;
import org.eclipse.vtp.framework.engine.runtime.Scope;
import org.w3c.dom.Element;

public abstract class Configurable
extends Component {
    private final Map configurationIndex;

    protected Configurable(Blueprint blueprint, Class type, Element[] elements) throws NullPointerException {
        super(blueprint, type);
        HashMap<String, LinkedList<Configuration>> configurationIndex = new HashMap<String, LinkedList<Configuration>>();
        LinkedList<Element> elementList = new LinkedList<Element>();
        int i = 0;
        while (elements != null && i < elements.length) {
            if (elements[i] != null) {
                Element element = elements[i];
                elementList.addLast(element);
            }
            ++i;
        }
        for (Element element : elementList) {
            Collection configurationList = blueprint.createConfigurations(element);
            for (Configuration configuration : configurationList) {
                Set identifierSet = configuration.getIdentifiers();
                for (String identifier : identifierSet) {
                    LinkedList<Configuration> items = (LinkedList<Configuration>)configurationIndex.get(identifier);
                    if (items == null) {
                        items = new LinkedList<Configuration>();
                        configurationIndex.put(identifier, items);
                    }
                    items.addLast(configuration);
                }
            }
        }
        for (Map.Entry entry : configurationIndex.entrySet()) {
            entry.setValue(Collections.unmodifiableList(new ArrayList((LinkedList)entry.getValue())));
        }
        this.configurationIndex = Collections.unmodifiableMap(new HashMap(configurationIndex));
    }

    public void solidifyConfigurations(IContext serviceRegistry) {
        for (List items : this.configurationIndex.values()) {
            int i = 0;
            while (i < items.size()) {
                ((Configuration)items.get(i)).solidify(serviceRegistry);
                ++i;
            }
        }
    }

    protected Object lookupConfiguration(String identifier, IContext serviceRegistry) {
        List items = (List)this.configurationIndex.get(identifier);
        if (items == null || items.isEmpty()) {
            return null;
        }
        Object item = items.iterator().next();
        if (item instanceof Configuration) {
            return ((Configuration)item).createInstance(serviceRegistry);
        }
        return item;
    }

    protected Object[] lookupAllConfigurations(String identifier, IContext serviceRegistry) {
        List items = (List)this.configurationIndex.get(identifier);
        if (items == null || items.isEmpty()) {
            return null;
        }
        Object[] results = new Object[items.size()];
        int i = 0;
        for (Object item : items) {
            results[i] = item instanceof Configuration ? ((Configuration)item).createInstance(serviceRegistry) : item;
            ++i;
        }
        return results;
    }

    protected Builder createBuilder(final Scope scope) {
        return new Builder(){

            @Override
            protected Constructor[] getConstructors() {
                return Configurable.this.constructors;
            }

            @Override
            protected Method[] getMutators() {
                return Configurable.this.mutators;
            }

            @Override
            protected IContext createServiceRegistry() {
                return Configurable.this.createServiceRegistry(scope);
            }
        };
    }

    protected abstract IContext createServiceRegistry(Scope var1);
}

