/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.support;

import java.util.Dictionary;
import org.eclipse.vtp.framework.core.IProcessContext;
import org.eclipse.vtp.framework.engine.support.AbstractProcessContext;

public abstract class ProcessContextWrapper
implements IProcessContext {
    protected ProcessContextWrapper() {
    }

    protected boolean isReservedIdentifier(String identifier) {
        return AbstractProcessContext.RESERVED_SERVICE_IDENTIFIERS.contains(identifier);
    }

    protected abstract IProcessContext getProcessContext();

    public boolean isSeverityEnabled(int severity) {
        return this.getProcessContext().isSeverityEnabled(severity);
    }

    public boolean isReportingEnabled() {
        return this.getProcessContext().isReportingEnabled();
    }

    public void report(int severity, String message) {
        this.getProcessContext().report(severity, message);
    }

    public void report(int severity, String message, Dictionary properties) {
        this.getProcessContext().report(severity, message, properties);
    }

    public void report(int severity, String[] categories, String message) {
        this.getProcessContext().report(severity, categories, message);
    }

    public void report(int severity, String[] categories, String message, Dictionary properties) {
        this.getProcessContext().report(severity, categories, message, properties);
    }

    public void log(int severity, String message) {
        this.getProcessContext().log(severity, message);
    }

    public void log(int severity, String message, Dictionary properties) {
        this.getProcessContext().log(severity, message, properties);
    }

    public void log(int severity, String[] categories, String message) {
        this.getProcessContext().log(severity, categories, message);
    }

    public void log(int severity, String[] categories, String message, Dictionary properties) {
        this.getProcessContext().log(severity, categories, message, properties);
    }

    public boolean isErrorEnabled() {
        return this.getProcessContext().isErrorEnabled();
    }

    public void error(String message) {
        this.getProcessContext().error(message);
    }

    public void error(String message, Dictionary properties) {
        this.getProcessContext().error(message, properties);
    }

    public void error(String[] categories, String message) {
        this.getProcessContext().error(categories, message);
    }

    public void error(String[] categories, String message, Dictionary properties) {
        this.getProcessContext().error(categories, message, properties);
    }

    public boolean isWarnEnabled() {
        return this.getProcessContext().isWarnEnabled();
    }

    public void warn(String message) {
        this.getProcessContext().warn(message);
    }

    public void warn(String message, Dictionary properties) {
        this.getProcessContext().warn(message, properties);
    }

    public void warn(String[] categories, String message) {
        this.getProcessContext().warn(categories, message);
    }

    public void warn(String[] categories, String message, Dictionary properties) {
        this.getProcessContext().warn(categories, message, properties);
    }

    public boolean isInfoEnabled() {
        return this.getProcessContext().isInfoEnabled();
    }

    public void info(String message) {
        this.getProcessContext().info(message);
    }

    public void info(String message, Dictionary properties) {
        this.getProcessContext().info(message, properties);
    }

    public void info(String[] categories, String message) {
        this.getProcessContext().info(categories, message);
    }

    public void info(String[] categories, String message, Dictionary properties) {
        this.getProcessContext().info(categories, message, properties);
    }

    public boolean isDebugEnabled() {
        return this.getProcessContext().isDebugEnabled();
    }

    public void debug(String message) {
        this.getProcessContext().debug(message);
    }

    public void debug(String message, Dictionary properties) {
        this.getProcessContext().debug(message, properties);
    }

    public void debug(String[] categories, String message) {
        this.getProcessContext().debug(categories, message);
    }

    public void debug(String[] categories, String message, Dictionary properties) {
        this.getProcessContext().debug(categories, message, properties);
    }

    public Object lookup(String identifier) throws NullPointerException {
        if (this.isReservedIdentifier(identifier)) {
            return this;
        }
        return this.getProcessContext().lookup(identifier);
    }

    public Object[] lookupAll(String identifier) throws NullPointerException {
        if (this.isReservedIdentifier(identifier)) {
            return new Object[]{this};
        }
        return this.getProcessContext().lookupAll(identifier);
    }

    public String getProcessID() {
        return this.getProcessContext().getProcessID();
    }

    public Object getProperty(String propertyName) throws NullPointerException {
        return this.getProcessContext().getProperty(propertyName);
    }

    public Class loadClass(String className) throws ClassNotFoundException, NullPointerException {
        return this.getProcessContext().loadClass(className);
    }
}

