/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.support;

import java.util.Date;
import java.util.Dictionary;
import org.eclipse.vtp.framework.core.ISessionContext;
import org.eclipse.vtp.framework.engine.support.AbstractSessionContext;

public abstract class SessionContextWrapper
implements ISessionContext {
    protected SessionContextWrapper() {
    }

    protected boolean isReservedIdentifier(String identifier) {
        return AbstractSessionContext.RESERVED_SERVICE_IDENTIFIERS.contains(identifier);
    }

    protected abstract ISessionContext getSessionContext();

    public boolean isSeverityEnabled(int severity) {
        return this.getSessionContext().isSeverityEnabled(severity);
    }

    public boolean isReportingEnabled() {
        return this.getSessionContext().isReportingEnabled();
    }

    public void report(int severity, String message) {
        this.getSessionContext().report(severity, message);
    }

    public void report(int severity, String message, Dictionary properties) {
        this.getSessionContext().report(severity, message, properties);
    }

    public void report(int severity, String[] categories, String message) {
        this.getSessionContext().report(severity, categories, message);
    }

    public void report(int severity, String[] categories, String message, Dictionary properties) {
        this.getSessionContext().report(severity, categories, message, properties);
    }

    public void log(int severity, String message) {
        this.getSessionContext().log(severity, message);
    }

    public void log(int severity, String message, Dictionary properties) {
        this.getSessionContext().log(severity, message, properties);
    }

    public void log(int severity, String[] categories, String message) {
        this.getSessionContext().log(severity, categories, message);
    }

    public void log(int severity, String[] categories, String message, Dictionary properties) {
        this.getSessionContext().log(severity, categories, message, properties);
    }

    public boolean isErrorEnabled() {
        return this.getSessionContext().isErrorEnabled();
    }

    public void error(String message) {
        this.getSessionContext().error(message);
    }

    public void error(String message, Dictionary properties) {
        this.getSessionContext().error(message, properties);
    }

    public void error(String[] categories, String message) {
        this.getSessionContext().error(categories, message);
    }

    public void error(String[] categories, String message, Dictionary properties) {
        this.getSessionContext().error(categories, message, properties);
    }

    public boolean isWarnEnabled() {
        return this.getSessionContext().isWarnEnabled();
    }

    public void warn(String message) {
        this.getSessionContext().warn(message);
    }

    public void warn(String message, Dictionary properties) {
        this.getSessionContext().warn(message, properties);
    }

    public void warn(String[] categories, String message) {
        this.getSessionContext().warn(categories, message);
    }

    public void warn(String[] categories, String message, Dictionary properties) {
        this.getSessionContext().warn(categories, message, properties);
    }

    public boolean isInfoEnabled() {
        return this.getSessionContext().isInfoEnabled();
    }

    public void info(String message) {
        this.getSessionContext().info(message);
    }

    public void info(String message, Dictionary properties) {
        this.getSessionContext().info(message, properties);
    }

    public void info(String[] categories, String message) {
        this.getSessionContext().info(categories, message);
    }

    public void info(String[] categories, String message, Dictionary properties) {
        this.getSessionContext().info(categories, message, properties);
    }

    public boolean isDebugEnabled() {
        return this.getSessionContext().isDebugEnabled();
    }

    public void debug(String message) {
        this.getSessionContext().debug(message);
    }

    public void debug(String message, Dictionary properties) {
        this.getSessionContext().debug(message, properties);
    }

    public void debug(String[] categories, String message) {
        this.getSessionContext().debug(categories, message);
    }

    public void debug(String[] categories, String message, Dictionary properties) {
        this.getSessionContext().debug(categories, message, properties);
    }

    public Object lookup(String identifier) throws NullPointerException {
        if (this.isReservedIdentifier(identifier)) {
            return this;
        }
        return this.getSessionContext().lookup(identifier);
    }

    public Object[] lookupAll(String identifier) throws NullPointerException {
        if (this.isReservedIdentifier(identifier)) {
            return new Object[]{this};
        }
        return this.getSessionContext().lookupAll(identifier);
    }

    public String getProcessID() {
        return this.getSessionContext().getProcessID();
    }

    public Object getProperty(String propertyName) throws NullPointerException {
        return this.getSessionContext().getProperty(propertyName);
    }

    public Class loadClass(String className) throws ClassNotFoundException, NullPointerException {
        return this.getSessionContext().loadClass(className);
    }

    public String getSessionID() {
        return this.getSessionContext().getSessionID();
    }

    public Date getSessionStartTime() {
        return this.getSessionContext().getSessionStartTime();
    }

    public String[] getAttributeNames() {
        return this.getSessionContext().getAttributeNames();
    }

    public Object getAttribute(String attributeName) throws NullPointerException {
        return this.getSessionContext().getAttribute(attributeName);
    }

    public void setAttribute(String attributeName, Object attributeValue) throws NullPointerException {
        this.getSessionContext().setAttribute(attributeName, attributeValue);
    }

    public void clearAttribute(String attributeName) throws NullPointerException {
        this.getSessionContext().clearAttribute(attributeName);
    }

    public Object getInheritedAttribute(String attributeName) throws NullPointerException {
        return this.getSessionContext().getInheritedAttribute(attributeName);
    }

    public String[] getRootAttributeNames() {
        return this.getSessionContext().getRootAttributeNames();
    }

    public Object getRootAttribute(String attributeName) throws NullPointerException {
        return this.getSessionContext().getRootAttribute(attributeName);
    }

    public void setRootAttribute(String attributeName, Object attributeValue) throws NullPointerException {
        this.getSessionContext().setRootAttribute(attributeName, attributeValue);
    }

    public void clearRootAttribute(String attributeName) throws NullPointerException {
        this.getSessionContext().clearRootAttribute(attributeName);
    }
}

