/*--------------------------------------------------------------------------
 * Copyright (c) 2004, 2006-2007 OpenMethods, LLC
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Trip Gilman (OpenMethods), Lonnie G. Pryor (OpenMethods)
 *    - initial API and implementation
 -------------------------------------------------------------------------*/
package org.eclipse.vtp.framework.interactions.core.configurations;

/**
 * ConfigConstants.
 * 
 * @author Lonnie Pryor
 */
public interface InteractionsConstants
{
	/** The name space URI of the interactions configuration objects. */
	String NAMESPACE_URI = "http://eclipse.org/vtp/xml/framework/interactions/core/configurations"; //$NON-NLS-1$

	/** The "content-type" name constant. */
	String NAME_CONTENT_TYPE = "content-type"; //$NON-NLS-1$
	/** The "choice" name constant. */
	String NAME_CHOICE = "choice"; //$NON-NLS-1$
	/** The "choices" name constant. */
	String NAME_CHOICES = "choices"; //$NON-NLS-1$
	/** The "data-name" name constant. */
	String NAME_DATA_NAME = "data-name"; //$NON-NLS-1$
	/** The "data-request" name constant. */
	String NAME_DATA_REQUEST = "data-request"; //$NON-NLS-1$
	/** The "formatter" name constant. */
	String NAME_FORMATTER = "formatter"; //$NON-NLS-1$
	/** The "id" name constant. */
	String NAME_ID = "id"; //$NON-NLS-1$
	/** The "input" name constant. */
	String NAME_INPUT = "input"; //$NON-NLS-1$
	/** The "input-item" name constant. */
	String NAME_INPUT_ITEM = "input-item"; //$NON-NLS-1$
	/** The "input-name" name constant. */
	String NAME_INPUT_NAME = "input-name"; //$NON-NLS-1$
	/** The "input-request" name constant. */
	String NAME_INPUT_REQUEST = "input-request"; //$NON-NLS-1$
	/** The "interaction-type" name constant. */
	String NAME_INTERACTION_TYPE = "interaction-type"; //$NON-NLS-1$
	/** The "key" name constant. */
	String NAME_KEY = "key"; //$NON-NLS-1$
	/** The "language" name constant. */
	String NAME_LANGUAGE = "language"; //$NON-NLS-1$
	/** The "locale" name constant. */
	String NAME_LOCALE = "locale"; //$NON-NLS-1$
	/** The "media" name constant. */
	String NAME_MEDIA = "media"; //$NON-NLS-1$
	/** The "media-provider" name constant. */
	String NAME_MEDIA_PROVIDER = "media-provider"; //$NON-NLS-1$
	/** The "media-provider-binding" name constant. */
	String NAME_MEDIA_PROVIDER_BINDING = "media-provider-binding"; //$NON-NLS-1$
	/** The "meta-data" name constant. */
	String NAME_META_DATA = "meta-data"; //$NON-NLS-1$
	/** The "meta-data-item" name constant. */
	String NAME_META_DATA_ITEM = "meta-data-item"; //$NON-NLS-1$
	/** The "meta-data-set" name constant. */
	String NAME_META_DATA_SET = "meta-data-set"; //$NON-NLS-1$
	/** The "name" name constant. */
	String NAME_NAME = "name"; //$NON-NLS-1$
	/** The "output" name constant. */
	String NAME_OUTPUT = "output"; //$NON-NLS-1$
	/** The "output-item" name constant. */
	String NAME_OUTPUT_ITEM = "output-item"; //$NON-NLS-1$
	/** The "output-name" name constant. */
	String NAME_OUTPUT_NAME = "output-name"; //$NON-NLS-1$
	/** The "output-message" name constant. */
	String NAME_OUTPUT_MESSAGE = "output-message"; //$NON-NLS-1$
	/** The "output-node-content" name constant. */
	String NAME_OUTPUT_NODE_CONTENT = "output-node-content"; //$NON-NLS-1$
	/** The "output-node-switch" name constant. */
	String NAME_OUTPUT_NODE_SWITCH = "output-node-switch"; //$NON-NLS-1$
	/** The "output-node-case" name constant. */
	String NAME_OUTPUT_NODE_CASE = "output-node-case"; //$NON-NLS-1$
	/** The "property" name constant. */
	String NAME_PROPERTY = "property"; //$NON-NLS-1$
	/** The "property-item" name constant. */
	String NAME_PROPERTY_ITEM = "property-item"; //$NON-NLS-1$
	/** The "resource-manager" name constant. */
	String NAME_RESOURCE_MANAGER = "resource-manager"; //$NON-NLS-1$
	/** The "script" name constant. */
	String NAME_SCRIPT = "script"; //$NON-NLS-1$
	/** The "scripting-language" name constant. */
	String NAME_SCRIPTING_LANGUGAGE = "scripting-language"; //$NON-NLS-1$
	/** The "selection-request" name constant. */
	String NAME_SELECTION_REQUEST = "selection-request"; //$NON-NLS-1$
	/** The "shared-content" name constant. */
	String NAME_SHARED_CONTENT = "shared-content"; //$NON-NLS-1$
	/** The "transfer-message" name constant. */
	String NAME_TRANSFER_MESSAGE = "transfer-message"; //$NON-NLS-1$
	/** The "type" name constant. */
	String NAME_TYPE = "type"; //$NON-NLS-1$
	String NAME_URL_PARAMETER_ITEM = "url-parameter-item"; //$NON-NLS-1$
	/** The "value" name constant. */
	String NAME_VALUE = "value"; //$NON-NLS-1$
	String NAME_SECURED = "secured";
}
