/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.actions;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.vtp.framework.common.IBrandSelection;
import org.eclipse.vtp.framework.common.IScriptingService;
import org.eclipse.vtp.framework.common.IVariableRegistry;
import org.eclipse.vtp.framework.core.IAction;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;
import org.eclipse.vtp.framework.interactions.core.IInteractionTypeSelection;
import org.eclipse.vtp.framework.interactions.core.ILanguageSelection;
import org.eclipse.vtp.framework.interactions.core.configurations.BridgeMessageConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.MediaConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.PropertyConfiguration;
import org.eclipse.vtp.framework.interactions.core.conversation.IConversation;

public class BridgeMessageAction
implements IAction {
    private final IActionContext context;
    private final IConversation conversation;
    private final BridgeMessageConfiguration configuration;
    private final IBrandSelection brandSelection;
    private final ILanguageSelection languageSelection;
    private final IInteractionTypeSelection interactionSelection;
    private final IVariableRegistry variableRegistry;
    private final IScriptingService scriptingService;

    public BridgeMessageAction(IActionContext context, IConversation conversation, BridgeMessageConfiguration configuration, IBrandSelection brandSelection, ILanguageSelection languageSelection, IInteractionTypeSelection interactionSelection, IVariableRegistry variableRegistry, IScriptingService scriptingService) {
        this.context = context;
        this.conversation = conversation;
        this.configuration = configuration;
        this.brandSelection = brandSelection;
        this.languageSelection = languageSelection;
        this.interactionSelection = interactionSelection;
        this.variableRegistry = variableRegistry;
        this.scriptingService = scriptingService;
    }

    public IActionResult execute() {
        String value;
        PropertyConfiguration typePropertyConfig;
        PropertyConfiguration transferTypePropertyConfig;
        String result;
        String resultParameterName;
        block24: {
            resultParameterName = "Action_" + this.context.getActionID().replace(':', '_');
            try {
                MediaConfiguration mediaConfiguration = this.configuration.getMediaConfiguration();
                if (this.context.isDebugEnabled()) {
                    this.context.debug(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
                }
                result = this.context.getParameter(resultParameterName);
                this.context.clearParameter(resultParameterName);
                transferTypePropertyConfig = mediaConfiguration.getPropertyConfiguration("transferType");
                typePropertyConfig = mediaConfiguration.getPropertyConfiguration("type");
                PropertyConfiguration destinationPropertyConfig = mediaConfiguration.getPropertyConfiguration("destination");
                value = this.conversation.resolveProperty(destinationPropertyConfig, true, true);
                if (value == null) {
                    value = this.conversation.resolveProperty(destinationPropertyConfig, true, false);
                }
                if (value != null) break block24;
                return null;
            }
            catch (RuntimeException e) {
                return this.context.createResult("error.bridge.message", (Throwable)e);
            }
        }
        String type = this.conversation.resolveProperty(typePropertyConfig, true, true);
        if (type == null) {
            type = this.conversation.resolveProperty(typePropertyConfig, true, false);
        }
        if ("variable".equalsIgnoreCase(type)) {
            value = String.valueOf(this.variableRegistry.getVariable(value));
        } else if ("expression".equalsIgnoreCase(type)) {
            value = String.valueOf(this.scriptingService.createScriptingEngine("JavaScript").execute(value));
        }
        String transferType = this.conversation.resolveProperty(transferTypePropertyConfig, true, true);
        if (transferType == null) {
            transferType = this.conversation.resolveProperty(transferTypePropertyConfig, true, false);
        }
        if (result != null) {
            if (this.context.isReportingEnabled()) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("event", "transfer.after");
                ((Dictionary)props).put("transfer.destination", value);
                ((Dictionary)props).put("transfer.type", transferType);
                ((Dictionary)props).put("transfer.result", result);
                this.context.report(3, "Ended transfer to destination \"" + value + "\"", props);
            }
            if ("transferred".equals(result)) {
                return this.context.createResult("Call Transfered");
            }
            if ("busy".equals(result)) {
                return this.context.createResult("Line Busy");
            }
            if ("unavailable".equals(result)) {
                return this.context.createResult("No Answer");
            }
            if ("noauthorization".equals(result)) {
                return this.context.createResult("error.connection.noauthorization");
            }
            if ("baddestination".equals(result)) {
                return this.context.createResult("error.connection.baddestination");
            }
            if ("noroute".equals(result)) {
                return this.context.createResult("error.connection.noroute");
            }
            if ("noresource".equals(result)) {
                return this.context.createResult("error.connection.noresource");
            }
            if ("protocol".equals(result)) {
                return this.context.createResult("error.connection.protocol");
            }
            if ("badbridge".equals(result)) {
                return this.context.createResult("error.unsupported.transfer.bridge");
            }
            if ("baduri".equals(result)) {
                return this.context.createResult("error.unsupported.uri");
            }
            if ("error.disconnect.hangup".equals(result)) {
                return this.context.createResult("error.disconnect.hangup");
            }
            return this.context.createResult(result);
        }
        if (this.context.isReportingEnabled()) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("event", "transfer.before");
            ((Dictionary)props).put("transfer.destination", value);
            ((Dictionary)props).put("transfer.type", transferType);
            this.context.report(3, "Transfering to destination \"" + value + "\"", props);
        }
        this.conversation.createBridgeMessage(this.configuration, resultParameterName).enqueue();
        return this.context.createResult("repeat");
    }
}

