/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.actions;

import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.vtp.framework.common.IDataObject;
import org.eclipse.vtp.framework.common.ILastResult;
import org.eclipse.vtp.framework.common.IStringObject;
import org.eclipse.vtp.framework.common.IVariableRegistry;
import org.eclipse.vtp.framework.core.IAction;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;
import org.eclipse.vtp.framework.interactions.core.configurations.DataRequestConfiguration;
import org.eclipse.vtp.framework.interactions.core.conversation.IConversation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DataRequestAction
implements IAction {
    private final IActionContext context;
    private final IVariableRegistry variableRegistry;
    private final IConversation conversation;
    private final DataRequestConfiguration configuration;
    private final ILastResult lastResult;

    public DataRequestAction(IActionContext context, IVariableRegistry variableRegistry, IConversation conversation, DataRequestConfiguration configuration, ILastResult lastResult) {
        this.context = context;
        this.variableRegistry = variableRegistry;
        this.conversation = conversation;
        this.configuration = configuration;
        this.lastResult = lastResult;
    }

    public IActionResult execute() {
        String resultParameterName = "Action_" + this.context.getActionID().replace(':', '_');
        try {
            if (this.context.isDebugEnabled()) {
                this.context.debug(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
            }
            String result = this.context.getParameter(resultParameterName);
            this.context.clearParameter(resultParameterName);
            if ("success.filled".equals(result)) {
                if (this.context.isReportingEnabled()) {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("event", "data.request.filled");
                    this.context.report(3, "Got requested data \"" + this.context.getParameter(this.configuration.getDataName()) + "\"", props);
                }
                IStringObject variable = (IStringObject)this.variableRegistry.createVariable("String");
                variable.setValue((Object)this.context.getParameter(this.configuration.getDataName()));
                this.variableRegistry.setVariable(this.configuration.getDataName(), (IDataObject)variable);
                IStringObject dtmfVar = (IStringObject)this.variableRegistry.createVariable("String");
                dtmfVar.setValue((Object)this.context.getParameter(String.valueOf(this.configuration.getDataName()) + "_termchar"));
                this.variableRegistry.setVariable("RecordDTMF", (IDataObject)dtmfVar);
                this.lastResult.clear();
                String lastResultXML = this.context.getParameter("lastresult");
                if (lastResultXML != null && !lastResultXML.equals("")) {
                    Document lastResultDocument = null;
                    try {
                        lastResultDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(lastResultXML.getBytes()));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    NodeList markList = lastResultDocument.getDocumentElement().getElementsByTagName("mark");
                    if (markList.getLength() > 0) {
                        Element markElement = (Element)markList.item(0);
                        this.lastResult.setMarkName(markElement.getAttribute("name"));
                        this.lastResult.setMarkTime(markElement.getAttribute("offset"));
                    }
                    NodeList nl = lastResultDocument.getDocumentElement().getElementsByTagName("result");
                    int i = 0;
                    while (i < nl.getLength()) {
                        Element resultElement = (Element)nl.item(i);
                        Element confidenceElement = (Element)resultElement.getElementsByTagName("confidence").item(0);
                        Element utteranceElement = (Element)resultElement.getElementsByTagName("utterance").item(0);
                        Element inputModeElement = (Element)resultElement.getElementsByTagName("inputmode").item(0);
                        Element interpretationElement = (Element)resultElement.getElementsByTagName("interpretation").item(0);
                        this.lastResult.addResult(new BigDecimal(confidenceElement.getTextContent()).multiply(new BigDecimal(100)).intValue(), utteranceElement.getTextContent(), inputModeElement.getTextContent(), interpretationElement.getTextContent());
                        ++i;
                    }
                }
                return this.context.createResult("default");
            }
            if ("error.input.noinput".equals(result)) {
                if (this.context.isReportingEnabled()) {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("event", "data.request.noinput");
                    this.context.report(3, "Got no input for requested data.", props);
                }
                return this.context.createResult("error.input.noinput");
            }
            if ("error.disconnect.hangup".equals(result)) {
                if (this.context.isReportingEnabled()) {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("event", "data.request.filled");
                    this.context.report(3, "Got requested data \"" + this.context.getParameter(this.configuration.getDataName()) + "\"", props);
                }
                IStringObject variable = (IStringObject)this.variableRegistry.createVariable("String");
                variable.setValue((Object)this.context.getParameter(this.configuration.getDataName()));
                this.variableRegistry.setVariable(this.configuration.getDataName(), (IDataObject)variable);
                this.lastResult.clear();
                if (this.context.isReportingEnabled()) {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("event", "error.disconnect.hangup");
                    this.context.report(3, "Got disconnect during interaction.", props);
                }
                return this.context.createResult("error.disconnect.hangup");
            }
            if ("error.input.nomatch".equals(result)) {
                if (this.context.isReportingEnabled()) {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("event", "data.request.nomatch");
                    this.context.report(3, "Got no match for requested data.", props);
                }
                this.lastResult.clear();
                String lastResultXML = this.context.getParameter("lastresult");
                if (lastResultXML != null && !lastResultXML.equals("")) {
                    Document lastResultDocument = null;
                    try {
                        lastResultDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(lastResultXML.getBytes()));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    NodeList markList = lastResultDocument.getDocumentElement().getElementsByTagName("mark");
                    if (markList.getLength() > 0) {
                        Element markElement = (Element)markList.item(0);
                        this.lastResult.setMarkName(markElement.getAttribute("name"));
                        this.lastResult.setMarkTime(markElement.getAttribute("offset"));
                    }
                    NodeList nl = lastResultDocument.getDocumentElement().getElementsByTagName("result");
                    int i = 0;
                    while (i < nl.getLength()) {
                        Element resultElement = (Element)nl.item(i);
                        Element confidenceElement = (Element)resultElement.getElementsByTagName("confidence").item(0);
                        Element utteranceElement = (Element)resultElement.getElementsByTagName("utterance").item(0);
                        Element inputModeElement = (Element)resultElement.getElementsByTagName("inputmode").item(0);
                        Element interpretationElement = (Element)resultElement.getElementsByTagName("interpretation").item(0);
                        this.lastResult.addResult(new BigDecimal(confidenceElement.getTextContent()).multiply(new BigDecimal(100)).intValue(), utteranceElement.getTextContent(), inputModeElement.getTextContent(), interpretationElement.getTextContent());
                        ++i;
                    }
                }
                return this.context.createResult("error.input.nomatch");
            }
            if (result != null) {
                return this.context.createResult(result);
            }
            if (this.context.isReportingEnabled()) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("event", "data.request.before");
                this.context.report(3, "Requesting data \"" + this.configuration.getDataName() + "\".", props);
            }
            this.conversation.createDataRequest(this.configuration, resultParameterName).enqueue();
            return this.context.createResult("repeat");
        }
        catch (RuntimeException e) {
            return this.context.createResult("error.data.request", (Throwable)e);
        }
    }
}

