/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.actions;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.vtp.framework.common.IDataObject;
import org.eclipse.vtp.framework.common.IStringObject;
import org.eclipse.vtp.framework.common.IVariableRegistry;
import org.eclipse.vtp.framework.core.IAction;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;
import org.eclipse.vtp.framework.interactions.core.configurations.ExternalReferenceConfiguration;
import org.eclipse.vtp.framework.interactions.core.conversation.IConversation;

public class ExternalReferenceAction
implements IAction {
    private final IActionContext context;
    private final IConversation conversation;
    private final IVariableRegistry variables;
    private final ExternalReferenceConfiguration configuration;

    public ExternalReferenceAction(IActionContext context, IConversation conversation, IVariableRegistry variables, ExternalReferenceConfiguration configuration) {
        this.context = context;
        this.conversation = conversation;
        this.variables = variables;
        this.configuration = configuration;
    }

    public IActionResult execute() {
        String resultParameterName = "Action_" + this.context.getActionID().replace(':', '_');
        try {
            if (this.context.isDebugEnabled()) {
                this.context.debug(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
            }
            String result = this.context.getParameter(resultParameterName);
            this.context.clearParameter(resultParameterName);
            if ("success.filled".equals(result)) {
                String[] keys = this.configuration.getOutputNames();
                int i = 0;
                while (i < keys.length) {
                    IStringObject obj = (IStringObject)this.variables.createVariable("String");
                    obj.setValue((Object)this.context.getParameter(keys[i]));
                    this.variables.setVariable(keys[i], (IDataObject)obj);
                    ++i;
                }
                if (this.context.isReportingEnabled()) {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("event", "external.reference.after");
                    this.context.report(3, "External reference complete.", props);
                }
                return this.context.createResult("default");
            }
            if ("error.disconnect.hangup".equals(result)) {
                if (this.context.isReportingEnabled()) {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("event", "error.disconnect.hangup");
                    this.context.report(3, "Got disconnect during interaction.", props);
                }
                return this.context.createResult("error.disconnect.hangup");
            }
            if (result != null) {
                return this.context.createResult(result);
            }
            if (this.context.isReportingEnabled()) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("event", "external.reference.before");
                this.context.report(3, "Invoking external reference \"" + this.configuration.getName() + "\".", props);
            }
            this.conversation.createExternalReference(this.configuration, resultParameterName).enqueue();
            return this.context.createResult("repeat");
        }
        catch (RuntimeException e) {
            return this.context.createResult("error.external.reference", (Throwable)e);
        }
    }
}

