/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.actions;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.vtp.framework.core.IAction;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;
import org.eclipse.vtp.framework.interactions.core.configurations.MetaDataConfiguration;
import org.eclipse.vtp.framework.interactions.core.conversation.IConversation;
import org.eclipse.vtp.framework.interactions.core.conversation.IMetaDataMessage;
import org.eclipse.vtp.framework.interactions.core.platforms.IPlatformSelector;
import org.eclipse.vtp.framework.interactions.core.support.AbstractPlatform;

public class MetaDataMessageAction
implements IAction {
    private final IActionContext context;
    private final IConversation conversation;
    private final MetaDataConfiguration configuration;
    private final IPlatformSelector platformSelector;

    public MetaDataMessageAction(IActionContext context, IConversation conversation, MetaDataConfiguration configuration, IPlatformSelector platformSelector) {
        this.context = context;
        this.conversation = conversation;
        this.configuration = configuration;
        this.platformSelector = platformSelector;
    }

    public IActionResult execute() {
        String resultParameterName = "Action_" + this.context.getActionID().replace(':', '_');
        String result = this.context.getParameter(resultParameterName);
        System.out.println("Meta-data Message Result: " + result);
        this.context.clearParameter(resultParameterName);
        if ("success.filled".equals(result)) {
            AbstractPlatform platform = (AbstractPlatform)this.platformSelector.getSelectedPlatform();
            if (platform.processMetaDataMessageResults(this.context)) {
                return this.context.createResult("default");
            }
            return this.context.createResult("error.meta-data.message");
        }
        if ("error.disconnect.hangup".equals(result)) {
            if (this.context.isReportingEnabled()) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("event", "error.disconnect.hangup");
                this.context.report(3, "Got disconnect during interaction.", props);
            }
            return this.context.createResult("error.disconnect.hangup");
        }
        if (result != null) {
            return this.context.createResult(result);
        }
        try {
            IMetaDataMessage createMetaDataMessage;
            if (this.context.isDebugEnabled()) {
                this.context.debug(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
            }
            if (this.context.isReportingEnabled()) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("event", "metadata.message");
                this.context.report(3, "Sending meta-data.", props);
            }
            if ((createMetaDataMessage = this.conversation.createMetaDataMessage(this.configuration, resultParameterName)).enqueue()) {
                return this.context.createResult("repeat");
            }
        }
        catch (RuntimeException e) {
            return this.context.createResult("error.meta-data.message", (Throwable)e);
        }
        return this.context.createResult("error.meta-data.message");
    }
}

