/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.actions;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.vtp.framework.core.IAction;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;
import org.eclipse.vtp.framework.interactions.core.configurations.OutputMessageConfiguration;
import org.eclipse.vtp.framework.interactions.core.conversation.IConversation;

public class OutputMessageAction
implements IAction {
    private final IActionContext context;
    private final IConversation conversation;
    private final OutputMessageConfiguration configuration;

    public OutputMessageAction(IActionContext context, IConversation conversation, OutputMessageConfiguration configuration) {
        this.context = context;
        this.conversation = conversation;
        this.configuration = configuration;
    }

    public IActionResult execute() {
        String resultParameterName = "Action_" + this.context.getActionID().replace(':', '_');
        try {
            String result = this.context.getParameter(resultParameterName);
            this.context.clearParameter(resultParameterName);
            if ("success.filled".equals(result)) {
                return this.context.createResult("default");
            }
            if ("error.disconnect.hangup".equals(result)) {
                if (this.context.isReportingEnabled()) {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("event", "connection.disconnect.hangup");
                    this.context.report(3, "Got disconnect during output.", props);
                }
                return this.context.createResult("error.disconnect.hangup");
            }
            if (result != null) {
                return this.context.createResult(result);
            }
            if (this.context.isReportingEnabled()) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("event", "output.message");
                this.context.report(3, "Sending output.", props);
            }
            this.conversation.createOutputMessage(this.configuration, resultParameterName).enqueue();
            if (this.context.isInfoEnabled()) {
                this.context.info("Output sent.");
            }
            return this.context.createResult("repeat");
        }
        catch (RuntimeException e) {
            return this.context.createResult("error.output.message", (Throwable)e);
        }
    }
}

