/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vtp.framework.interactions.core.commands.ConversationCommand;
import org.eclipse.vtp.framework.interactions.core.commands.IConversationCommandVisitor;
import org.eclipse.vtp.framework.interactions.core.commands.Input;
import org.eclipse.vtp.framework.interactions.core.commands.Output;

public final class DataRequestCommand
extends ConversationCommand {
    private String dataName = null;
    private String resultName = null;
    private String filledResultValue = null;
    private String noInputResultValue = null;
    private String hangupResultValue = null;
    private final Map properties = new HashMap();
    private final List<Output> output = new ArrayList<Output>();
    private Input input = null;
    private final Map parameters = new HashMap();

    public String getDataName() {
        return this.dataName;
    }

    public void setDataName(String inputName) {
        this.dataName = inputName;
    }

    public String getResultName() {
        return this.resultName;
    }

    public void setResultName(String resultName) {
        this.resultName = resultName;
    }

    public String getFilledResultValue() {
        return this.filledResultValue;
    }

    public void setFilledResultValue(String filledResultValue) {
        this.filledResultValue = filledResultValue;
    }

    public String getNoInputResultValue() {
        return this.noInputResultValue;
    }

    public void setNoInputResultValue(String noInputResultValue) {
        this.noInputResultValue = noInputResultValue;
    }

    public String getHangupResultValue() {
        return this.hangupResultValue;
    }

    public void setHangupResultValue(String hangupResultValue) {
        this.hangupResultValue = hangupResultValue;
    }

    public String[] getPropertyNames() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    public String getPropertyValue(String name) {
        if (name == null) {
            return null;
        }
        return (String)this.properties.get(name);
    }

    public void setPropertyValue(String name, String value) {
        if (name == null) {
            return;
        }
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    public int getOutputCount() {
        return this.output.size();
    }

    public int getOutputType(int outputIndex) {
        if (outputIndex < 0 || outputIndex >= this.output.size()) {
            return 0;
        }
        if ("org.eclipse.vtp.output.File".equals(this.output.get(outputIndex).getType())) {
            return 1;
        }
        if ("org.eclipse.vtp.output.Text".equals(this.output.get(outputIndex).getType())) {
            return 2;
        }
        return 0;
    }

    public String getOutputValue(int outputIndex) {
        if (outputIndex < 0 || outputIndex >= this.output.size()) {
            return null;
        }
        return this.output.get(outputIndex).getProperty("value");
    }

    public void addOutput(Output o) {
        this.output.add(o);
    }

    public void insertOutput(int outputIndex, Output o) {
        if (outputIndex >= 0 && outputIndex <= this.output.size()) {
            this.output.add(outputIndex, o);
        }
    }

    public void setOutput(int outputIndex, Output o) {
        if (outputIndex >= 0 && outputIndex < this.output.size()) {
            this.output.set(outputIndex, o);
        }
    }

    public void removeOutput(int outputIndex) {
        if (outputIndex >= 0 && outputIndex < this.output.size()) {
            this.output.remove(outputIndex);
        }
    }

    public int getInputType() {
        return this.input == null ? 0 : this.input.getType();
    }

    public String getInputValue() {
        return this.input == null ? null : this.input.getProperty("value");
    }

    public void setInput(Input i) {
        this.input = i;
    }

    public String[] getParameterNames() {
        return this.parameters.keySet().toArray(new String[this.parameters.size()]);
    }

    public String[] getParameterValues(String name) {
        if (name == null) {
            return null;
        }
        List list = (List)this.parameters.get(name);
        if (list == null) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public void setParameterValues(String name, String[] values) {
        if (name == null) {
            return;
        }
        if (values == null) {
            this.parameters.remove(name);
        } else {
            LinkedList<String> list = (LinkedList<String>)this.parameters.get(name);
            if (list == null) {
                list = new LinkedList<String>();
                this.parameters.put(name, list);
            } else {
                list.clear();
            }
            int i = 0;
            while (i < values.length) {
                if (values[i] != null) {
                    list.add(values[i]);
                }
                ++i;
            }
        }
    }

    @Override
    Object accept(IConversationCommandVisitor visitor) {
        return visitor.visitDataRequest(this);
    }

    public Object exportContents() {
        String pn;
        Iterator<String> iterator;
        int i;
        String[] props;
        Set<String> propNames;
        ArrayList<String> properties = new ArrayList<String>(this.properties.size() * 2);
        for (Map.Entry entry : this.properties.entrySet()) {
            properties.add((String)entry.getKey());
            properties.add((String)entry.getValue());
        }
        ArrayList<Object> output = new ArrayList<Object>(this.output.size() * 2);
        for (Output o : this.output) {
            output.add(o.getType());
            propNames = o.getPropertyNames();
            props = new String[propNames.size() * 2];
            i = 0;
            iterator = propNames.iterator();
            while (iterator.hasNext()) {
                props[i] = pn = iterator.next();
                props[i + 1] = o.getProperty(pn);
                ++i;
            }
            output.add(props);
        }
        ArrayList<String> parameters = new ArrayList<String>(this.parameters.size() * 2);
        for (Map.Entry entry : this.parameters.entrySet()) {
            parameters.add((String)entry.getKey());
            parameters.add((String)entry.getValue());
        }
        Object[] input = null;
        if (this.input != null) {
            input = new Object[2];
            input[0] = this.input.getType();
            propNames = this.input.getPropertyNames();
            props = new String[propNames.size() * 2];
            i = 0;
            iterator = propNames.iterator();
            while (iterator.hasNext()) {
                props[i] = pn = iterator.next();
                props[i + 1] = this.input.getProperty(pn);
                ++i;
            }
            input[1] = props;
        }
        return new Object[]{this.dataName, this.resultName, this.filledResultValue, this.noInputResultValue, properties.toArray(new String[properties.size()]), output.toArray(new Object[output.size()]), parameters.toArray(new String[parameters.size()]), input};
    }

    public void importContents(Object contents) {
        int p;
        String[] props;
        Object[] array = (Object[])contents;
        this.dataName = (String)array[0];
        this.resultName = (String)array[1];
        this.filledResultValue = (String)array[2];
        this.noInputResultValue = (String)array[3];
        this.properties.clear();
        String[] properties = (String[])array[4];
        int i = 0;
        while (i < properties.length) {
            this.properties.put(properties[i], properties[i + 1]);
            i += 2;
        }
        this.output.clear();
        Object[] output = (Object[])array[1];
        int i2 = 0;
        while (i2 < output.length) {
            Output o = new Output((String)output[i2]);
            props = (String[])output[i2 + 1];
            p = 0;
            while (p < props.length) {
                o.setProperty(props[p], props[p + 1]);
                p += 2;
            }
            this.output.add(o);
            i2 += 2;
        }
        this.parameters.clear();
        String[] parameters = (String[])array[6];
        int i3 = 0;
        while (i3 < parameters.length) {
            this.parameters.put(parameters[i3], parameters[i3 + 1]);
            i3 += 2;
        }
        Object[] input = (Object[])array[7];
        Input input2 = this.input = input == null ? null : new Input((Integer)input[0]);
        if (input != null) {
            props = (String[])input[1];
            p = 0;
            while (p < props.length) {
                this.input.setProperty(props[p], props[p + 1]);
                p += 2;
            }
        }
    }
}

