/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vtp.framework.interactions.core.commands.ConversationCommand;
import org.eclipse.vtp.framework.interactions.core.commands.IConversationCommandVisitor;

public class FinalCommand
extends ConversationCommand {
    private final Map<String, String> variables = new HashMap<String, String>();

    public String[] getVariableNames() {
        return this.variables.keySet().toArray(new String[this.variables.size()]);
    }

    public String getVariable(String name) {
        return this.variables.get(name);
    }

    public boolean addVariable(String name, String value) {
        this.variables.put(name, value);
        return true;
    }

    public boolean removeVariable(String name) {
        return this.variables.remove(name) != null;
    }

    @Override
    Object accept(IConversationCommandVisitor visitor) {
        return visitor.visitFinal(this);
    }

    public Object exportContents() {
        ArrayList<String> list = new ArrayList<String>(this.variables.size() * 2);
        for (Map.Entry<String, String> entry : this.variables.entrySet()) {
            list.add(entry.getKey());
            list.add(entry.getValue());
        }
        return list.toArray(new String[list.size()]);
    }

    public void importContents(Object contents) {
        this.variables.clear();
        String[] array = (String[])contents;
        int i = 0;
        while (i < array.length) {
            this.variables.put(array[i], array[i + 1]);
            i += 2;
        }
    }
}

