/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.configurations;

import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.InteractionsConstants;
import org.eclipse.vtp.framework.interactions.core.configurations.MediaConfiguration;
import org.eclipse.vtp.framework.interactions.core.media.IContentFactory;
import org.eclipse.vtp.framework.interactions.core.media.IInputGrammarFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DataRequestConfiguration
implements IConfiguration,
InteractionsConstants {
    private final IContentFactory contentFactory;
    private final IInputGrammarFactory inputFactory;
    private String outputName = "";
    private String inputName = "";
    private String dataName = "";
    private boolean secured = false;
    private MediaConfiguration mediaConfiguration = null;

    public DataRequestConfiguration(IContentFactory contentFactory, IInputGrammarFactory inputFactory) {
        this.contentFactory = contentFactory;
        this.inputFactory = inputFactory;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName == null ? "" : outputName;
    }

    public String getInputName() {
        return this.inputName;
    }

    public void setInputName(String inputName) {
        this.inputName = inputName == null ? "" : inputName;
    }

    public String getDataName() {
        return this.dataName;
    }

    public void setDataName(String dataName) {
        this.dataName = dataName == null ? "" : dataName;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    public MediaConfiguration getMediaConfiguration() {
        return this.mediaConfiguration;
    }

    public void setMediaConfiguration(MediaConfiguration mediaConfiguration) {
        this.mediaConfiguration = mediaConfiguration;
    }

    public void load(Element configurationElement) {
        this.outputName = configurationElement.getAttribute("output-name");
        this.inputName = configurationElement.getAttribute("input-name");
        this.dataName = configurationElement.getAttribute("data-name");
        this.secured = Boolean.parseBoolean(configurationElement.getAttribute("secured"));
        NodeList elements = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "media");
        this.mediaConfiguration = null;
        if (elements.getLength() == 0) {
            this.mediaConfiguration = null;
        } else {
            this.mediaConfiguration = new MediaConfiguration(this.contentFactory, this.inputFactory);
            this.mediaConfiguration.load((Element)elements.item(0));
        }
    }

    public void save(Element configurationElement) {
        configurationElement.setAttribute("output-name", this.outputName);
        configurationElement.setAttribute("input-name", this.inputName);
        configurationElement.setAttribute("data-name", this.dataName);
        configurationElement.setAttribute("secured", Boolean.toString(this.secured));
        if (this.mediaConfiguration == null) {
            return;
        }
        String mediaName = "media";
        String prefix = configurationElement.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            mediaName = String.valueOf(prefix) + ":" + mediaName;
        }
        Element element = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", mediaName);
        this.mediaConfiguration.save(element);
        configurationElement.appendChild(element);
    }
}

