/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.configurations;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.InteractionsConstants;
import org.eclipse.vtp.framework.interactions.core.media.IInputGrammarFactory;
import org.eclipse.vtp.framework.interactions.core.media.InputGrammar;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class InputConfiguration
implements IConfiguration,
InteractionsConstants {
    private final IInputGrammarFactory inputFactory;
    private final Map items = new HashMap();

    public InputConfiguration(IInputGrammarFactory inputFactory) {
        this.inputFactory = inputFactory;
    }

    public InputGrammar getItem(String brandName, String interactionTypeID, String languageID) {
        return (InputGrammar)this.items.get(String.valueOf(brandName) + interactionTypeID + languageID);
    }

    public void setItem(String brandName, String interactionTypeID, String languageID, InputGrammar item) {
        this.setItem(String.valueOf(brandName) + interactionTypeID + languageID, item);
    }

    public void setItem(String key, InputGrammar item) {
        if (item == null) {
            this.items.remove(key);
        } else {
            this.items.put(key, item);
        }
    }

    public void load(Element configurationElement) {
        this.items.clear();
        NodeList itemElements = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "input-item");
        int i = 0;
        while (i < itemElements.getLength()) {
            Element itemElement = (Element)itemElements.item(i);
            String key = itemElement.getAttribute("key");
            NodeList inputElements = itemElement.getChildNodes();
            InputGrammar input = null;
            int j = 0;
            while (input == null && j < inputElements.getLength()) {
                if (inputElements.item(j) instanceof Element) {
                    input = this.inputFactory.loadInput((Element)inputElements.item(j));
                }
                ++j;
            }
            if (input != null) {
                this.items.put(key, input);
            }
            ++i;
        }
    }

    public void save(Element configurationElement) {
        String inputItemName = "input-item";
        String prefix = configurationElement.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            inputItemName = String.valueOf(prefix) + ":" + inputItemName;
        }
        for (Map.Entry entry : this.items.entrySet()) {
            Element element = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", inputItemName);
            ((InputGrammar)entry.getValue()).store(element);
            element.setAttribute("key", (String)entry.getKey());
            configurationElement.appendChild(element);
        }
    }
}

