/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.configurations;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.InteractionsConstants;
import org.eclipse.vtp.framework.interactions.core.configurations.SharedContentConfiguration;
import org.eclipse.vtp.framework.interactions.core.media.IContentFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MediaProviderConfiguration
implements IConfiguration,
InteractionsConstants {
    private final IContentFactory contentFactory;
    private String id = "";
    private String formatterID = "";
    private String resourceManagerID = "";
    private final Set sharedContent = new HashSet();

    public MediaProviderConfiguration(IContentFactory contentFactory) {
        this.contentFactory = contentFactory;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id == null ? "" : id;
    }

    public String getFormatterID() {
        return this.formatterID;
    }

    public void setFormatterID(String formatterID) {
        this.formatterID = formatterID == null ? "" : formatterID;
    }

    public String getResourceManagerID() {
        return this.resourceManagerID;
    }

    public void setResourceManagerID(String resourceManagerID) {
        this.resourceManagerID = resourceManagerID == null ? "" : resourceManagerID;
    }

    public SharedContentConfiguration[] getSharedContent() {
        return this.sharedContent.toArray(new SharedContentConfiguration[this.sharedContent.size()]);
    }

    public void addSharedContent(SharedContentConfiguration sharedContent) {
        if (sharedContent == null) {
            return;
        }
        this.sharedContent.add(sharedContent);
    }

    public void removeSharedContent(SharedContentConfiguration sharedContent) {
        this.sharedContent.remove(sharedContent);
    }

    public void load(Element configurationElement) {
        this.id = configurationElement.getAttribute("id");
        this.formatterID = configurationElement.getAttribute("formatter");
        this.resourceManagerID = configurationElement.getAttribute("resource-manager");
        this.sharedContent.clear();
        NodeList list = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "shared-content");
        int i = 0;
        while (i < list.getLength()) {
            SharedContentConfiguration item = new SharedContentConfiguration(this.contentFactory);
            item.load((Element)list.item(i));
            this.sharedContent.add(item);
            ++i;
        }
    }

    public void save(Element configurationElement) {
        String prefix = configurationElement.getPrefix();
        configurationElement.setAttribute("id", this.id);
        configurationElement.setAttribute("formatter", this.formatterID);
        configurationElement.setAttribute("resource-manager", this.resourceManagerID);
        if (!this.sharedContent.isEmpty()) {
            String sharedContentName = "shared-content";
            if (prefix != null && prefix.length() > 0) {
                sharedContentName = String.valueOf(prefix) + ":" + sharedContentName;
            }
            Iterator i = this.sharedContent.iterator();
            while (i.hasNext()) {
                Element sharedContentElement = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", sharedContentName);
                ((SharedContentConfiguration)i.next()).save(sharedContentElement);
                configurationElement.appendChild(sharedContentElement);
            }
        }
    }
}

