/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.configurations;

import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.InteractionsConstants;
import org.w3c.dom.Element;

public class MetaDataItemConfiguration
implements IConfiguration,
InteractionsConstants {
    public static final int TYPE_STATIC = 0;
    public static final int TYPE_EXPRESSION = 1;
    public static final int TYPE_VARIABLE = 2;
    public static final int TYPE_MAP = 4;
    private String name = "";
    private int type = 0;
    private String value = "";
    private String scriptingLanguage = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getValueType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String getScriptingLanguage() {
        return this.scriptingLanguage;
    }

    public void setStaticValue(String value) {
        this.type = 0;
        this.value = value == null ? "" : value;
        this.scriptingLanguage = null;
    }

    public void setExpressionValue(String expression, String scriptingLanguage) {
        this.type = 1;
        this.value = expression == null ? "" : expression;
        this.scriptingLanguage = scriptingLanguage;
    }

    public void setVariableValue(String variableName) {
        this.type = 2;
        this.value = variableName == null ? "" : variableName;
        this.scriptingLanguage = null;
    }

    public void setMapValue(String variableName) {
        this.type = 4;
        this.value = variableName == null ? "" : variableName;
        this.scriptingLanguage = null;
    }

    public void load(Element configurationElement) {
        this.name = configurationElement.getAttribute("name");
        String typeString = configurationElement.getAttribute("type");
        this.type = typeString.equals("") ? 0 : ("static".equalsIgnoreCase(typeString) ? 0 : ("expression".equalsIgnoreCase(typeString) ? 1 : ("variable".equalsIgnoreCase(typeString) ? 2 : ("map".equalsIgnoreCase(typeString) ? 4 : Integer.parseInt(typeString)))));
        this.value = configurationElement.getAttribute("value");
        this.scriptingLanguage = configurationElement.hasAttribute("scripting-language") ? configurationElement.getAttribute("scripting-language") : null;
    }

    public void save(Element configurationElement) {
        configurationElement.setAttribute("name", this.name);
        String typeString = "static";
        switch (this.type) {
            case 1: {
                typeString = "expression";
                break;
            }
            case 2: {
                typeString = "variable";
                break;
            }
            case 4: {
                typeString = "map";
            }
        }
        configurationElement.setAttribute("type", typeString);
        configurationElement.setAttribute("value", this.value);
        if (this.scriptingLanguage != null) {
            configurationElement.setAttribute("scripting-language", this.scriptingLanguage);
        }
    }
}

