/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.configurations;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.InteractionsConstants;
import org.eclipse.vtp.framework.interactions.core.configurations.OutputNode;
import org.eclipse.vtp.framework.interactions.core.media.IContentFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OutputConfiguration
implements IConfiguration,
InteractionsConstants {
    private final IContentFactory contentFactory;
    private final Map<String, OutputNode[]> items = new HashMap<String, OutputNode[]>();

    public OutputConfiguration(IContentFactory contentFactory) {
        this.contentFactory = contentFactory;
    }

    public OutputNode[] getItem(String brandName, String interactionTypeID, String languageID) {
        return this.items.get(String.valueOf(brandName) + interactionTypeID + languageID);
    }

    public void setItem(String brandName, String interactionTypeID, String languageID, OutputNode[] item) {
        this.setItem(String.valueOf(brandName) + interactionTypeID + languageID, item);
    }

    public void setItem(String key, OutputNode[] item) {
        if (item == null) {
            this.items.remove(key);
        } else {
            this.items.put(key, item);
        }
    }

    public void load(Element configurationElement) {
        this.items.clear();
        NodeList outputItemElements = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "output-item");
        int i = 0;
        while (i < outputItemElements.getLength()) {
            Element outputItemElement = (Element)outputItemElements.item(i);
            String key = outputItemElement.getAttribute("key");
            this.items.put(key, OutputNode.loadAll(outputItemElement, this.contentFactory));
            ++i;
        }
    }

    public void save(Element configurationElement) {
        String outputItemName = "output-item";
        String prefix = configurationElement.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            outputItemName = String.valueOf(prefix) + ":" + outputItemName;
        }
        for (Map.Entry<String, OutputNode[]> entry : this.items.entrySet()) {
            Element outputItemElement = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", outputItemName);
            OutputNode[] outputNodeArray = entry.getValue();
            int n = outputNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                OutputNode node = outputNodeArray[n2];
                node.save(outputItemElement);
                ++n2;
            }
            outputItemElement.setAttribute("key", entry.getKey());
            configurationElement.appendChild(outputItemElement);
        }
    }
}

