/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.configurations;

import java.util.ArrayList;
import org.eclipse.vtp.framework.interactions.core.configurations.InteractionsConstants;
import org.eclipse.vtp.framework.interactions.core.configurations.OutputNode;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.IContentFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OutputContent
extends OutputNode
implements InteractionsConstants {
    private Content[] content = null;

    public OutputContent() {
    }

    public OutputContent(Content[] content) {
        this.content = content;
    }

    public Content[] getContent() {
        return this.content;
    }

    public void setContent(Content[] content) {
        this.content = content;
    }

    @Override
    void load(Element configurationElement, IContentFactory contentFactory) {
        NodeList contentElements = configurationElement.getChildNodes();
        ArrayList<Content> content = new ArrayList<Content>(contentElements.getLength());
        int j = 0;
        while (j < contentElements.getLength()) {
            if (contentElements.item(j) instanceof Element) {
                Element item = (Element)contentElements.item(j);
                Content loadContent = contentFactory.loadContent(item);
                content.add(loadContent);
            }
            ++j;
        }
        this.content = content.toArray(new Content[content.size()]);
    }

    @Override
    void save(Element configurationElement) {
        String outputNodeName = "output-node-content";
        String prefix = configurationElement.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            outputNodeName = String.valueOf(prefix) + ":" + outputNodeName;
        }
        Element outputNodeElement = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", outputNodeName);
        if (this.content != null) {
            int j = 0;
            while (j < this.content.length) {
                this.content[j].store(outputNodeElement);
                ++j;
            }
        }
        configurationElement.appendChild(outputNodeElement);
    }
}

