/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.configurations;

import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.InteractionsConstants;
import org.eclipse.vtp.framework.interactions.core.configurations.MediaConfiguration;
import org.eclipse.vtp.framework.interactions.core.media.IContentFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OutputMessageConfiguration
implements IConfiguration,
InteractionsConstants {
    private final IContentFactory contentFactory;
    private String outputName = "";
    private boolean secured = false;
    private MediaConfiguration mediaConfiguration = null;

    public OutputMessageConfiguration(IContentFactory contentFactory) {
        this.contentFactory = contentFactory;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName == null ? "" : outputName;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    public MediaConfiguration getMediaConfiguration() {
        return this.mediaConfiguration;
    }

    public void setMediaConfiguration(MediaConfiguration mediaConfiguration) {
        this.mediaConfiguration = mediaConfiguration;
    }

    public void load(Element configurationElement) {
        this.outputName = configurationElement.getAttribute("output-name");
        this.secured = Boolean.parseBoolean(configurationElement.getAttribute("secured"));
        NodeList elements = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "media");
        this.mediaConfiguration = null;
        if (elements.getLength() == 0) {
            this.mediaConfiguration = null;
        } else {
            this.mediaConfiguration = new MediaConfiguration(this.contentFactory, null);
            this.mediaConfiguration.load((Element)elements.item(0));
        }
    }

    public void save(Element configurationElement) {
        configurationElement.setAttribute("output-name", this.outputName);
        configurationElement.setAttribute("secured", Boolean.toString(this.secured));
        if (this.mediaConfiguration == null) {
            return;
        }
        String mediaName = "media";
        String prefix = configurationElement.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            mediaName = String.valueOf(prefix) + ":" + mediaName;
        }
        Element element = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", mediaName);
        this.mediaConfiguration.save(element);
        configurationElement.appendChild(element);
    }
}

