/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.configurations;

import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.InteractionsConstants;
import org.eclipse.vtp.framework.interactions.core.configurations.MediaConfiguration;
import org.eclipse.vtp.framework.interactions.core.media.IContentFactory;
import org.eclipse.vtp.framework.interactions.core.media.IInputGrammarFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SelectionChoiceConfiguration
implements IConfiguration,
InteractionsConstants {
    private final IContentFactory contentFactory;
    private final IInputGrammarFactory inputFactory;
    private String name = "";
    private String outputName = "";
    private String inputName = "";
    private String scriptingLanguage = null;
    private String script = null;
    private MediaConfiguration mediaConfiguration = null;

    public SelectionChoiceConfiguration(IContentFactory contentFactory, IInputGrammarFactory inputFactory) {
        this.contentFactory = contentFactory;
        this.inputFactory = inputFactory;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName == null ? "" : outputName;
    }

    public String getInputName() {
        return this.inputName;
    }

    public void setInputName(String inputName) {
        this.inputName = inputName == null ? "" : inputName;
    }

    public String getScriptingLanguage() {
        return this.scriptingLanguage;
    }

    public String getScript() {
        return this.script;
    }

    public void setScriptingLanguage(String scriptingLanguage) {
        this.scriptingLanguage = scriptingLanguage;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public MediaConfiguration getMediaConfiguration() {
        return this.mediaConfiguration;
    }

    public void setMediaConfiguration(MediaConfiguration mediaConfiguration) {
        this.mediaConfiguration = mediaConfiguration;
    }

    public void load(Element configurationElement) {
        this.name = configurationElement.getAttribute("name");
        this.outputName = configurationElement.getAttribute("output-name");
        this.inputName = configurationElement.getAttribute("input-name");
        this.scriptingLanguage = configurationElement.hasAttribute("scripting-language") ? configurationElement.getAttribute("scripting-language") : null;
        this.script = configurationElement.hasAttribute("script") ? configurationElement.getAttribute("script") : null;
        NodeList elements = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "media");
        this.mediaConfiguration = null;
        if (elements.getLength() == 0) {
            this.mediaConfiguration = null;
        } else {
            this.mediaConfiguration = new MediaConfiguration(this.contentFactory, this.inputFactory);
            this.mediaConfiguration.load((Element)elements.item(0));
        }
    }

    public void save(Element configurationElement) {
        configurationElement.setAttribute("name", this.name);
        configurationElement.setAttribute("output-name", this.outputName);
        configurationElement.setAttribute("input-name", this.inputName);
        if (this.scriptingLanguage != null) {
            configurationElement.setAttribute("scripting-language", this.scriptingLanguage);
        }
        if (this.script != null) {
            configurationElement.setAttribute("script", this.script);
        }
        if (this.mediaConfiguration == null) {
            return;
        }
        String mediaName = "media";
        String prefix = configurationElement.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            mediaName = String.valueOf(prefix) + ":" + mediaName;
        }
        Element element = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", mediaName);
        this.mediaConfiguration.save(element);
        configurationElement.appendChild(element);
    }
}

