/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.media;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.FormattableContent;
import org.eclipse.vtp.framework.interactions.core.media.IFormatter;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;
import org.eclipse.vtp.framework.interactions.core.media.TextContent;
import org.eclipse.vtp.framework.util.DateHelper;
import org.w3c.dom.Element;

public class DateContent
extends FormattableContent {
    public static final String ELEMENT_NAME = "date-content";

    public DateContent() {
    }

    public DateContent(Element element) {
        super(element);
    }

    @Override
    public String getContentTypeName() {
        return "DATE";
    }

    public List format(IFormatter formatter, IMediaProvider mediaProvider) {
        LinkedList<Content> ret = new LinkedList<Content>();
        if (this.getValueType() != 2) {
            Calendar date = DateHelper.parseDate((String)this.getValue());
            if (date != null) {
                ret.addAll(formatter.formatDate(date, mediaProvider.getFormatManager().getFormat(this, this.getFormatName()), this.getFormatOptions(), mediaProvider.getResourceManager()));
            } else {
                TextContent textContent = new TextContent();
                if (this.getValueType() == 1) {
                    textContent.setStaticText(this.getValue());
                } else {
                    textContent.setVariableText(this.getValue());
                }
                ret.add(textContent);
            }
        }
        return ret;
    }

    @Override
    public Element store(Element element) {
        Element thisElement = element.getOwnerDocument().createElementNS("http://www.eclipse.org/vtp/media/content", ELEMENT_NAME);
        element.appendChild(thisElement);
        super.storeBaseInfo(thisElement);
        return thisElement;
    }

    @Override
    public String getContentType() {
        return "org.eclipse.vtp.framework.interactions.core.media.content.date";
    }

    @Override
    public Content createCopy() {
        return this.configureCopy(new DateContent());
    }

    public static void main(String[] args) {
        String[] dates;
        String[] stringArray = dates = new String[]{"3/4/1977 3:45:34 pm EST", "3/4/1977 3:45:34 pm", "3/4/1977 3:45:34 EST", "3/4/1977 3:45 pm EST", "3/4/1977 3:45 pm", "3/4/1977 3:45 EST", "3:45:34 pm EST", "3:45:34 pm", "3:45:34 EST", "3/31/2010 3:45:34 pm EST", "1-4-1977", "6/4/1977"};
        int n = dates.length;
        int n2 = 0;
        while (n2 < n) {
            String date = stringArray[n2];
            DateContent.printDate(date);
            ++n2;
        }
        Calendar cal = Calendar.getInstance();
        System.out.println(DateHelper.toDateString((Calendar)cal));
        System.out.println(DateFormat.getDateTimeInstance().format(cal.getTime()));
    }

    public static void printDate(String date) {
        Calendar cal = DateHelper.parseDate((String)date);
        DateFormat df = DateFormat.getDateTimeInstance(2, 1);
        System.out.println(cal.getTimeZone());
        System.out.println(df.format(cal.getTime()));
        df.setTimeZone(cal.getTimeZone());
        System.out.println(df.format(cal.getTime()));
        System.out.println(DateHelper.toDateString((Calendar)cal));
    }
}

