/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.media;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.FormattableContent;
import org.eclipse.vtp.framework.interactions.core.media.IFormatter;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;
import org.w3c.dom.Element;

public class NumberContent
extends FormattableContent {
    public static final String ELEMENT_NAME = "number-content";

    public NumberContent() {
    }

    public NumberContent(Element element) {
        super(element);
    }

    @Override
    public String getContentTypeName() {
        return "NUMBER";
    }

    public List format(IFormatter formatter, IMediaProvider mediaProvider) {
        LinkedList<Content> ret = new LinkedList<Content>();
        try {
            if (this.getValueType() != 2) {
                ret.addAll(formatter.formatNumber(Integer.parseInt(this.getValue()), mediaProvider.getFormatManager().getFormat(this, this.getFormatName()), this.getFormatOptions(), mediaProvider.getResourceManager()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public Element store(Element element) {
        Element thisElement = element.getOwnerDocument().createElementNS("http://www.eclipse.org/vtp/media/content", ELEMENT_NAME);
        element.appendChild(thisElement);
        super.storeBaseInfo(thisElement);
        return thisElement;
    }

    @Override
    public String getContentType() {
        return "org.eclipse.vtp.framework.interactions.core.media.content.number";
    }

    @Override
    public Content createCopy() {
        return this.configureCopy(new NumberContent());
    }
}

