/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.framework.common.IBrand;
import org.eclipse.vtp.framework.common.IBrandSelection;
import org.eclipse.vtp.framework.common.IDataObject;
import org.eclipse.vtp.framework.common.ILastResult;
import org.eclipse.vtp.framework.common.ILastResultData;
import org.eclipse.vtp.framework.common.IMapObject;
import org.eclipse.vtp.framework.common.IScriptingEngine;
import org.eclipse.vtp.framework.common.IScriptingService;
import org.eclipse.vtp.framework.common.IVariableRegistry;
import org.eclipse.vtp.framework.common.configurations.AssignmentConfiguration;
import org.eclipse.vtp.framework.core.IExecutionContext;
import org.eclipse.vtp.framework.interactions.core.IInteractionTypeSelection;
import org.eclipse.vtp.framework.interactions.core.ILanguageSelection;
import org.eclipse.vtp.framework.interactions.core.commands.BridgeMessageCommand;
import org.eclipse.vtp.framework.interactions.core.commands.ConversationCommand;
import org.eclipse.vtp.framework.interactions.core.commands.DataRequestCommand;
import org.eclipse.vtp.framework.interactions.core.commands.EndMessageCommand;
import org.eclipse.vtp.framework.interactions.core.commands.ExternalReferenceCommand;
import org.eclipse.vtp.framework.interactions.core.commands.FinalCommand;
import org.eclipse.vtp.framework.interactions.core.commands.InitialCommand;
import org.eclipse.vtp.framework.interactions.core.commands.Input;
import org.eclipse.vtp.framework.interactions.core.commands.InputRequestCommand;
import org.eclipse.vtp.framework.interactions.core.commands.MetaDataMessageCommand;
import org.eclipse.vtp.framework.interactions.core.commands.MetaDataRequestCommand;
import org.eclipse.vtp.framework.interactions.core.commands.Output;
import org.eclipse.vtp.framework.interactions.core.commands.OutputMessageCommand;
import org.eclipse.vtp.framework.interactions.core.commands.SelectionRequestCommand;
import org.eclipse.vtp.framework.interactions.core.commands.TransferMessageCommand;
import org.eclipse.vtp.framework.interactions.core.configurations.BridgeMessageConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.DataRequestConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.ExternalReferenceConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.InputConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.InputRequestConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.MediaConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.MetaDataConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.MetaDataItemConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.OutputCase;
import org.eclipse.vtp.framework.interactions.core.configurations.OutputConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.OutputContent;
import org.eclipse.vtp.framework.interactions.core.configurations.OutputMessageConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.OutputNode;
import org.eclipse.vtp.framework.interactions.core.configurations.OutputSwitch;
import org.eclipse.vtp.framework.interactions.core.configurations.PropertyConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.SelectionChoiceConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.SelectionRequestConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.TransferMessageConfiguration;
import org.eclipse.vtp.framework.interactions.core.conversation.IBridgeMessage;
import org.eclipse.vtp.framework.interactions.core.conversation.IConversation;
import org.eclipse.vtp.framework.interactions.core.conversation.IDataRequest;
import org.eclipse.vtp.framework.interactions.core.conversation.IEndMessage;
import org.eclipse.vtp.framework.interactions.core.conversation.IExternalReference;
import org.eclipse.vtp.framework.interactions.core.conversation.IFinal;
import org.eclipse.vtp.framework.interactions.core.conversation.IInitial;
import org.eclipse.vtp.framework.interactions.core.conversation.IInputRequest;
import org.eclipse.vtp.framework.interactions.core.conversation.IInteraction;
import org.eclipse.vtp.framework.interactions.core.conversation.IMetaDataMessage;
import org.eclipse.vtp.framework.interactions.core.conversation.IMetaDataRequest;
import org.eclipse.vtp.framework.interactions.core.conversation.IOutputMessage;
import org.eclipse.vtp.framework.interactions.core.conversation.ISelectionRequest;
import org.eclipse.vtp.framework.interactions.core.conversation.ITransferMessage;
import org.eclipse.vtp.framework.interactions.core.media.BuiltInInputGrammar;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.FileContent;
import org.eclipse.vtp.framework.interactions.core.media.FileInputGrammar;
import org.eclipse.vtp.framework.interactions.core.media.IDataSet;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProviderRegistry;
import org.eclipse.vtp.framework.interactions.core.media.IResourceManager;
import org.eclipse.vtp.framework.interactions.core.media.InlineInputGrammar;
import org.eclipse.vtp.framework.interactions.core.media.InputGrammar;
import org.eclipse.vtp.framework.interactions.core.media.MediaRenderingManager;
import org.eclipse.vtp.framework.interactions.core.media.TextContent;
import org.eclipse.vtp.framework.spi.ICommand;
import org.eclipse.vtp.framework.spi.ICommandProcessor;

public class Conversation
implements IConversation {
    private final ICommandProcessor commandProcessor;
    private final IBrandSelection brandSelection;
    private final IInteractionTypeSelection interactionTypeSelection;
    private final ILanguageSelection languageSelection;
    private final IMediaProviderRegistry mediaProviderRegistry;
    private final IVariableRegistry variableRegistry;
    private final IDataSet dataSet;
    private final IScriptingService scriptingService;
    private final ILastResult lastResult;
    private final IExecutionContext context;

    public Conversation(ICommandProcessor commandProcessor, IBrandSelection brandSelection, IInteractionTypeSelection interactionTypeSelection, ILanguageSelection languageSelection, IMediaProviderRegistry mediaProviderRegistry, IVariableRegistry variableRegistry, IScriptingService scriptingService, ILastResult lastResult, IExecutionContext context) {
        this.commandProcessor = commandProcessor;
        this.brandSelection = brandSelection;
        this.interactionTypeSelection = interactionTypeSelection;
        this.languageSelection = languageSelection;
        this.mediaProviderRegistry = mediaProviderRegistry;
        this.variableRegistry = variableRegistry;
        this.lastResult = lastResult;
        this.dataSet = new DataSet(variableRegistry);
        this.scriptingService = scriptingService;
        this.context = context;
    }

    @Override
    public List<Content> resolveOutput(OutputConfiguration configuration) {
        if (configuration == null) {
            return Collections.emptyList();
        }
        String interactionTypeID = this.interactionTypeSelection.getSelectedInteractionType().getId();
        String languageID = this.languageSelection.getSelectedLanguage();
        OutputNode[] nodes = null;
        IBrand brand = this.brandSelection.getSelectedBrand();
        while (brand != null && nodes == null) {
            nodes = configuration.getItem(brand.getName(), interactionTypeID, languageID);
            if (nodes != null) continue;
            brand = brand.getParentBrand();
        }
        if (nodes == null) {
            return Collections.emptyList();
        }
        String mediaProviderID = null;
        while (brand != null && mediaProviderID == null) {
            mediaProviderID = this.mediaProviderRegistry.lookupMediaProviderID(brand.getId(), interactionTypeID, languageID);
            if (mediaProviderID != null) continue;
            brand = brand.getParentBrand();
        }
        if (mediaProviderID == null) {
            return Collections.emptyList();
        }
        LinkedList<Content> results = new LinkedList<Content>();
        OutputNode[] outputNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            OutputNode node = outputNodeArray[n2];
            this.resolveContentNode(node, results);
            ++n2;
        }
        List<Content> content = new MediaRenderingManager(this.mediaProviderRegistry.getMediaProvider(mediaProviderID), this.dataSet).renderContent(7, results);
        return content;
    }

    private void resolveContentNode(OutputNode node, List<Content> results) {
        block4: {
            block5: {
                if (!(node instanceof OutputContent)) break block5;
                Content[] contentArray = ((OutputContent)node).getContent();
                int n = contentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Content content = contentArray[n2];
                    results.add(content);
                    ++n2;
                }
                break block4;
            }
            if (!(node instanceof OutputSwitch)) break block4;
            OutputCase[] outputCaseArray = ((OutputSwitch)node).getCases();
            int n = outputCaseArray.length;
            int n3 = 0;
            while (n3 < n) {
                OutputCase c = outputCaseArray[n3];
                Object result = this.scriptingService.createScriptingEngine(c.getScriptingLanguage()).execute(c.getScript());
                this.context.info("Evaluating prompt guard condition");
                this.context.info(c.getScript());
                this.context.info("Result: " + result.toString());
                if (result != null && "true".equalsIgnoreCase(result.toString())) {
                    OutputNode[] outputNodeArray = c.getNodes();
                    int n4 = outputNodeArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        OutputNode child = outputNodeArray[n5];
                        this.resolveContentNode(child, results);
                        ++n5;
                    }
                    break;
                }
                ++n3;
            }
        }
    }

    public Output resolveFilePath(OutputConfiguration configuration, String relativePath) {
        Output fileOutput = new Output("org.eclipse.vtp.output.File");
        if (relativePath.startsWith("http://") || relativePath.startsWith("dtmf:")) {
            fileOutput.setProperty("value", relativePath);
            return fileOutput;
        }
        String interactionTypeID = this.interactionTypeSelection.getSelectedInteractionType().getId();
        String languageID = this.languageSelection.getSelectedLanguage();
        Content[] result = null;
        IBrand brand = this.brandSelection.getSelectedBrand();
        String mediaProviderID = null;
        while (brand != null && mediaProviderID == null) {
            IResourceManager resourceManager;
            IMediaProvider provider;
            mediaProviderID = this.mediaProviderRegistry.lookupMediaProviderID(brand.getId(), interactionTypeID, languageID);
            if (mediaProviderID != null && (provider = this.mediaProviderRegistry.getMediaProvider(mediaProviderID)) != null && (resourceManager = provider.getResourceManager()) != null && resourceManager.isFileResource(relativePath)) break;
            mediaProviderID = null;
            brand = brand.getParentBrand();
        }
        if (mediaProviderID == null) {
            fileOutput.setProperty("value", relativePath);
            return fileOutput;
        }
        fileOutput.setProperty("media-provider", mediaProviderID);
        fileOutput.setProperty("value", String.valueOf(mediaProviderID) + "/" + relativePath);
        fileOutput.setProperty("original-path", relativePath);
        return fileOutput;
    }

    @Override
    public InputGrammar resolveInput(InputConfiguration configuration) {
        if (configuration == null) {
            return null;
        }
        String interactionTypeID = this.interactionTypeSelection.getSelectedInteractionType().getId();
        String languageID = this.languageSelection.getSelectedLanguage();
        InputGrammar result = null;
        IBrand brand = this.brandSelection.getSelectedBrand();
        while (brand != null && result == null) {
            result = configuration.getItem(brand.getName(), interactionTypeID, languageID);
            if (result != null) continue;
            brand = brand.getParentBrand();
        }
        if (result == null) {
            return null;
        }
        String mediaProviderID = null;
        while (brand != null && mediaProviderID == null) {
            mediaProviderID = this.mediaProviderRegistry.lookupMediaProviderID(brand.getId(), interactionTypeID, languageID);
            if (mediaProviderID != null) continue;
            brand = brand.getParentBrand();
        }
        if (mediaProviderID == null) {
            return null;
        }
        if (result.isDataAware()) {
            result = result.captureData(this.scriptingService, this.dataSet);
        }
        return result;
    }

    public Input resolveFilePath(InputConfiguration configuration, String relativePath) {
        Input input = new Input(1);
        if (relativePath.startsWith("http://") || relativePath.startsWith("dtmf:")) {
            input.setProperty("value", relativePath);
            return input;
        }
        String interactionTypeID = this.interactionTypeSelection.getSelectedInteractionType().getId();
        String languageID = this.languageSelection.getSelectedLanguage();
        InputGrammar result = null;
        IBrand brand = this.brandSelection.getSelectedBrand();
        while (brand != null && result == null) {
            result = configuration.getItem(brand.getName(), interactionTypeID, languageID);
            if (result != null) continue;
            brand = brand.getParentBrand();
        }
        if (result == null) {
            input.setProperty("value", relativePath);
            return input;
        }
        String mediaProviderID = null;
        while (brand != null && mediaProviderID == null) {
            mediaProviderID = this.mediaProviderRegistry.lookupMediaProviderID(brand.getId(), interactionTypeID, languageID);
            if (mediaProviderID != null) continue;
            brand = brand.getParentBrand();
        }
        if (mediaProviderID == null) {
            input.setProperty("value", relativePath);
            return input;
        }
        input.setProperty("media-provider", mediaProviderID);
        input.setProperty("value", String.valueOf(mediaProviderID) + "/" + relativePath);
        input.setProperty("original-path", relativePath);
        return input;
    }

    @Override
    public String resolveProperty(PropertyConfiguration configuration, boolean useInteractionType) {
        return this.resolveProperty(configuration, useInteractionType, false);
    }

    @Override
    public String resolveProperty(PropertyConfiguration configuration, boolean useInteractionType, boolean useLanguage) {
        if (configuration == null) {
            return null;
        }
        String interactionTypeID = this.interactionTypeSelection.getSelectedInteractionType().getId();
        String languageID = this.languageSelection.getSelectedLanguage();
        String result = null;
        PropertyConfiguration.Value value = null;
        IBrand brand = this.brandSelection.getSelectedBrand();
        while (brand != null) {
            value = configuration.getItem(brand.getName(), useInteractionType ? interactionTypeID : "", useLanguage ? languageID : "");
            if (value != null) break;
            brand = brand.getParentBrand();
        }
        if (value == null) {
            return null;
        }
        result = "variable".equals(value.getType()) ? this.variableRegistry.getVariable(value.getValue()).toString() : ("expression".equals(value.getType()) ? String.valueOf(this.scriptingService.createScriptingEngine("JavaScript").execute(value.getValue())) : value.getValue());
        return result;
    }

    private List resolveMetaData(MetaDataConfiguration configuration) {
        String interactionTypeID = this.interactionTypeSelection.getSelectedInteractionType().getId();
        String languageID = this.languageSelection.getSelectedLanguage();
        MetaDataItemConfiguration[] items = null;
        IBrand brand = this.brandSelection.getSelectedBrand();
        while (brand != null && items == null) {
            items = configuration.getItem(String.valueOf(brand.getName()) + interactionTypeID + languageID);
            brand = brand.getParentBrand();
        }
        if (items == null) {
            brand = this.brandSelection.getSelectedBrand();
            while (brand != null && items == null) {
                items = configuration.getItem(brand.getName());
                brand = brand.getParentBrand();
            }
            if (items == null) {
                return Collections.EMPTY_LIST;
            }
        }
        ArrayList<MetaDataItemConfiguration> results = new ArrayList<MetaDataItemConfiguration>(items.length);
        int i = 0;
        while (i < items.length) {
            block12: {
                MetaDataItemConfiguration item = items[i];
                switch (items[i].getValueType()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        item = new MetaDataItemConfiguration();
                        item.setName(items[i].getName());
                        item.setStaticValue(String.valueOf(this.scriptingService.createScriptingEngine(items[i].getScriptingLanguage()).execute(items[i].getValue())));
                        break;
                    }
                    case 2: {
                        item = new MetaDataItemConfiguration();
                        item.setName(items[i].getName());
                        item.setStaticValue(this.dataSet.getData(items[i].getValue()).toString());
                        break;
                    }
                    case 4: {
                        IMapObject map = (IMapObject)this.variableRegistry.getVariable(items[i].getValue());
                        for (Map.Entry entry : map.getValues().entrySet()) {
                            MetaDataItemConfiguration mdic = new MetaDataItemConfiguration();
                            mdic.setName((String)entry.getKey());
                            mdic.setStaticValue(((IDataObject)entry.getValue()).toString());
                            results.add(mdic);
                        }
                        break block12;
                    }
                    default: {
                        break block12;
                    }
                }
                results.add(item);
            }
            ++i;
        }
        return results;
    }

    @Override
    public IInitial createInitial(String resultParameterName, Map variables) {
        return new Initial(resultParameterName, variables);
    }

    @Override
    public IOutputMessage createOutputMessage(OutputMessageConfiguration configuration, String resultParameterName) {
        return new OutputMessage(configuration, resultParameterName);
    }

    @Override
    public IMetaDataMessage createMetaDataMessage(MetaDataConfiguration configuration, String resultParameterName) {
        return new MetaDataMessage(configuration, resultParameterName);
    }

    @Override
    public IMetaDataRequest createMetaDataRequest(MetaDataConfiguration configuration, String resultParameterName) {
        return new MetaDataRequest(configuration, resultParameterName);
    }

    @Override
    public IInputRequest createInputRequest(InputRequestConfiguration configuration, String resultParameterName) {
        return new InputRequest(configuration, resultParameterName);
    }

    @Override
    public ISelectionRequest createSelectionRequest(SelectionRequestConfiguration configuration, String resultParameterName) {
        return new SelectionRequest(configuration, resultParameterName);
    }

    @Override
    public IDataRequest createDataRequest(DataRequestConfiguration configuration, String resultParameterName) {
        return new DataRequest(configuration, resultParameterName);
    }

    @Override
    public IExternalReference createExternalReference(ExternalReferenceConfiguration configuration, String resultParameterName) {
        return new ExternalReference(configuration, resultParameterName);
    }

    @Override
    public ITransferMessage createTransferMessage(TransferMessageConfiguration configuration) {
        return new TransferMessage(configuration);
    }

    @Override
    public IBridgeMessage createBridgeMessage(BridgeMessageConfiguration configuration, String resultParameterName) {
        return new BridgeMessage(configuration, resultParameterName);
    }

    @Override
    public IEndMessage createEndMessage(AssignmentConfiguration[] configurations) {
        EndMessage message = new EndMessage();
        int i = 0;
        while (i < configurations.length) {
            message.setVariableValue(configurations[i].getName(), this.variableRegistry.getVariable(configurations[i].getName()).toString());
            ++i;
        }
        return message;
    }

    @Override
    public IFinal createFinal() {
        return new Final();
    }

    private abstract class AbstractInteraction
    implements IInteraction {
        private AbstractInteraction() {
        }

        abstract ConversationCommand createCommand();

        @Override
        public final boolean enqueue() {
            ConversationCommand command = this.createCommand();
            if (command == null) {
                return false;
            }
            return Conversation.this.commandProcessor.enqueue((ICommand)command);
        }

        @Override
        public final boolean process() throws IllegalStateException {
            ConversationCommand command = this.createCommand();
            if (command == null) {
                return false;
            }
            return Conversation.this.commandProcessor.process((ICommand)command);
        }
    }

    private final class BridgeMessage
    extends AbstractInteraction
    implements IBridgeMessage {
        private final BridgeMessageConfiguration configuration;
        private final String resultParameterName;

        BridgeMessage(BridgeMessageConfiguration configuration, String resultParameterName) {
            this.configuration = configuration;
            this.resultParameterName = resultParameterName;
        }

        @Override
        ConversationCommand createCommand() {
            MediaConfiguration mediaConfiguration = this.configuration.getMediaConfiguration();
            PropertyConfiguration transferTypePropertyConfig = mediaConfiguration.getPropertyConfiguration("transferType");
            PropertyConfiguration typePropertyConfig = mediaConfiguration.getPropertyConfiguration("type");
            PropertyConfiguration destinationPropertyConfig = mediaConfiguration.getPropertyConfiguration("destination");
            String value = Conversation.this.resolveProperty(destinationPropertyConfig, true, true);
            if (value == null) {
                value = Conversation.this.resolveProperty(destinationPropertyConfig, true, false);
            }
            if (value == null) {
                return null;
            }
            String type = Conversation.this.resolveProperty(typePropertyConfig, true, true);
            if (type == null) {
                type = Conversation.this.resolveProperty(typePropertyConfig, true, false);
            }
            if ("variable".equalsIgnoreCase(type)) {
                value = String.valueOf(Conversation.this.variableRegistry.getVariable(value));
            } else if ("expression".equalsIgnoreCase(type)) {
                value = String.valueOf(Conversation.this.scriptingService.createScriptingEngine("JavaScript").execute(value));
            }
            String bridgedValue = Conversation.this.resolveProperty(transferTypePropertyConfig, true, true);
            if (bridgedValue == null) {
                bridgedValue = Conversation.this.resolveProperty(transferTypePropertyConfig, true, false);
            }
            BridgeMessageCommand command = new BridgeMessageCommand();
            command.setTransferType(bridgedValue);
            command.setDestination(value);
            command.setResultName(this.resultParameterName);
            command.setTransferredResultValue("transferred");
            command.setBusyResultValue("busy");
            command.setUnavailableResultValue("unavailable");
            command.setNoAuthResultValue("noauthorization");
            command.setBadDestResultValue("baddestination");
            command.setNoRouteResultValue("noroute");
            command.setNoResourceResultValue("noresource");
            command.setProtocolResultValue("protocol");
            command.setBadBridgeResultValue("badbridge");
            command.setBadUriResultValue("baduri");
            command.setHangupResultValue("error.disconnect.hangup");
            return command;
        }
    }

    private final class DataRequest
    extends AbstractInteraction
    implements IDataRequest {
        private final DataRequestConfiguration configuration;
        private final String resultParameterName;
        private final Map parameters = new HashMap();

        DataRequest(DataRequestConfiguration configuration, String resultParameterName) {
            this.configuration = configuration;
            this.resultParameterName = resultParameterName;
        }

        @Override
        ConversationCommand createCommand() {
            DataRequestCommand command = new DataRequestCommand();
            command.setSecured(this.configuration.isSecured());
            command.setResultName(this.resultParameterName);
            command.setFilledResultValue("success.filled");
            command.setNoInputResultValue("error.input.noinput");
            command.setHangupResultValue("error.disconnect.hangup");
            command.setDataName(this.configuration.getDataName());
            MediaConfiguration mediaConfig = this.configuration.getMediaConfiguration();
            if (mediaConfig != null) {
                String[] propertyNames = mediaConfig.getPropertyConfigurationNames();
                int i = 0;
                while (i < propertyNames.length) {
                    String value = Conversation.this.resolveProperty(mediaConfig.getPropertyConfiguration(propertyNames[i]), true);
                    if (value != null) {
                        command.setPropertyValue(propertyNames[i], value);
                    }
                    ++i;
                }
                OutputConfiguration outputConfiguration = mediaConfig.getOutputConfiguration(this.configuration.getOutputName());
                List<Content> content = Conversation.this.resolveOutput(outputConfiguration);
                for (Content item : content) {
                    if (item instanceof TextContent) {
                        Output textOutput = new Output("org.eclipse.vtp.output.Text");
                        textOutput.setProperty("value", ((TextContent)item).getText());
                        command.addOutput(textOutput);
                        continue;
                    }
                    if (!(item instanceof FileContent)) continue;
                    command.addOutput(Conversation.this.resolveFilePath(outputConfiguration, ((FileContent)item).getPath()));
                }
                InputGrammar grammar = Conversation.this.resolveInput(mediaConfig.getInputConfiguration(this.configuration.getInputName()));
                if (grammar instanceof FileInputGrammar) {
                    command.setInput(Conversation.this.resolveFilePath(mediaConfig.getInputConfiguration(this.configuration.getInputName()), ((FileInputGrammar)grammar).getPath()));
                } else if (grammar instanceof BuiltInInputGrammar) {
                    Input customInput = new Input(Integer.MAX_VALUE);
                    customInput.setProperty("value", ((BuiltInInputGrammar)grammar).getBuiltInInputURI());
                    command.setInput(customInput);
                } else if (grammar instanceof InlineInputGrammar) {
                    Input inlineInput = new Input(2);
                    inlineInput.setProperty("value", ((InlineInputGrammar)grammar).getGrammarText());
                    command.setInput(inlineInput);
                }
            }
            for (Map.Entry entry : this.parameters.entrySet()) {
                command.setParameterValues((String)entry.getKey(), (String[])entry.getValue());
            }
            return command;
        }

        @Override
        public void setParameterValue(String name, String value) {
            String[] stringArray;
            if (name == null) {
                return;
            }
            if (value == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = value;
            }
            this.setParameterValues(name, stringArray);
        }

        @Override
        public void setParameterValues(String name, String[] values) {
            if (name == null) {
                return;
            }
            if (values == null) {
                this.parameters.remove(name);
            } else {
                this.parameters.put(name, values);
            }
        }
    }

    private final class DataSet
    implements IDataSet {
        private final IVariableRegistry variables;

        DataSet(IVariableRegistry variables) {
            this.variables = variables;
        }

        @Override
        public Object getData(String name) {
            IDataObject result;
            if (name.startsWith("LastResult") && name.length() > "LastResult.".length()) {
                String prop = name.substring(11);
                ILastResultData data = (ILastResultData)Conversation.this.lastResult.getResults().get(0);
                if (data == null) {
                    return null;
                }
                if ("confidence".equals(prop)) {
                    return Integer.toString(data.getConfidence());
                }
                if ("utterance".equals(prop)) {
                    return data.getUtterence();
                }
                if ("inputmode".equals(prop)) {
                    return data.getInputMode();
                }
                if ("interpretation".equals(prop)) {
                    return data.getInterpretation();
                }
            }
            if ((result = this.variables.getVariable(name)) == null) {
                return "";
            }
            return result.toString();
        }
    }

    private final class EndMessage
    extends AbstractInteraction
    implements IEndMessage {
        private final Map<String, String> variables = new HashMap<String, String>();

        private EndMessage() {
        }

        @Override
        public void setVariableValue(String variableName, String variableValue) {
            this.variables.put(variableName, variableValue);
        }

        @Override
        ConversationCommand createCommand() {
            EndMessageCommand command = new EndMessageCommand();
            for (Map.Entry<String, String> entry : this.variables.entrySet()) {
                command.addVariable(entry.getKey(), entry.getValue());
            }
            return command;
        }
    }

    private final class ExternalReference
    extends AbstractInteraction
    implements IExternalReference {
        private final ExternalReferenceConfiguration configuration;
        private final String resultParameterName;
        private final Map parameters = new HashMap();

        ExternalReference(ExternalReferenceConfiguration configuration, String resultParameterName) {
            this.configuration = configuration;
            this.resultParameterName = resultParameterName;
        }

        @Override
        ConversationCommand createCommand() {
            IDataObject obj;
            ExternalReferenceCommand command = new ExternalReferenceCommand();
            command.setReferenceName(this.configuration.getName());
            command.setResultName(this.resultParameterName);
            command.setFilledResultValue("success.filled");
            command.setHangupResultValue("error.disconnect.hangup");
            command.setReferenceURI(this.configuration.getUrl());
            String[] keys = this.configuration.getInputNames();
            int i = 0;
            while (i < keys.length) {
                if (!this.configuration.isInputVariable(keys[i])) {
                    command.setInputArgumentValue(keys[i], this.configuration.getInputValue(keys[i]));
                } else {
                    obj = Conversation.this.variableRegistry.getVariable(this.configuration.getInputValue(keys[i]));
                    if (obj != null) {
                        command.setInputArgumentValue(keys[i], "'" + obj.toString() + "'");
                    }
                }
                ++i;
            }
            keys = this.configuration.getOutputNames();
            i = 0;
            while (i < keys.length) {
                command.setOutputArgumentValue(keys[i], this.configuration.getOutputValue(keys[i]));
                ++i;
            }
            keys = this.configuration.getURLParameterNames();
            i = 0;
            while (i < keys.length) {
                if (!this.configuration.isURLParameterVariable(keys[i])) {
                    command.setURLParameterValue(keys[i], this.configuration.getURLParameterValue(keys[i]));
                } else {
                    obj = Conversation.this.variableRegistry.getVariable(this.configuration.getURLParameterValue(keys[i]));
                    if (obj != null) {
                        command.setURLParameterValue(keys[i], "'" + obj.toString() + "'");
                    }
                }
                ++i;
            }
            for (Map.Entry entry : this.parameters.entrySet()) {
                command.setParameterValues((String)entry.getKey(), (String[])entry.getValue());
            }
            return command;
        }

        @Override
        public void setParameterValue(String name, String value) {
            String[] stringArray;
            if (name == null) {
                return;
            }
            if (value == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = value;
            }
            this.setParameterValues(name, stringArray);
        }

        @Override
        public void setParameterValues(String name, String[] values) {
            if (name == null) {
                return;
            }
            if (values == null) {
                this.parameters.remove(name);
            } else {
                this.parameters.put(name, values);
            }
        }
    }

    private final class Final
    extends AbstractInteraction
    implements IFinal {
        private final Map<String, String> variables = new HashMap<String, String>();

        private Final() {
        }

        @Override
        public void setVariableValue(String variableName, String variableValue) {
            this.variables.put(variableName, variableValue);
        }

        @Override
        ConversationCommand createCommand() {
            FinalCommand command = new FinalCommand();
            for (Map.Entry<String, String> entry : this.variables.entrySet()) {
                command.addVariable(entry.getKey(), entry.getValue());
            }
            return command;
        }
    }

    private final class Initial
    extends AbstractInteraction
    implements IInitial {
        private final String resultParameterName;
        private final Map variables;
        private final Map parameters = new HashMap();

        Initial(String resultParameterName, Map variables) {
            this.resultParameterName = resultParameterName;
            this.variables = variables;
        }

        @Override
        ConversationCommand createCommand() {
            InitialCommand command = new InitialCommand();
            command.setResultName(this.resultParameterName);
            command.setResultValue("success.filled");
            command.setHangupResultValue("error.disconnect.hangup");
            for (Map.Entry entry : this.variables.entrySet()) {
                command.setVariable((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this.parameters.entrySet()) {
                command.setParameterValues((String)entry.getKey(), (String[])entry.getValue());
            }
            return command;
        }

        @Override
        public void setParameterValue(String name, String value) {
            String[] stringArray;
            if (name == null) {
                return;
            }
            if (value == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = value;
            }
            this.setParameterValues(name, stringArray);
        }

        @Override
        public void setParameterValues(String name, String[] values) {
            if (name == null) {
                return;
            }
            if (values == null) {
                this.parameters.remove(name);
            } else {
                this.parameters.put(name, values);
            }
        }
    }

    private final class InputRequest
    extends AbstractInteraction
    implements IInputRequest {
        private final InputRequestConfiguration configuration;
        private final String resultParameterName;
        private final Map parameters = new HashMap();

        InputRequest(InputRequestConfiguration configuration, String resultParameterName) {
            this.configuration = configuration;
            this.resultParameterName = resultParameterName;
        }

        @Override
        ConversationCommand createCommand() {
            InputRequestCommand command = new InputRequestCommand();
            command.setSecured(this.configuration.isSecured());
            command.setResultName(this.resultParameterName);
            command.setFilledResultValue("success.filled");
            command.setNoInputResultValue("error.input.noinput");
            command.setNoMatchResultValue("error.input.nomatch");
            command.setHangupResultValue("error.disconnect.hangup");
            command.setDataName(this.configuration.getDataName());
            MediaConfiguration mediaConfig = this.configuration.getMediaConfiguration();
            if (mediaConfig != null) {
                String[] propertyNames = mediaConfig.getPropertyConfigurationNames();
                int i = 0;
                while (i < propertyNames.length) {
                    String value = Conversation.this.resolveProperty(mediaConfig.getPropertyConfiguration(propertyNames[i]), true);
                    if (value != null) {
                        command.setPropertyValue(propertyNames[i], value);
                    }
                    ++i;
                }
                OutputConfiguration outputConfiguration = mediaConfig.getOutputConfiguration(this.configuration.getOutputName());
                List<Content> content = Conversation.this.resolveOutput(outputConfiguration);
                for (Content item : content) {
                    if (item instanceof TextContent) {
                        Output textOutput = new Output("org.eclipse.vtp.output.Text");
                        textOutput.setProperty("value", ((TextContent)item).getText());
                        command.addOutput(textOutput);
                        continue;
                    }
                    if (!(item instanceof FileContent)) continue;
                    command.addOutput(Conversation.this.resolveFilePath(outputConfiguration, ((FileContent)item).getPath()));
                }
                InputConfiguration inputConfiguration = mediaConfig.getInputConfiguration(this.configuration.getInputName());
                InputGrammar grammar = Conversation.this.resolveInput(inputConfiguration);
                if (grammar instanceof FileInputGrammar) {
                    command.setInput(Conversation.this.resolveFilePath(inputConfiguration, ((FileInputGrammar)grammar).getPath()));
                } else if (grammar instanceof BuiltInInputGrammar) {
                    Input customInput = new Input(Integer.MAX_VALUE);
                    customInput.setProperty("value", ((BuiltInInputGrammar)grammar).getBuiltInInputURI());
                    command.setInput(customInput);
                } else if (grammar instanceof InlineInputGrammar) {
                    Input inlineInput = new Input(2);
                    inlineInput.setProperty("value", ((InlineInputGrammar)grammar).getGrammarText());
                    command.setInput(inlineInput);
                }
                InputConfiguration inputConfiguration2 = mediaConfig.getInputConfiguration(this.configuration.getInputName2());
                InputGrammar grammar2 = Conversation.this.resolveInput(inputConfiguration2);
                if (grammar2 instanceof FileInputGrammar) {
                    command.setInput2(Conversation.this.resolveFilePath(inputConfiguration2, ((FileInputGrammar)grammar2).getPath()));
                } else if (grammar2 instanceof BuiltInInputGrammar) {
                    Input customInput = new Input(Integer.MAX_VALUE);
                    customInput.setProperty("value", ((BuiltInInputGrammar)grammar2).getBuiltInInputURI());
                    command.setInput2(customInput);
                } else if (grammar2 instanceof InlineInputGrammar) {
                    Input inlineInput = new Input(2);
                    inlineInput.setProperty("value", ((InlineInputGrammar)grammar2).getGrammarText());
                    command.setInput2(inlineInput);
                }
            }
            for (Map.Entry entry : this.parameters.entrySet()) {
                command.setParameterValues((String)entry.getKey(), (String[])entry.getValue());
            }
            return command;
        }

        @Override
        public void setParameterValue(String name, String value) {
            String[] stringArray;
            if (name == null) {
                return;
            }
            if (value == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = value;
            }
            this.setParameterValues(name, stringArray);
        }

        @Override
        public void setParameterValues(String name, String[] values) {
            if (name == null) {
                return;
            }
            if (values == null) {
                this.parameters.remove(name);
            } else {
                this.parameters.put(name, values);
            }
        }
    }

    private final class MetaDataMessage
    extends AbstractInteraction
    implements IMetaDataMessage {
        private final MetaDataConfiguration configuration;
        private final String resultParameterName;
        private final Map parameters = new HashMap();

        MetaDataMessage(MetaDataConfiguration configuration, String resultParameterName) {
            this.configuration = configuration;
            this.resultParameterName = resultParameterName;
        }

        @Override
        ConversationCommand createCommand() {
            MetaDataMessageCommand command = new MetaDataMessageCommand();
            command.setResultName(this.resultParameterName);
            command.setFilledResultValue("success.filled");
            List metaData = Conversation.this.resolveMetaData(this.configuration);
            for (MetaDataItemConfiguration metaDataItemConfiguration : metaData) {
                command.setMetaDataValue(metaDataItemConfiguration.getName(), metaDataItemConfiguration.getValue());
            }
            for (Map.Entry entry : this.parameters.entrySet()) {
                command.setParameterValues((String)entry.getKey(), (String[])entry.getValue());
            }
            return command;
        }

        @Override
        public void setParameterValue(String name, String value) {
            String[] stringArray;
            if (name == null) {
                return;
            }
            if (value == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = value;
            }
            this.setParameterValues(name, stringArray);
        }

        @Override
        public void setParameterValues(String name, String[] values) {
            if (name == null) {
                return;
            }
            if (values == null) {
                this.parameters.remove(name);
            } else {
                this.parameters.put(name, values);
            }
        }
    }

    private final class MetaDataRequest
    extends AbstractInteraction
    implements IMetaDataRequest {
        private final MetaDataConfiguration configuration;
        private final String resultParameterName;
        private final Map parameters = new HashMap();

        MetaDataRequest(MetaDataConfiguration configuration, String resultParameterName) {
            this.configuration = configuration;
            this.resultParameterName = resultParameterName;
        }

        @Override
        ConversationCommand createCommand() {
            MetaDataRequestCommand command = new MetaDataRequestCommand();
            command.setResultName(this.resultParameterName);
            command.setFilledResultValue("success.filled");
            command.setHangupResultValue("error.disconnect.hangup");
            command.setDataName("GetAttachedData");
            List metaData = Conversation.this.resolveMetaData(this.configuration);
            for (MetaDataItemConfiguration metaDataItemConfiguration : metaData) {
                command.addMetaDataName(metaDataItemConfiguration.getName());
            }
            for (Map.Entry entry : this.parameters.entrySet()) {
                command.setParameterValues((String)entry.getKey(), (String[])entry.getValue());
            }
            return command;
        }

        @Override
        public void setParameterValue(String name, String value) {
            String[] stringArray;
            if (name == null) {
                return;
            }
            if (value == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = value;
            }
            this.setParameterValues(name, stringArray);
        }

        @Override
        public void setParameterValues(String name, String[] values) {
            if (name == null) {
                return;
            }
            if (values == null) {
                this.parameters.remove(name);
            } else {
                this.parameters.put(name, values);
            }
        }
    }

    private final class OutputMessage
    extends AbstractInteraction
    implements IOutputMessage {
        private final OutputMessageConfiguration configuration;
        private final String resultParameterName;
        private final Map parameters = new HashMap();

        OutputMessage(OutputMessageConfiguration configuration, String resultParameterName) {
            this.configuration = configuration;
            this.resultParameterName = resultParameterName;
        }

        @Override
        ConversationCommand createCommand() {
            OutputMessageCommand command = new OutputMessageCommand();
            command.setResultName(this.resultParameterName);
            command.setFilledResultValue("success.filled");
            command.setHangupResultValue("error.disconnect.hangup");
            command.setSecured(this.configuration.isSecured());
            MediaConfiguration mediaConfig = this.configuration.getMediaConfiguration();
            if (mediaConfig != null) {
                String[] propertyNames = mediaConfig.getPropertyConfigurationNames();
                int i = 0;
                while (i < propertyNames.length) {
                    String value = Conversation.this.resolveProperty(mediaConfig.getPropertyConfiguration(propertyNames[i]), true);
                    if (value != null) {
                        command.setPropertyValue(propertyNames[i], value);
                    }
                    ++i;
                }
                OutputConfiguration outputConfiguration = mediaConfig.getOutputConfiguration(this.configuration.getOutputName());
                List<Content> content = Conversation.this.resolveOutput(outputConfiguration);
                for (Content item : content) {
                    if (item instanceof TextContent) {
                        Output textOutput = new Output("org.eclipse.vtp.output.Text");
                        textOutput.setProperty("value", ((TextContent)item).getText());
                        command.addOutput(textOutput);
                        continue;
                    }
                    if (!(item instanceof FileContent)) continue;
                    command.addOutput(Conversation.this.resolveFilePath(outputConfiguration, ((FileContent)item).getPath()));
                }
            }
            for (Map.Entry entry : this.parameters.entrySet()) {
                command.setParameterValues((String)entry.getKey(), (String[])entry.getValue());
            }
            return command;
        }

        @Override
        public void setParameterValue(String name, String value) {
            String[] stringArray;
            if (name == null) {
                return;
            }
            if (value == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = value;
            }
            this.setParameterValues(name, stringArray);
        }

        @Override
        public void setParameterValues(String name, String[] values) {
            if (name == null) {
                return;
            }
            if (values == null) {
                this.parameters.remove(name);
            } else {
                this.parameters.put(name, values);
            }
        }
    }

    private final class SelectionRequest
    extends AbstractInteraction
    implements ISelectionRequest {
        private final SelectionRequestConfiguration configuration;
        private final String resultParameterName;
        private final Map parameters = new HashMap();

        SelectionRequest(SelectionRequestConfiguration configuration, String resultParameterName) {
            this.configuration = configuration;
            this.resultParameterName = resultParameterName;
        }

        @Override
        ConversationCommand createCommand() {
            SelectionRequestCommand command;
            block22: {
                command = new SelectionRequestCommand();
                command.setSecured(this.configuration.isSecured());
                command.setResultName(this.resultParameterName);
                command.setFilledResultValue("success.filled");
                command.setNoInputResultValue("error.input.noinput");
                command.setNoMatchResultValue("error.input.nomatch");
                command.setHangupResultValue("error.disconnect.hangup");
                command.setSelectionName(this.configuration.getDataName());
                MediaConfiguration mediaConfig = this.configuration.getMediaConfiguration();
                if (mediaConfig != null) {
                    String[] propertyNames = mediaConfig.getPropertyConfigurationNames();
                    int i = 0;
                    while (i < propertyNames.length) {
                        String value = Conversation.this.resolveProperty(mediaConfig.getPropertyConfiguration(propertyNames[i]), true);
                        if (value != null) {
                            command.setPropertyValue(propertyNames[i], value);
                        }
                        ++i;
                    }
                    OutputConfiguration outputConfiguration = mediaConfig.getOutputConfiguration(this.configuration.getOutputName());
                    List<Content> content = Conversation.this.resolveOutput(outputConfiguration);
                    for (Content item : content) {
                        if (item instanceof TextContent) {
                            Output textOutput = new Output("org.eclipse.vtp.output.Text");
                            textOutput.setProperty("value", ((TextContent)item).getText());
                            command.addOutput(textOutput);
                            continue;
                        }
                        if (!(item instanceof FileContent)) continue;
                        command.addOutput(Conversation.this.resolveFilePath(outputConfiguration, ((FileContent)item).getPath()));
                    }
                }
                SelectionChoiceConfiguration[] choices = this.configuration.getChoices();
                HashMap<String, SelectionChoiceConfiguration> choiceIndex = new HashMap<String, SelectionChoiceConfiguration>(choices.length);
                int i = 0;
                while (i < choices.length) {
                    choiceIndex.put(choices[i].getName(), choices[i]);
                    ++i;
                }
                String[] choiceNames = null;
                IBrand brand = Conversation.this.brandSelection.getSelectedBrand();
                while (choiceNames == null && brand != null) {
                    choiceNames = this.configuration.getBrandedChoices(brand.getName());
                    brand = brand.getParentBrand();
                }
                if (choiceNames == null) break block22;
                int i2 = 0;
                int index = 0;
                while (i2 < choiceNames.length) {
                    block23: {
                        SelectionChoiceConfiguration choice;
                        block24: {
                            IScriptingEngine engine;
                            choice = (SelectionChoiceConfiguration)choiceIndex.get(choiceNames[i2]);
                            if (choice == null) break block23;
                            String script = choice.getScript();
                            String scriptingLanguage = choice.getScriptingLanguage();
                            if (scriptingLanguage == null || script == null || (engine = Conversation.this.scriptingService.createScriptingEngine(scriptingLanguage)) == null) break block24;
                            Object scriptResult = engine.execute(script);
                            if (Boolean.FALSE.toString().equalsIgnoreCase(String.valueOf(scriptResult))) break block23;
                        }
                        command.addOption(choice.getName());
                        mediaConfig = choice.getMediaConfiguration();
                        if (mediaConfig != null) {
                            String[] propertyNames = mediaConfig.getPropertyConfigurationNames();
                            int j = 0;
                            while (j < propertyNames.length) {
                                String value = Conversation.this.resolveProperty(mediaConfig.getPropertyConfiguration(propertyNames[j]), true);
                                if (value != null) {
                                    command.setOptionProperty(index, propertyNames[j], value);
                                }
                                ++j;
                            }
                            OutputConfiguration outputConfiguration = mediaConfig.getOutputConfiguration(choice.getOutputName());
                            List<Content> content = Conversation.this.resolveOutput(outputConfiguration);
                            for (Content item : content) {
                                if (item instanceof TextContent) {
                                    Output textOutput = new Output("org.eclipse.vtp.output.Text");
                                    textOutput.setProperty("value", ((TextContent)item).getText());
                                    command.addOptionOutput(index, textOutput);
                                    continue;
                                }
                                if (!(item instanceof FileContent)) continue;
                                command.addOptionOutput(index, Conversation.this.resolveFilePath(outputConfiguration, ((FileContent)item).getPath()));
                            }
                            InputConfiguration inputConfiguration = mediaConfig.getInputConfiguration(choice.getInputName());
                            InputGrammar grammar = Conversation.this.resolveInput(inputConfiguration);
                            if (grammar instanceof FileInputGrammar) {
                                command.setOptionInput(index, Conversation.this.resolveFilePath(inputConfiguration, ((FileInputGrammar)grammar).getPath()));
                            } else if (grammar instanceof BuiltInInputGrammar) {
                                Input customInput = new Input(Integer.MAX_VALUE);
                                customInput.setProperty("value", ((BuiltInInputGrammar)grammar).getBuiltInInputURI());
                                command.setOptionInput(index, customInput);
                            } else if (grammar instanceof InlineInputGrammar) {
                                Input inlineInput = new Input(2);
                                inlineInput.setProperty("value", ((InlineInputGrammar)grammar).getGrammarText());
                                command.setOptionInput(index, inlineInput);
                            }
                        }
                        ++index;
                    }
                    ++i2;
                }
            }
            for (Map.Entry entry : this.parameters.entrySet()) {
                command.setParameterValues((String)entry.getKey(), (String[])entry.getValue());
            }
            return command;
        }

        @Override
        public void setParameterValue(String name, String value) {
            String[] stringArray;
            if (name == null) {
                return;
            }
            if (value == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = value;
            }
            this.setParameterValues(name, stringArray);
        }

        @Override
        public void setParameterValues(String name, String[] values) {
            if (name == null) {
                return;
            }
            if (values == null) {
                this.parameters.remove(name);
            } else {
                this.parameters.put(name, values);
            }
        }
    }

    private final class TransferMessage
    extends AbstractInteraction
    implements ITransferMessage {
        private final TransferMessageConfiguration configuration;

        TransferMessage(TransferMessageConfiguration configuration) {
            this.configuration = configuration;
        }

        @Override
        ConversationCommand createCommand() {
            String value = Conversation.this.resolveProperty(this.configuration.getDestination(), true);
            if (value == null) {
                return null;
            }
            String type = Conversation.this.resolveProperty(this.configuration.getType(), true);
            if ("variable".equalsIgnoreCase(type)) {
                value = String.valueOf(Conversation.this.variableRegistry.getVariable(value));
            } else if ("expression".equalsIgnoreCase(type)) {
                value = String.valueOf(Conversation.this.scriptingService.createScriptingEngine("JavaScript").execute(value));
            }
            TransferMessageCommand command = new TransferMessageCommand();
            command.setDestination(value);
            return command;
        }
    }
}

