/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.framework.interactions.core.media.IFormatter;
import org.eclipse.vtp.framework.interactions.core.media.IFormatterRegistry;
import org.osgi.framework.Bundle;

public class FormatterRegistry
implements IFormatterRegistry {
    private final Map formatters;

    public FormatterRegistry(IExtensionRegistry registry) {
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.vtp.framework.interactions.core.formatterTypes");
        IExtension[] extensions = point.getExtensions();
        HashMap<String, IFormatter> formatters = new HashMap<String, IFormatter>(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            Bundle bundle = Platform.getBundle((String)extensions[i].getContributor().getName());
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                try {
                    formatters.put(elements[j].getAttribute("id"), (IFormatter)bundle.loadClass(elements[j].getAttribute("class")).newInstance());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
        this.formatters = Collections.unmodifiableMap(formatters);
    }

    @Override
    public String[] getFormatterIDs() {
        return this.formatters.keySet().toArray(new String[this.formatters.size()]);
    }

    @Override
    public IFormatter getFormatter(String formatterID) {
        return (IFormatter)this.formatters.get(formatterID);
    }
}

