/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.framework.common.IScriptable;
import org.eclipse.vtp.framework.interactions.core.ILanguageRegistry;
import org.eclipse.vtp.framework.interactions.core.configurations.LanguageConfiguration;

public class LanguageRegistry
implements ILanguageRegistry,
IScriptable {
    private final Map<String, List<String>> languageMapping;

    public LanguageRegistry(LanguageConfiguration[] configurations) {
        HashMap<String, ArrayList<String>> mapping = new HashMap<String, ArrayList<String>>();
        int i = 0;
        while (i < configurations.length) {
            ArrayList<String> languages = (ArrayList<String>)mapping.get(configurations[i].getInteractionType());
            if (languages == null) {
                languages = new ArrayList<String>();
                mapping.put(configurations[i].getInteractionType(), languages);
            }
            languages.add(configurations[i].getID());
            ++i;
        }
        this.languageMapping = Collections.unmodifiableMap(mapping);
    }

    @Override
    public String[] getLanguageIDs(String interactionType) {
        List<String> languages = this.languageMapping.get(interactionType);
        if (languages == null) {
            return new String[0];
        }
        return languages.toArray(new String[languages.size()]);
    }

    public boolean clearEntry(String name) {
        return false;
    }

    public boolean clearItem(int index) {
        return false;
    }

    public Object getEntry(String name) {
        return null;
    }

    public String[] getFunctionNames() {
        return new String[]{"getLanguage"};
    }

    public Object getItem(int index) {
        if (index > -1 && index < this.languageMapping.size()) {
            return this.languageMapping.get(index);
        }
        return null;
    }

    public String getName() {
        return "Languages";
    }

    public String[] getPropertyNames() {
        return new String[0];
    }

    public boolean hasEntry(String name) {
        return false;
    }

    public boolean hasItem(int index) {
        return index > -1 && index < this.languageMapping.size();
    }

    public boolean hasValue() {
        return false;
    }

    public Object invokeFunction(String name, Object[] arguments) {
        if ("getLanguage".equals(name) && arguments.length > 0) {
            return arguments[0];
        }
        return null;
    }

    public boolean setEntry(String name, Object value) {
        return false;
    }

    public boolean setItem(int index, Object value) {
        return false;
    }

    public Object toValue() {
        return null;
    }

    public boolean isMutable() {
        return false;
    }
}

