/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.voice.media;

import org.eclipse.vtp.framework.common.IScriptingEngine;
import org.eclipse.vtp.framework.common.IScriptingService;
import org.eclipse.vtp.framework.interactions.core.media.IDataSet;
import org.eclipse.vtp.framework.interactions.core.media.InlineInputGrammar;
import org.eclipse.vtp.framework.interactions.core.media.InputGrammar;
import org.eclipse.vtp.framework.interactions.voice.media.TextInputGrammar;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.Element;

public class DynamicInputGrammar
extends InlineInputGrammar {
    public static final String ELEMENT_NAME = "dynamic-input-grammar";
    private String script = "var grammar = '<grammar mode=\"DTMF\" version=\"1.0\" root=\"ROOT\">';\r\ngrammar += '<rule id=\"ROOT\" scope=\"public\">';\r\n\r\n/*Insert your grammar text here*/\r\n\r\ngrammar += '</rule></grammar>';";

    public DynamicInputGrammar() {
    }

    public DynamicInputGrammar(Element element) {
        this.script = XMLUtilities.getElementTextDataNoEx((Element)element, (boolean)true);
        if (this.script == null) {
            this.script = "";
        }
    }

    public boolean isDataAware() {
        return true;
    }

    public InputGrammar captureData(IScriptingService scriptingService, IDataSet dataSet) {
        try {
            IScriptingEngine engine = scriptingService.createScriptingEngine("JavaScript");
            Object obj = engine.execute(this.script);
            if (obj != null && obj instanceof String) {
                TextInputGrammar ret = new TextInputGrammar();
                ret.setText((String)obj);
                return ret;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public Element store(Element element) {
        Element thisElement = element.getOwnerDocument().createElementNS("http://www.eclipse.org/vtp/media/voice/input", ELEMENT_NAME);
        element.appendChild(thisElement);
        thisElement.setTextContent(this.script);
        return thisElement;
    }

    public String toString() {
        return "DYNAMIC INLINE GRAMMAR";
    }

    public String getInputGrammarType() {
        return "org.eclipse.vtp.framework.interactions.voice.media.input.dynamic";
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getGrammarText() {
        return "Dynamic grammar was not processed properly";
    }
}

