/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.voice.media;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.DateContent;
import org.eclipse.vtp.framework.interactions.core.media.DigitsContent;
import org.eclipse.vtp.framework.interactions.core.media.FormattableContent;
import org.eclipse.vtp.framework.interactions.core.media.IResourceManager;
import org.eclipse.vtp.framework.interactions.core.media.LettersContent;
import org.eclipse.vtp.framework.interactions.core.media.MoneyContent;
import org.eclipse.vtp.framework.interactions.core.media.TextContent;
import org.eclipse.vtp.framework.interactions.voice.media.AudioContent;
import org.eclipse.vtp.framework.interactions.voice.media.VoiceFormatter;

public class SimpleEnglishVoiceFormatter
extends VoiceFormatter {
    private static final Currency USD_CURRENCY = Currency.getInstance("USD");
    private static final String[] months = new String[]{"january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december"};
    private static final String[] days = new String[]{"sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday"};
    private static final Map<Character, String[]> characterReplacements = new HashMap<Character, String[]>();

    static {
        characterReplacements.put(Character.valueOf('#'), new String[]{"pound", "Pound"});
        characterReplacements.put(Character.valueOf('!'), new String[]{"exclamation", "Exclamation Point"});
        characterReplacements.put(Character.valueOf('_'), new String[]{"underscore", "Under score"});
        characterReplacements.put(Character.valueOf('-'), new String[]{"dash", "Dash"});
        characterReplacements.put(Character.valueOf('['), new String[]{"rightsquarebracket", "Right Square Bracket"});
        characterReplacements.put(Character.valueOf(']'), new String[]{"leftsquarebracket", "Left Square Bracket"});
        characterReplacements.put(Character.valueOf('{'), new String[]{"rightcurlybrace", "Right Curly Brace"});
        characterReplacements.put(Character.valueOf('}'), new String[]{"leftcurlybrace", "Left Curly Brace"});
        characterReplacements.put(Character.valueOf('*'), new String[]{"asterisk", "Asterisk"});
        characterReplacements.put(Character.valueOf('@'), new String[]{"atsign", "At Sign"});
        characterReplacements.put(Character.valueOf('%'), new String[]{"percentsign", "Percent Sign"});
        characterReplacements.put(Character.valueOf('&'), new String[]{"ampersand", "Ampersand"});
        characterReplacements.put(Character.valueOf('+'), new String[]{"plussign", "Plus Sign"});
        characterReplacements.put(Character.valueOf('='), new String[]{"equalssign", "Equals Sign"});
        characterReplacements.put(Character.valueOf('$'), new String[]{"dollarsign", "Dollar Sign"});
        characterReplacements.put(Character.valueOf('?'), new String[]{"questionmark", "Question Mark"});
        characterReplacements.put(Character.valueOf('/'), new String[]{"forwardslash", "Forward Slash"});
        characterReplacements.put(Character.valueOf('\\'), new String[]{"backslash", "Back Slash"});
        characterReplacements.put(Character.valueOf('|'), new String[]{"bar", "Bar"});
        characterReplacements.put(Character.valueOf(','), new String[]{"comma", "Comma"});
        characterReplacements.put(Character.valueOf('.'), new String[]{"period", "Period"});
        characterReplacements.put(Character.valueOf('<'), new String[]{"lessthansign", "Less Than Sign"});
        characterReplacements.put(Character.valueOf('>'), new String[]{"greaterthansign", "Greater Than Sign"});
        characterReplacements.put(Character.valueOf('\''), new String[]{"singlequote", "Single Quote"});
        characterReplacements.put(Character.valueOf('\"'), new String[]{"doublequote", "Double Quote"});
        characterReplacements.put(Character.valueOf('('), new String[]{"rightparentheses", "Right Parentheses"});
        characterReplacements.put(Character.valueOf(')'), new String[]{"leftparentheses", "Left Parentheses"});
    }

    public List<Content> formatDate(Date date, String formatDefinition, String formatOptions, IResourceManager resourceManager) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return this.formatDate(cal, formatDefinition, formatOptions, resourceManager);
    }

    @Override
    public List<Content> formatDate(Calendar cal, String formatDefinition, String formatOptions, IResourceManager resourceManager) {
        ArrayList<Content> ret = new ArrayList<Content>();
        if (formatDefinition == null || formatDefinition.equals("")) {
            TextContent tc = new TextContent();
            DateFormat df = DateFormat.getDateTimeInstance();
            df.setTimeZone(cal.getTimeZone());
            tc.setStaticText(String.valueOf(df.format(cal.getTime())) + " ");
            ret.add((Content)tc);
        } else if (formatDefinition.equals("Short Date") || formatDefinition.equals("Default")) {
            ret.addAll(this.formatNumber(cal.get(2) + 1, "Default", "", resourceManager));
            ret.addAll(this.formatOrdinal(cal.get(5), "Default", "", resourceManager));
            ret.addAll(this.formatYear(Integer.toString(cal.get(1)), resourceManager));
        } else if (formatDefinition.equals("Long Date")) {
            ret.add(this.getAudioContent(resourceManager, "/Months/", months[cal.get(2)], months[cal.get(2)]));
            ret.addAll(this.formatOrdinal(cal.get(5), "Default", "", resourceManager));
            ret.addAll(this.formatYear(Integer.toString(cal.get(1)), resourceManager));
        } else if (formatDefinition.equals("Short Time")) {
            int hour = cal.get(10);
            ret.addAll(this.formatNumber(hour == 0 ? 12 : hour, "Default", "", resourceManager));
            int minute = cal.get(12);
            if (minute > 0 && minute < 10) {
                ret.addAll(this.formatLetters("O", "Default", "", resourceManager));
                ret.addAll(this.formatNumber(minute, "Default", "", resourceManager));
            } else if (minute >= 10) {
                ret.addAll(this.formatNumber(minute, "Default", "", resourceManager));
            }
            if (cal.get(9) == 0) {
                ret.addAll(this.formatLetters("AM", "Default", "", resourceManager));
            } else {
                ret.addAll(this.formatLetters("PM", "Default", "", resourceManager));
            }
        } else if (formatDefinition.equals("Long Time")) {
            int hour = cal.get(10);
            ret.addAll(this.formatNumber(hour == 0 ? 12 : hour, "Default", "", resourceManager));
            int minute = cal.get(12);
            if (minute > 0 && minute < 10) {
                ret.addAll(this.formatLetters("O", "Default", "", resourceManager));
                ret.addAll(this.formatNumber(minute, "Default", "", resourceManager));
            } else if (minute >= 10) {
                ret.addAll(this.formatNumber(minute, "Default", "", resourceManager));
            }
            if (cal.get(9) == 0) {
                ret.addAll(this.formatLetters("AM", "Default", "", resourceManager));
            } else {
                ret.addAll(this.formatLetters("PM", "Default", "", resourceManager));
            }
        } else if (formatDefinition.equals("Short Date Time")) {
            ret.addAll(this.formatNumber(cal.get(2) + 1, "Default", "", resourceManager));
            ret.addAll(this.formatOrdinal(cal.get(5), "Default", "", resourceManager));
            ret.addAll(this.formatYear(Integer.toString(cal.get(1)), resourceManager));
            int hour = cal.get(10);
            ret.addAll(this.formatNumber(hour == 0 ? 12 : hour, "Default", "", resourceManager));
            int minute = cal.get(12);
            if (minute > 0 && minute < 10) {
                ret.addAll(this.formatLetters("O", "Default", "", resourceManager));
                ret.addAll(this.formatNumber(minute, "Default", "", resourceManager));
            } else if (minute >= 10) {
                ret.addAll(this.formatNumber(minute, "Default", "", resourceManager));
            }
            if (cal.get(9) == 0) {
                ret.addAll(this.formatLetters("AM", "Default", "", resourceManager));
            } else {
                ret.addAll(this.formatLetters("PM", "Default", "", resourceManager));
            }
        } else if (formatDefinition.equals("Long Date Time")) {
            ret.add(this.getAudioContent(resourceManager, "/Months/", months[cal.get(2)], months[cal.get(2)]));
            ret.addAll(this.formatOrdinal(cal.get(5), "Default", "", resourceManager));
            ret.addAll(this.formatYear(Integer.toString(cal.get(1)), resourceManager));
            int hour = cal.get(10);
            ret.addAll(this.formatNumber(hour == 0 ? 12 : hour, "Default", "", resourceManager));
            int minute = cal.get(12);
            if (minute > 0 && minute < 10) {
                ret.addAll(this.formatLetters("O", "Default", "", resourceManager));
                ret.addAll(this.formatNumber(minute, "Default", "", resourceManager));
            } else if (minute >= 10) {
                ret.addAll(this.formatNumber(minute, "Default", "", resourceManager));
            }
            if (cal.get(9) == 0) {
                ret.addAll(this.formatLetters("AM", "Default", "", resourceManager));
            } else {
                ret.addAll(this.formatLetters("PM", "Default", "", resourceManager));
            }
        } else if (formatDefinition.equals("Day of Week")) {
            int calYear = cal.get(1);
            int calDay = cal.get(6);
            int calHour = cal.get(11);
            Calendar now = Calendar.getInstance(cal.getTimeZone());
            int nowYear = now.get(1);
            int nowDay = now.get(6);
            HashSet<String> options = new HashSet<String>(Arrays.asList(formatOptions.split(",")));
            if (calYear == nowYear && calDay == nowDay) {
                if (options.contains("this")) {
                    if (calHour < 12) {
                        ret.add(this.getAudioContent(resourceManager, "/DayOfWeek/", "this_morning", "this morning"));
                    } else if (calHour < 17) {
                        ret.add(this.getAudioContent(resourceManager, "/DayOfWeek/", "this_afternoon", "this afternoon"));
                    } else {
                        ret.add(this.getAudioContent(resourceManager, "/DayOfWeek/", "this_evening", "this evening"));
                    }
                } else if (options.contains("today")) {
                    ret.add(this.getAudioContent(resourceManager, "/DayOfWeek/", "today", "today"));
                } else {
                    ret.add(this.getAudioContent(resourceManager, "/DayOfWeek/", days[cal.get(7) - 1], days[cal.get(7) - 1]));
                }
            } else {
                int distance = 1;
                Calendar search = (Calendar)now.clone();
                while (distance < 14) {
                    search.add(5, 1);
                    if (calYear == search.get(1) && calDay == search.get(6)) break;
                    ++distance;
                }
                if (distance == 1 && options.contains("tomorrow")) {
                    ret.add(this.getAudioContent(resourceManager, "/DayOfWeek/", "tomorrow", "tomorrow"));
                } else if (distance < 7) {
                    ret.add(this.getAudioContent(resourceManager, "/DayOfWeek/", days[cal.get(7) - 1], days[cal.get(7) - 1]));
                } else if (distance < 14 && options.contains("next")) {
                    ret.add(this.getAudioContent(resourceManager, "/DayOfWeek/", "next", "next"));
                    ret.add(this.getAudioContent(resourceManager, "/DayOfWeek/", days[cal.get(7) - 1], days[cal.get(7) - 1]));
                } else {
                    this.formatDate(cal, "Short Date", "", resourceManager);
                }
            }
        } else if (formatDefinition.equals("Hour of Day")) {
            HashSet<String> options = new HashSet<String>(Arrays.asList(formatOptions.split(",")));
            int hour = cal.get(10);
            ret.addAll(this.formatNumber(hour == 0 ? 12 : hour, "Default", "", resourceManager));
            if (options.contains("minutes")) {
                int minute = cal.get(12);
                if (minute > 0 && minute < 10) {
                    ret.addAll(this.formatLetters("O", "Default", "", resourceManager));
                    ret.addAll(this.formatNumber(minute, "Default", "", resourceManager));
                } else if (minute >= 10) {
                    ret.addAll(this.formatNumber(minute, "Default", "", resourceManager));
                }
            }
            if (cal.get(9) == 0) {
                ret.addAll(this.formatLetters("AM", "Default", "", resourceManager));
            } else {
                ret.addAll(this.formatLetters("PM", "Default", "", resourceManager));
            }
        }
        return ret;
    }

    public List<Content> formatDigits(String digits, String formatDefinition, String formatOptions, IResourceManager resourceManager) {
        char[] chars = digits.toCharArray();
        ArrayList<Content> ret = new ArrayList<Content>();
        if (formatDefinition.equals("DTMF")) {
            int i = 0;
            while (i < chars.length) {
                AudioContent ac;
                String s = new String(chars, i, 1);
                if (s.equals("*")) {
                    s = "star";
                } else if (s.equals("#")) {
                    s = "pound";
                }
                if (resourceManager.isFileResource("/DTMF/Dtmf-" + s + ".vox")) {
                    ac = new AudioContent();
                    ac.setStaticPath("/DTMF/Dtmf-" + s + ".vox");
                    ret.add((Content)ac);
                } else if (resourceManager.isFileResource("/DTMF/Dtmf-" + s + ".wav")) {
                    ac = new AudioContent();
                    ac.setStaticPath("/DTMF/Dtmf-" + s + ".wav");
                    ret.add((Content)ac);
                } else if (resourceManager.isFileResource("/DTMF/Dtmf-" + s + ".au")) {
                    ac = new AudioContent();
                    ac.setStaticPath("/DTMF/Dtmf-" + s + ".au");
                    ret.add((Content)ac);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < chars.length) {
                if (Character.isDigit(chars[i])) {
                    AudioContent ac;
                    if (resourceManager.isFileResource("/Digits/" + new String(chars, i, 1) + ".vox")) {
                        ac = new AudioContent();
                        ac.setStaticPath("/Digits/" + new String(chars, i, 1) + ".vox");
                        ret.add((Content)ac);
                    } else if (resourceManager.isFileResource("/Digits/" + new String(chars, i, 1) + ".wav")) {
                        ac = new AudioContent();
                        ac.setStaticPath("/Digits/" + new String(chars, i, 1) + ".wav");
                        ret.add((Content)ac);
                    } else if (resourceManager.isFileResource("/Digits/" + new String(chars, i, 1) + ".au")) {
                        ac = new AudioContent();
                        ac.setStaticPath("/Digits/" + new String(chars, i, 1) + ".au");
                        ret.add((Content)ac);
                    } else {
                        TextContent tc = new TextContent();
                        tc.setStaticText(String.valueOf(new String(chars, i, 1)) + " ");
                        ret.add((Content)tc);
                    }
                }
                ++i;
            }
        }
        return ret;
    }

    public List<Content> formatLetters(String text, String formatDefinition, String formatOptions, IResourceManager resourceManager) {
        char[] chars = text.toCharArray();
        ArrayList<Content> ret = new ArrayList<Content>();
        int i = 0;
        while (i < chars.length) {
            String[] replacement = characterReplacements.get(Character.valueOf(chars[i]));
            if (Character.isLetterOrDigit(chars[i]) || replacement != null) {
                String fileName;
                String altText = fileName = new String(chars, i, 1).toUpperCase();
                String prefixPath = "/Letters/";
                if (Character.isDigit(chars[i])) {
                    prefixPath = "/Digits/";
                    if (formatDefinition.equals("Preserve Case")) {
                        ret.add(this.getAudioContent(resourceManager, "/Letters/", "number", "Number "));
                    }
                } else if (Character.isLetter(chars[i])) {
                    if (formatDefinition.equals("Preserve Case")) {
                        if (Character.isUpperCase(chars[i])) {
                            ret.add(this.getAudioContent(resourceManager, "/Letters/", "uppercase", "Capital "));
                        } else if (Character.isLowerCase(chars[i])) {
                            ret.add(this.getAudioContent(resourceManager, "/Letters/", "lowercase", "Lower Case "));
                        }
                    }
                } else if (replacement != null) {
                    fileName = replacement[0];
                    altText = replacement[1];
                }
                ret.add(this.getAudioContent(resourceManager, prefixPath, fileName, altText));
            }
            ++i;
        }
        return ret;
    }

    public List<Content> formatMoney(BigDecimal money, Currency currency, String formatDefinition, String formatOptions, IResourceManager resourceManager) {
        ArrayList<Content> ret = new ArrayList<Content>();
        money = money.setScale(2, 1);
        if (USD_CURRENCY.equals(currency)) {
            int cents;
            if (money.compareTo(ZERO) < 0) {
                ret.add(this.getAudioContent(resourceManager, "/Common/", "negative", "negative"));
                money = money.multiply(NEGATIVE_ONE);
            }
            List<Content> dollarList = this.formatNumber(money.intValue(), "Default", "", resourceManager);
            ret.addAll(dollarList);
            if (money.intValue() == 1 || formatDefinition.equals("Force Singular")) {
                ret.add(this.getAudioContent(resourceManager, "/Common/", "dollar", "dollar"));
            } else {
                ret.add(this.getAudioContent(resourceManager, "/Common/", "dollars", "dollars"));
            }
            String str = money.toString();
            if (str.indexOf(46) >= 0 && (cents = Integer.parseInt(str.substring(str.indexOf(46) + 1))) > 0) {
                ret.add(this.getAudioContent(resourceManager, "/Common/", "and", "and"));
                List<Content> centsList = this.formatNumber(cents, "Default", "", resourceManager);
                ret.addAll(centsList);
                if (cents == 1 || formatDefinition.equals("Force Singular")) {
                    ret.add(this.getAudioContent(resourceManager, "/Common/", "cent", "cent"));
                } else {
                    ret.add(this.getAudioContent(resourceManager, "/Common/", "cents", "cents"));
                }
            }
        }
        return ret;
    }

    public List<Content> formatNumber(int number, String formatDefinition, String formatOptions, IResourceManager resourceManager) {
        int thousands;
        int millions;
        int billions;
        ArrayList<Content> ret = new ArrayList<Content>();
        if (number == 0) {
            ret.add(this.getAudioContent(resourceManager, "/Digits/", "0", "0"));
            return ret;
        }
        if (number < 0) {
            ret.add(this.getAudioContent(resourceManager, "/Common/", "negative", "negative"));
            number *= -1;
        }
        if ((billions = number / 1000000000) > 0) {
            this.translateNumberInHundreds(resourceManager, billions, ret);
            ret.add(this.getAudioContent(resourceManager, "/Common/", "billion", "billion"));
            number -= billions * 1000000000;
        }
        if ((millions = number / 1000000) > 0) {
            this.translateNumberInHundreds(resourceManager, millions, ret);
            ret.add(this.getAudioContent(resourceManager, "/Common/", "million", "million"));
            number -= millions * 1000000;
        }
        if ((thousands = number / 1000) > 0) {
            this.translateNumberInHundreds(resourceManager, thousands, ret);
            ret.add(this.getAudioContent(resourceManager, "/Common/", "thousand", "thousand"));
            number -= thousands * 1000;
        }
        this.translateNumberInHundreds(resourceManager, number % 1000, ret);
        return ret;
    }

    private void translateNumberInHundreds(IResourceManager resourceManager, int number, List<Content> content) {
        int hundreds = number / 100;
        if (hundreds > 0) {
            content.add(this.getAudioContent(resourceManager, "/Digits/", String.valueOf(hundreds), String.valueOf(hundreds)));
            content.add(this.getAudioContent(resourceManager, "/Common/", "hundred", "hundred"));
            number -= hundreds * 100;
        }
        if (number > 19) {
            content.add(this.getAudioContent(resourceManager, "/Digits/", String.valueOf(number - number % 10), String.valueOf(number - number % 10)));
            number %= 10;
        }
        if (number > 0) {
            content.add(this.getAudioContent(resourceManager, "/Digits/", String.valueOf(number), String.valueOf(number)));
        }
    }

    public List<Content> formatOrdinal(int ordinal, String formatDefinition, String formatOptions, IResourceManager resourceManager) {
        int hundreds;
        int thousands;
        int millions;
        int billions;
        ArrayList<Content> ret = new ArrayList<Content>();
        if (ordinal == 0) {
            ret.add(this.getAudioContent(resourceManager, "/Ordinals/", "0th", "zeroth"));
            return ret;
        }
        if (ordinal < 0) {
            ret.add(this.getAudioContent(resourceManager, "/Common/", "negative", "negative"));
            ordinal *= -1;
        }
        if ((billions = ordinal / 1000000000) > 0) {
            this.translateNumberInHundreds(resourceManager, billions, ret);
            if ((ordinal -= billions * 1000000000) == 0) {
                ret.add(this.getAudioContent(resourceManager, "/Common/", "billionth", "billionth"));
            } else {
                ret.add(this.getAudioContent(resourceManager, "/Common/", "billion", "billion"));
            }
        }
        if ((millions = ordinal / 1000000) > 0) {
            this.translateNumberInHundreds(resourceManager, millions, ret);
            if ((ordinal -= millions * 1000000) == 0) {
                ret.add(this.getAudioContent(resourceManager, "/Common/", "millionth", "millionth"));
            } else {
                ret.add(this.getAudioContent(resourceManager, "/Common/", "million", "million"));
            }
        }
        if ((thousands = ordinal / 1000) > 0) {
            this.translateNumberInHundreds(resourceManager, thousands, ret);
            if ((ordinal -= thousands * 1000) == 0) {
                ret.add(this.getAudioContent(resourceManager, "/Common/", "thousandth", "thousandth"));
            } else {
                ret.add(this.getAudioContent(resourceManager, "/Common/", "thousand", "thousand"));
            }
        }
        if ((hundreds = ordinal / 100) > 0) {
            this.translateNumberInHundreds(resourceManager, hundreds, ret);
            if ((ordinal -= hundreds * 100) == 0) {
                ret.add(this.getAudioContent(resourceManager, "/Common/", "hundredth", "hundredth"));
            } else {
                ret.add(this.getAudioContent(resourceManager, "/Common/", "hundred", "hundred"));
            }
        }
        if (ordinal % 10 == 0) {
            ret.add(this.getAudioContent(resourceManager, "/Ordinals/", String.valueOf(String.valueOf(ordinal)) + "th", String.valueOf(String.valueOf(ordinal)) + "th"));
        } else {
            int tens = ordinal / 10;
            if (tens > 1) {
                this.translateNumberInHundreds(resourceManager, tens * 10, ret);
                ordinal -= tens * 10;
            }
            switch (ordinal) {
                case 1: {
                    ret.add(this.getAudioContent(resourceManager, "/Ordinals/", "1st", "1st"));
                    break;
                }
                case 2: {
                    ret.add(this.getAudioContent(resourceManager, "/Ordinals/", "2nd", "2nd"));
                    break;
                }
                case 3: {
                    ret.add(this.getAudioContent(resourceManager, "/Ordinals/", "3rd", "3rd"));
                    break;
                }
                default: {
                    ret.add(this.getAudioContent(resourceManager, "/Ordinals/", String.valueOf(String.valueOf(ordinal)) + "th", String.valueOf(String.valueOf(ordinal)) + "th"));
                }
            }
        }
        return ret;
    }

    private List<Content> formatYear(String year, IResourceManager resourceManager) {
        ArrayList<Content> ret = new ArrayList<Content>();
        if (year.length() != 4 && year.length() != 3) {
            TextContent tc = new TextContent();
            tc.setStaticText(year);
            ret.add((Content)tc);
        } else {
            int tens;
            int century;
            if (year.length() == 3) {
                year = "0" + year;
            }
            try {
                century = Integer.parseInt(year.substring(0, 2));
                tens = Integer.parseInt(year.substring(2));
            }
            catch (Exception e) {
                TextContent tc = new TextContent();
                tc.setStaticText(year);
                ret.add((Content)tc);
                return ret;
            }
            if (century == 0) {
                ret.addAll(this.formatNumber(tens, "default", "", resourceManager));
            } else if (century % 10 == 0) {
                ret.addAll(this.formatNumber(century * 100, "default", "", resourceManager));
                if (tens > 0) {
                    ret.addAll(this.formatNumber(tens, "default", "", resourceManager));
                }
            } else if (century < 13) {
                ret.addAll(this.formatNumber(century, "default", "", resourceManager));
                ret.add(this.getAudioContent(resourceManager, "/Common/", "hundred", "hundred"));
                if (tens > 0) {
                    if (tens < 10) {
                        ret.addAll(this.formatNumber(tens, "default", "", resourceManager));
                    } else {
                        ret.addAll(this.formatNumber(tens, "default", "", resourceManager));
                    }
                }
            } else {
                ret.addAll(this.formatNumber(century, "default", "", resourceManager));
                if (tens == 0) {
                    ret.add(this.getAudioContent(resourceManager, "/Common/", "hundred", "hundred"));
                } else if (tens < 10) {
                    ret.add(this.getAudioContent(resourceManager, "/Common/", "oh", "oh"));
                    ret.addAll(this.formatNumber(tens, "default", "", resourceManager));
                } else {
                    ret.addAll(this.formatNumber(tens, "default", "", resourceManager));
                }
            }
        }
        return ret;
    }

    public String getLanguageCode() {
        return "en-US";
    }

    public String getLanguageName() {
        return "English";
    }

    @Override
    public List<String> getDefaultFormats(FormattableContent formattable) {
        ArrayList<String> ret = new ArrayList<String>();
        if (formattable instanceof DateContent) {
            ret.add("Short Date");
            ret.add("Long Date");
            ret.add("Short Time");
            ret.add("Long Time");
            ret.add("Short Date Time");
            ret.add("Long Date Time");
            ret.add("Day of Week");
            ret.add("Hour of Day");
        } else if (formattable instanceof MoneyContent) {
            ret.add("Force Singular");
        } else if (formattable instanceof DigitsContent) {
            ret.add("DTMF");
        } else if (formattable instanceof LettersContent) {
            ret.add("Preserve Case");
        }
        return ret;
    }
}

