/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.voice.services;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeValue {
    public static final int MILLIS = 1;
    public static final int SECONDS = 2;
    public static final int MINUTES = 4;
    public static final int HOURS = 8;
    public static final int DAYS = 16;
    private long millis;
    private Pattern decimalPattern = Pattern.compile("\\d*(\\.\\d+)?");

    public TimeValue(String value) {
        Pattern timePattern = Pattern.compile("(\\d*(?:\\.\\d+)?[a-zA-Z]+)");
        Matcher matcher = timePattern.matcher(value);
        if (!matcher.find()) {
            Pattern nakedNumberPattern = Pattern.compile("(\\d*(?:\\.\\d+))?");
            Matcher numberMatcher = nakedNumberPattern.matcher(value);
            if (numberMatcher.find()) {
                this.addGroup(String.valueOf(value) + "s");
                return;
            }
            throw new IllegalArgumentException("Invalid time value: " + value);
        }
        this.addGroup(matcher.group());
        while (matcher.find()) {
            this.addGroup(matcher.group());
        }
    }

    public TimeValue(long millis) {
        this.millis = millis;
    }

    private void addGroup(String group) {
        if (group.endsWith("ms")) {
            this.millis = (long)((double)this.millis + Double.parseDouble(group.substring(0, group.length() - 2)));
        } else if (group.endsWith("s")) {
            this.millis = (long)((double)this.millis + Double.parseDouble(group.substring(0, group.length() - 1)) * 1000.0);
        } else if (group.endsWith("m")) {
            this.millis = (long)((double)this.millis + Double.parseDouble(group.substring(0, group.length() - 1)) * 60000.0);
        } else if (group.endsWith("h")) {
            this.millis = (long)((double)this.millis + Double.parseDouble(group.substring(0, group.length() - 1)) * 3600000.0);
        } else if (group.endsWith("d")) {
            this.millis = (long)((double)this.millis + Double.parseDouble(group.substring(0, group.length() - 1)) * 8.64E7);
        }
    }

    public String toTimeString(int groups) {
        Matcher decimalMatcher;
        long local = this.millis;
        if (local == 0L) {
            if ((groups & 0x10) == 16) {
                return "0d";
            }
            if ((groups & 8) == 8) {
                return "0h";
            }
            if ((groups & 4) == 4) {
                return "0m";
            }
            if ((groups & 2) == 2) {
                return "0s";
            }
            if ((groups & 1) == 1) {
                return "0ms";
            }
        }
        StringBuilder buf = new StringBuilder();
        if ((groups & 0x10) == 16) {
            double partialDays;
            double days = (double)local / 8.64E7;
            long wholeDays = (long)Math.floor(days);
            if (wholeDays > 0L) {
                buf.append(wholeDays);
                local -= wholeDays * 86400000L;
            }
            if (local > 0L && (groups & 0xF) == 0 && (decimalMatcher = this.decimalPattern.matcher(Double.toString(partialDays = (double)local / 8.64E7))).find()) {
                buf.append(decimalMatcher.group());
            }
            buf.append('d');
        }
        if ((groups & 8) == 8) {
            double partialHours;
            double hours = (double)local / 3600000.0;
            long wholeHours = (long)Math.floor(hours);
            if (wholeHours > 0L) {
                buf.append(wholeHours);
                local -= wholeHours * 3600000L;
            }
            if (local > 0L && (groups & 7) == 0 && (decimalMatcher = this.decimalPattern.matcher(Double.toString(partialHours = (double)local / 3600000.0))).find()) {
                buf.append(decimalMatcher.group());
            }
            buf.append('h');
        }
        if ((groups & 4) == 4) {
            double partialMinutes;
            double minutes = (double)local / 60000.0;
            long wholeMinutes = (long)Math.floor(minutes);
            if (wholeMinutes > 0L) {
                buf.append(wholeMinutes);
                local -= wholeMinutes * 60000L;
            }
            if (local > 0L && (groups & 3) == 0 && (decimalMatcher = this.decimalPattern.matcher(Double.toString(partialMinutes = (double)local / 60000.0))).find()) {
                buf.append(decimalMatcher.group());
            }
            buf.append('m');
        }
        if ((groups & 2) == 2) {
            double partialSeconds;
            double seconds = (double)local / 1000.0;
            long wholeSeconds = (long)Math.floor(seconds);
            if (wholeSeconds > 0L) {
                buf.append(wholeSeconds);
                local -= wholeSeconds * 1000L;
            }
            if (local > 0L && (groups & 1) == 0 && (decimalMatcher = this.decimalPattern.matcher(Double.toString(partialSeconds = (double)local / 1000.0))).find()) {
                buf.append(decimalMatcher.group());
            }
            buf.append('s');
        }
        if ((groups & 1) == 1 && local > 0L) {
            buf.append(local);
            buf.append("ms");
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof String) {
            try {
                obj = new TimeValue((String)obj);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (obj instanceof TimeValue) {
            return this.millis == ((TimeValue)obj).millis;
        }
        return false;
    }

    public int compareTo(Object obj) {
        if (super.equals(obj)) {
            return 0;
        }
        if (obj instanceof String) {
            try {
                obj = new TimeValue((String)obj);
            }
            catch (Exception e) {
                throw new ClassCastException("Could not compare to " + obj.getClass().getName());
            }
        }
        if (obj instanceof TimeValue) {
            long dif = this.millis - ((TimeValue)obj).millis;
            if (dif < 0L) {
                return -1;
            }
            if (dif > 0L) {
                return 1;
            }
            return 0;
        }
        throw new ClassCastException("Could not compare to " + obj.getClass().getName());
    }

    public static void main(String[] args) {
        TimeValue t = new TimeValue(3L);
        System.out.println(t.toTimeString(2));
        System.out.println(t.toTimeString(1));
        t = new TimeValue("0");
        System.out.println(t.toTimeString(2));
        System.out.println(t.toTimeString(1));
        t = new TimeValue("3.0");
        System.out.println(t.toTimeString(2));
        System.out.println(t.toTimeString(1));
        t = new TimeValue("3s");
        System.out.println(t.toTimeString(2));
        System.out.println(t.toTimeString(1));
        t = new TimeValue("3ms");
        System.out.println(t.toTimeString(2));
        System.out.println(t.toTimeString(1));
        t = new TimeValue("3m");
        System.out.println(t.toTimeString(2));
        System.out.println(t.toTimeString(1));
        t = new TimeValue("");
        System.out.println(t.toTimeString(2));
        System.out.println(t.toTimeString(1));
        TimeValue min = new TimeValue(0L);
        TimeValue max = new TimeValue(Long.MAX_VALUE);
        System.out.println(min.compareTo(t));
        System.out.println(t.compareTo(max));
    }
}

