/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.voice.services;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.vtp.framework.common.IBrand;
import org.eclipse.vtp.framework.common.IBrandSelection;
import org.eclipse.vtp.framework.core.IExecutionContext;
import org.eclipse.vtp.framework.interactions.core.IInteractionTypeSelection;
import org.eclipse.vtp.framework.interactions.core.ILanguageSelection;
import org.eclipse.vtp.framework.interactions.core.commands.BridgeMessageCommand;
import org.eclipse.vtp.framework.interactions.core.commands.DataRequestCommand;
import org.eclipse.vtp.framework.interactions.core.commands.EndMessageCommand;
import org.eclipse.vtp.framework.interactions.core.commands.ExternalReferenceCommand;
import org.eclipse.vtp.framework.interactions.core.commands.FinalCommand;
import org.eclipse.vtp.framework.interactions.core.commands.InitialCommand;
import org.eclipse.vtp.framework.interactions.core.commands.InputRequestCommand;
import org.eclipse.vtp.framework.interactions.core.commands.OutputMessageCommand;
import org.eclipse.vtp.framework.interactions.core.commands.SelectionRequestCommand;
import org.eclipse.vtp.framework.interactions.core.commands.TransferMessageCommand;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProviderRegistry;
import org.eclipse.vtp.framework.interactions.core.platforms.IDocument;
import org.eclipse.vtp.framework.interactions.core.platforms.ILink;
import org.eclipse.vtp.framework.interactions.core.platforms.ILinkFactory;
import org.eclipse.vtp.framework.interactions.core.services.ExtendedActionEventManager;
import org.eclipse.vtp.framework.interactions.core.support.AbstractPlatform;
import org.eclipse.vtp.framework.interactions.voice.services.TimeValue;
import org.eclipse.vtp.framework.interactions.voice.vxml.Assignment;
import org.eclipse.vtp.framework.interactions.voice.vxml.AudioOutput;
import org.eclipse.vtp.framework.interactions.voice.vxml.Block;
import org.eclipse.vtp.framework.interactions.voice.vxml.Catch;
import org.eclipse.vtp.framework.interactions.voice.vxml.Choice;
import org.eclipse.vtp.framework.interactions.voice.vxml.Dialog;
import org.eclipse.vtp.framework.interactions.voice.vxml.Else;
import org.eclipse.vtp.framework.interactions.voice.vxml.ElseIf;
import org.eclipse.vtp.framework.interactions.voice.vxml.Exit;
import org.eclipse.vtp.framework.interactions.voice.vxml.ExternalGrammar;
import org.eclipse.vtp.framework.interactions.voice.vxml.Field;
import org.eclipse.vtp.framework.interactions.voice.vxml.Filled;
import org.eclipse.vtp.framework.interactions.voice.vxml.Form;
import org.eclipse.vtp.framework.interactions.voice.vxml.Goto;
import org.eclipse.vtp.framework.interactions.voice.vxml.If;
import org.eclipse.vtp.framework.interactions.voice.vxml.Menu;
import org.eclipse.vtp.framework.interactions.voice.vxml.NoInput;
import org.eclipse.vtp.framework.interactions.voice.vxml.NoMatch;
import org.eclipse.vtp.framework.interactions.voice.vxml.OutputSet;
import org.eclipse.vtp.framework.interactions.voice.vxml.Parameter;
import org.eclipse.vtp.framework.interactions.voice.vxml.Prompt;
import org.eclipse.vtp.framework.interactions.voice.vxml.RawInlineGrammar;
import org.eclipse.vtp.framework.interactions.voice.vxml.Recording;
import org.eclipse.vtp.framework.interactions.voice.vxml.Return;
import org.eclipse.vtp.framework.interactions.voice.vxml.SSMLMarkOutput;
import org.eclipse.vtp.framework.interactions.voice.vxml.Script;
import org.eclipse.vtp.framework.interactions.voice.vxml.Subdialog;
import org.eclipse.vtp.framework.interactions.voice.vxml.Submit;
import org.eclipse.vtp.framework.interactions.voice.vxml.TextOutput;
import org.eclipse.vtp.framework.interactions.voice.vxml.Transfer;
import org.eclipse.vtp.framework.interactions.voice.vxml.VXMLConstants;
import org.eclipse.vtp.framework.interactions.voice.vxml.VXMLDocument;
import org.eclipse.vtp.framework.interactions.voice.vxml.Variable;

public class VoicePlatform
extends AbstractPlatform
implements VXMLConstants {
    protected static final BigDecimal ONE_HUNDRED = new BigDecimal("100");
    protected static final BigDecimal TEN = new BigDecimal("10");
    protected static final String VXML_BUILTIN_PREFIX = "VXML:Builtin:";
    private IMediaProvider mediaProvider;
    private final IExecutionContext context;

    public VoicePlatform(IExecutionContext context) {
        this.context = context;
    }

    public Locale getCurrentLocale() {
        String variant;
        String country;
        if (this.mediaProvider == null) {
            IInteractionTypeSelection interactionTypeSelection = (IInteractionTypeSelection)this.context.lookup(IInteractionTypeSelection.class.getName());
            System.out.println(interactionTypeSelection);
            System.out.println(interactionTypeSelection.getSelectedInteractionType());
            String interactionTypeID = interactionTypeSelection.getSelectedInteractionType().getId();
            ILanguageSelection languageSelection = (ILanguageSelection)this.context.lookup(ILanguageSelection.class.getName());
            String languageID = languageSelection.getSelectedLanguage();
            IBrandSelection brandSelection = (IBrandSelection)this.context.lookup(IBrandSelection.class.getName());
            IBrand brand = brandSelection.getSelectedBrand();
            IMediaProviderRegistry mediaProviderRegistry = (IMediaProviderRegistry)this.context.lookup(IMediaProviderRegistry.class.getName());
            String mediaProviderId = mediaProviderRegistry.lookupMediaProviderID(brand.getId(), interactionTypeID, languageID);
            this.mediaProvider = mediaProviderRegistry.getMediaProvider(mediaProviderId);
        }
        String languageCode = this.mediaProvider.getFormatter().getLanguageCode();
        Pattern p = Pattern.compile("^([a-zA-Z]+)([-_]([a-zA-Z]+)([-_](.+))?)?");
        Matcher matcher = p.matcher(languageCode);
        if (!matcher.find()) {
            return Locale.getDefault();
        }
        String language = matcher.group(1);
        if (language == null) {
            language = "";
        }
        if ((country = matcher.group(3)) == null) {
            country = "";
        }
        if ((variant = matcher.group(5)) == null) {
            variant = "";
        }
        return new Locale(language, country, variant);
    }

    public TimeValue getMinimumTimeValue(String property) {
        return new TimeValue(0L);
    }

    public TimeValue getMaximumTimeValue(String property) {
        return new TimeValue(Long.MAX_VALUE);
    }

    public TimeValue resolveTimeValue(String property, String value) {
        if (value == null) {
            return null;
        }
        TimeValue setting = new TimeValue(value);
        TimeValue minimum = this.getMinimumTimeValue(property);
        TimeValue maximum = this.getMaximumTimeValue(property);
        if (minimum.compareTo(setting) > 0) {
            return minimum;
        }
        if (setting.compareTo(maximum) > 0) {
            return maximum;
        }
        return setting;
    }

    public AudioOutput generateAudioChain(ILinkFactory links, String path) {
        AudioOutput output;
        block12: {
            output = new AudioOutput(links.createResourceLink(path).toString());
            if (path.startsWith("http://")) {
                return output;
            }
            try {
                InitialContext jndiContext = new InitialContext();
                String mediaServerCountString = (String)jndiContext.lookup("java:comp/env/media-server-count");
                if (mediaServerCountString == null) break block12;
                int count = 0;
                try {
                    count = Integer.parseInt(mediaServerCountString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                AudioOutput current = output;
                int i = 1;
                while (i < count + 1) {
                    try {
                        String serverPrefix = (String)jndiContext.lookup("java:comp/env/media-server-" + i);
                        if (serverPrefix != null) {
                            String fullPath = String.valueOf(serverPrefix) + path;
                            if (!serverPrefix.endsWith("/") && !path.startsWith("/")) {
                                fullPath = String.valueOf(serverPrefix) + "/" + path;
                            }
                            if (i == 1) {
                                current.setAudioFileURI(fullPath);
                            } else {
                                AudioOutput ao = new AudioOutput(fullPath);
                                current.addOutput(ao);
                                current = ao;
                            }
                        }
                    }
                    catch (NamingException namingException) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return output;
    }

    protected VXMLDocument createVXMLDocument(ILinkFactory links, Dialog dialog) {
        VXMLDocument document = new VXMLDocument();
        document.addDialog(dialog);
        Catch hangupCatch = new Catch("connection.disconnect.hangup");
        hangupCatch.addAction(new Goto(links.createAbortLink().toString()));
        document.addEventHandler(hangupCatch);
        return document;
    }

    protected IDocument renderOutputMessage(ILinkFactory links, OutputMessageCommand outputMessageCommand) {
        String bargeIn = outputMessageCommand.getPropertyValue("barge-in");
        bargeIn = Boolean.TRUE.toString().equalsIgnoreCase(bargeIn) ? Boolean.TRUE.toString() : (Boolean.FALSE.toString().equalsIgnoreCase(bargeIn) ? Boolean.FALSE.toString() : null);
        Form form = new Form("OutputMessageForm");
        if (bargeIn != null) {
            form.setProperty("bargein", bargeIn);
        }
        Block block = new Block("OutputMessageBlock");
        OutputSet outputs = new OutputSet();
        int i = 0;
        while (i < outputMessageCommand.getOutputCount()) {
            String outputValue = outputMessageCommand.getOutputValue(i);
            switch (outputMessageCommand.getOutputType(i)) {
                case 1: {
                    outputs.addOutput(this.generateAudioChain(links, outputValue));
                    break;
                }
                case 2: {
                    if (outputValue.startsWith("@@mark ")) {
                        outputs.addOutput(new SSMLMarkOutput(outputValue.substring(7)));
                        break;
                    }
                    outputs.addOutput(new TextOutput(outputValue));
                }
            }
            ++i;
        }
        Prompt prompt = new Prompt(outputs);
        if (bargeIn != null) {
            prompt.setBargeInEnabled(Boolean.valueOf(bargeIn));
        }
        prompt.setLanguage(this.getCurrentLocale());
        block.addAction(prompt);
        ILink nextLink = links.createNextLink();
        String[] parameterNames = outputMessageCommand.getParameterNames();
        int i2 = 0;
        while (i2 < parameterNames.length) {
            nextLink.setParameters(parameterNames[i2], outputMessageCommand.getParameterValues(parameterNames[i2]));
            ++i2;
        }
        nextLink.setParameter(outputMessageCommand.getResultName(), outputMessageCommand.getFilledResultValue());
        block.addAction(new Goto(nextLink.toString()));
        ILink hangupLink = links.createNextLink();
        int i3 = 0;
        while (i3 < parameterNames.length) {
            hangupLink.setParameters(parameterNames[i3], outputMessageCommand.getParameterValues(parameterNames[i3]));
            ++i3;
        }
        hangupLink.setParameter(outputMessageCommand.getResultName(), outputMessageCommand.getHangupResultValue());
        Catch disconnectCatch = new Catch("connection.disconnect.hangup");
        disconnectCatch.addAction(new Goto(hangupLink.toString()));
        form.addEventHandler(disconnectCatch);
        form.addFormElement(block);
        List events = ExtendedActionEventManager.getDefault().getExtendedEvents();
        for (String event : events) {
            ILink eventLink = links.createNextLink();
            int i4 = 0;
            while (i4 < parameterNames.length) {
                eventLink.setParameters(parameterNames[i4], outputMessageCommand.getParameterValues(parameterNames[i4]));
                ++i4;
            }
            eventLink.setParameter(outputMessageCommand.getResultName(), event);
            Catch eventCatch = new Catch(event);
            eventCatch.addAction(new Goto(eventLink.toString()));
            form.addEventHandler(eventCatch);
        }
        return this.createVXMLDocument(links, form);
    }

    protected IDocument renderInitialDocument(ILinkFactory links, InitialCommand initialCommand) {
        Form form = new Form("InitialForm");
        LinkedHashMap<String, String> varMap = new LinkedHashMap<String, String>();
        this.generateInitialVariableRequests(varMap);
        for (String key : varMap.keySet()) {
            form.addVariable(new Variable(key, "''"));
        }
        String[] variables = initialCommand.getVariableNames();
        int i = 0;
        while (i < variables.length) {
            String value = initialCommand.getVariableValue(variables[i]);
            if (value == null) {
                value = "";
            }
            form.addVariable(new Variable(variables[i], "'" + value + "'"));
            ++i;
        }
        Block block = new Block("InitialBlock");
        for (String key : varMap.keySet()) {
            block.addAction(new Assignment(key, (String)varMap.get(key)));
        }
        ILink nextLink = links.createNextLink();
        String[] parameterNames = initialCommand.getParameterNames();
        int i2 = 0;
        while (i2 < parameterNames.length) {
            nextLink.setParameters(parameterNames[i2], initialCommand.getParameterValues(parameterNames[i2]));
            ++i2;
        }
        nextLink.setParameter(initialCommand.getResultName(), initialCommand.getResultValue());
        String[] fields = new String[varMap.size() + variables.length];
        int j = 0;
        Iterator iterator = varMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            fields[j] = key = (String)iterator.next();
            ++j;
        }
        System.arraycopy(variables, 0, fields, varMap.size(), variables.length);
        Submit submit = new Submit(nextLink.toString(), fields);
        submit.setMethod("post");
        block.addAction(submit);
        form.addFormElement(block);
        ILink hangupLink = links.createNextLink();
        int i3 = 0;
        while (i3 < parameterNames.length) {
            hangupLink.setParameters(parameterNames[i3], initialCommand.getParameterValues(parameterNames[i3]));
            ++i3;
        }
        hangupLink.setParameter(initialCommand.getResultName(), initialCommand.getHangupResultValue());
        Catch disconnectCatch = new Catch("connection.disconnect.hangup");
        disconnectCatch.addAction(new Goto(hangupLink.toString()));
        form.addEventHandler(disconnectCatch);
        VXMLDocument document = this.createVXMLDocument(links, form);
        document.setProperty("documentmaxage", "0");
        document.setProperty("documentmaxstale", "0");
        List events = ExtendedActionEventManager.getDefault().getExtendedEvents();
        for (String event : events) {
            ILink eventLink = links.createNextLink();
            int i4 = 0;
            while (i4 < parameterNames.length) {
                eventLink.setParameters(parameterNames[i4], initialCommand.getParameterValues(parameterNames[i4]));
                ++i4;
            }
            eventLink.setParameter(initialCommand.getResultName(), event);
            Catch eventCatch = new Catch(event);
            eventCatch.addAction(new Goto(eventLink.toString()));
            form.addEventHandler(eventCatch);
        }
        return document;
    }

    public void generateInitialVariableRequests(Map<String, String> variables) {
        super.generateInitialVariableRequests(variables);
        variables.put("PLATFORM_ANI", "session.connection.remote.uri");
        variables.put("PLATFORM_DNIS", "session.connection.local.uri");
    }

    public List<String> getPlatformVariableNames() {
        List vars = super.getPlatformVariableNames();
        return vars;
    }

    protected IDocument renderInputRequest(ILinkFactory links, InputRequestCommand inputRequestCommand) {
        String customData;
        Form form = new Form("InputRequestForm");
        String bargeIn = inputRequestCommand.getPropertyValue("barge-in");
        bargeIn = Boolean.TRUE.toString().equalsIgnoreCase(bargeIn) ? Boolean.TRUE.toString() : (Boolean.FALSE.toString().equalsIgnoreCase(bargeIn) ? Boolean.FALSE.toString() : null);
        TimeValue timeout = this.resolveTimeValue("initial-timeout", inputRequestCommand.getPropertyValue("initial-timeout"));
        String inputMode = inputRequestCommand.getPropertyValue("input-mode");
        if (inputMode == null || inputMode.length() == 0) {
            inputMode = "dtmf only";
        }
        String confidenceLevel = inputRequestCommand.getPropertyValue("confidence-level");
        String sensitivity = inputRequestCommand.getPropertyValue("sensitivity-level");
        String speedVsAccuracy = inputRequestCommand.getPropertyValue("speed-vs-accuracy");
        TimeValue speechCompletionTimeout = this.resolveTimeValue("speech-complete-timeout", inputRequestCommand.getPropertyValue("speech-complete-timeout"));
        TimeValue speechIncompleteTimeout = this.resolveTimeValue("speech-incomplete-timeout", inputRequestCommand.getPropertyValue("speech-incomplete-timeout"));
        TimeValue maxSpeechLength = this.resolveTimeValue("max-speech-timeout", inputRequestCommand.getPropertyValue("max-speech-timeout"));
        String maxNBest = inputRequestCommand.getPropertyValue("max-n-best");
        TimeValue interDigitTimeout = this.resolveTimeValue("interdigit-timeout", inputRequestCommand.getPropertyValue("interdigit-timeout"));
        TimeValue terminationTimeout = this.resolveTimeValue("termination-timeout", inputRequestCommand.getPropertyValue("termination-timeout"));
        String terminationCharacter = inputRequestCommand.getPropertyValue("termination-character");
        Field field = new Field(inputRequestCommand.getDataName());
        if (bargeIn != null) {
            field.setProperty("bargein", bargeIn);
        }
        if (timeout != null) {
            field.setProperty("timeout", timeout.toTimeString(2));
        }
        if ("hybrid".equalsIgnoreCase(inputMode)) {
            field.setProperty("inputmodes", "dtmf voice");
            field.setProperty("com.telera.speechenabled", Boolean.TRUE.toString());
        }
        if ("dtmf only".equalsIgnoreCase(inputMode)) {
            field.setProperty("inputmodes", "dtmf");
            field.setProperty("com.telera.speechenabled", Boolean.FALSE.toString());
        } else {
            try {
                if (confidenceLevel != null && confidenceLevel.length() > 0) {
                    field.setProperty("confidencelevel", new BigDecimal(confidenceLevel).divide(ONE_HUNDRED).toString());
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            try {
                if (sensitivity != null && sensitivity.length() > 0) {
                    field.setProperty("sensitivity", new BigDecimal(sensitivity).divide(ONE_HUNDRED).toString());
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            try {
                if (speedVsAccuracy != null && speedVsAccuracy.length() > 0) {
                    field.setProperty("speedvsaccuracy", new BigDecimal(speedVsAccuracy).divide(ONE_HUNDRED).toString());
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            if (speechCompletionTimeout != null) {
                field.setProperty("completetimeout", speechCompletionTimeout.toTimeString(2));
            }
            if (speechIncompleteTimeout != null) {
                field.setProperty("incompletetimeout", speechIncompleteTimeout.toTimeString(2));
            }
            if (maxSpeechLength != null) {
                field.setProperty("maxspeechtimeout", maxSpeechLength.toTimeString(2));
            } else {
                field.setProperty("maxspeechtimeout", "10s");
            }
            if (maxNBest != null && maxNBest.length() > 0) {
                field.setProperty("maxnbest", maxNBest);
            }
        }
        if ("voice only".equalsIgnoreCase(inputMode)) {
            field.setProperty("inputmodes", "voice");
            field.setProperty("com.telera.speechenabled", Boolean.TRUE.toString());
        } else {
            if (interDigitTimeout != null) {
                field.setProperty("interdigittimeout", interDigitTimeout.toTimeString(2));
            }
            if (terminationTimeout != null) {
                field.setProperty("termtimeout", terminationTimeout.toTimeString(2));
            }
            if (terminationCharacter != null && terminationCharacter.length() > 0 && !"none".equalsIgnoreCase(terminationCharacter)) {
                field.setProperty("termchar", terminationCharacter);
            } else {
                field.setProperty("termchar", String.valueOf('D'));
            }
        }
        OutputSet outputs = new OutputSet();
        int i = 0;
        while (i < inputRequestCommand.getOutputCount()) {
            String outputValue = inputRequestCommand.getOutputValue(i);
            switch (inputRequestCommand.getOutputType(i)) {
                case 1: {
                    outputs.addOutput(this.generateAudioChain(links, outputValue));
                    break;
                }
                case 2: {
                    if (outputValue.startsWith("@@mark ")) {
                        outputs.addOutput(new SSMLMarkOutput(outputValue.substring(7)));
                        break;
                    }
                    outputs.addOutput(new TextOutput(outputValue));
                }
            }
            ++i;
        }
        Prompt prompt = new Prompt(outputs);
        if (bargeIn != null) {
            prompt.setBargeInEnabled(Boolean.valueOf(bargeIn));
        }
        prompt.setLanguage(this.getCurrentLocale());
        field.setPrompt(prompt);
        if (inputRequestCommand.getInputValue() != null) {
            switch (inputRequestCommand.getInputType()) {
                case 1: {
                    field.addGrammar(new ExternalGrammar("dtmf", links.createResourceLink(inputRequestCommand.getInputValue()).toString()));
                    break;
                }
                case 0x7FFFFFFF: {
                    customData = inputRequestCommand.getInputValue();
                    if (customData == null || !customData.startsWith(VXML_BUILTIN_PREFIX)) break;
                    field.setType(customData.substring(VXML_BUILTIN_PREFIX.length()));
                    break;
                }
                case 2: {
                    field.addGrammar(new RawInlineGrammar(inputRequestCommand.getInputValue()));
                }
            }
        }
        if (inputRequestCommand.getInput2Value() != null) {
            switch (inputRequestCommand.getInput2Type()) {
                case 1: {
                    field.addGrammar(new ExternalGrammar("voice", links.createResourceLink(inputRequestCommand.getInput2Value()).toString()));
                    break;
                }
                case 0x7FFFFFFF: {
                    customData = inputRequestCommand.getInput2Value();
                    if (customData == null || !customData.startsWith(VXML_BUILTIN_PREFIX)) break;
                    field.setType(customData.substring(VXML_BUILTIN_PREFIX.length()));
                    break;
                }
                case 2: {
                    field.addGrammar(new RawInlineGrammar(inputRequestCommand.getInput2Value()));
                }
            }
        }
        String[] parameterNames = inputRequestCommand.getParameterNames();
        ILink filledLink = links.createNextLink();
        int i2 = 0;
        while (i2 < parameterNames.length) {
            filledLink.setParameters(parameterNames[i2], inputRequestCommand.getParameterValues(parameterNames[i2]));
            ++i2;
        }
        filledLink.setParameter(inputRequestCommand.getResultName(), inputRequestCommand.getFilledResultValue());
        Filled filled = new Filled();
        filled.addVariable(new Variable("lastresult", "'<lastresult>'"));
        If ifTag2 = new If("typeof(application.lastresult$.markname) == 'string'");
        Script markScript2 = new Script();
        markScript2.setText("\t\tlastresult = lastresult + '<mark name=\"' + application.lastresult$.markname + '\" offset=\"' + application.lastresult$.marktime + '\"/>';\r\n\t\tfor(var i = 0; i < application.lastresult$.length; i++)\r\n\t\t{\r\n\t\t\tlastresult = lastresult + '<result>';\r\n\t\t\tlastresult = lastresult + '<confidence>' + application.lastresult$[i].confidence + '</confidence>';\r\n\t\t\tlastresult = lastresult + '<utterance><![CDATA[' + application.lastresult$[i].utterance + ']]></utterance>';\r\n\t\t\tlastresult = lastresult + '<inputmode><![CDATA[' + application.lastresult$[i].inputmode + ']]></inputmode>';\r\n\t\t\tlastresult = lastresult + '<interpretation><![CDATA[' + application.lastresult$[i].interpretation + ']]></interpretation>';\r\n\t\t\tlastresult = lastresult + '</result>';\r\n\t\t}\r\n\t\tlastresult = lastresult + '</lastresult>';\r\n");
        ifTag2.addScript(markScript2);
        Else elseTag2 = new Else();
        Script noMarkScript2 = new Script();
        noMarkScript2.setText("\t\tlastresult = lastresult + '<mark name=\"NONE\" offset=\"0\"/>';\r\n\t\tfor(var i = 0; i < application.lastresult$.length; i++)\r\n\t\t{\r\n\t\t\tlastresult = lastresult + '<result>';\r\n\t\t\tlastresult = lastresult + '<confidence>' + application.lastresult$[i].confidence + '</confidence>';\r\n\t\t\tlastresult = lastresult + '<utterance><![CDATA[' + application.lastresult$[i].utterance + ']]></utterance>';\r\n\t\t\tlastresult = lastresult + '<inputmode><![CDATA[' + application.lastresult$[i].inputmode + ']]></inputmode>';\r\n\t\t\tlastresult = lastresult + '<interpretation><![CDATA[' + application.lastresult$[i].interpretation + ']]></interpretation>';\r\n\t\t\tlastresult = lastresult + '</result>';\r\n\t\t}\r\n\t\tlastresult = lastresult + '</lastresult>';\r\n");
        elseTag2.addScript(noMarkScript2);
        ifTag2.setElse(elseTag2);
        filled.addIfClause(ifTag2);
        Submit filledSubmit = new Submit(filledLink.toString(), new String[]{inputRequestCommand.getDataName(), "lastresult"});
        filledSubmit.setMethod("post");
        filled.addAction(filledSubmit);
        field.addFilledHandler(filled);
        ILink noInputLink = links.createNextLink();
        int i3 = 0;
        while (i3 < parameterNames.length) {
            noInputLink.setParameters(parameterNames[i3], inputRequestCommand.getParameterValues(parameterNames[i3]));
            ++i3;
        }
        noInputLink.setParameter(inputRequestCommand.getResultName(), inputRequestCommand.getNoInputResultValue());
        NoInput noInput = new NoInput();
        noInput.addAction(new Submit(noInputLink.toString(), new String[]{inputRequestCommand.getDataName()}));
        field.addEventHandler(noInput);
        ILink noMatchLink = links.createNextLink();
        int i4 = 0;
        while (i4 < parameterNames.length) {
            noMatchLink.setParameters(parameterNames[i4], inputRequestCommand.getParameterValues(parameterNames[i4]));
            ++i4;
        }
        noMatchLink.setParameter(inputRequestCommand.getResultName(), inputRequestCommand.getNoMatchResultValue());
        NoMatch noMatch = new NoMatch();
        noMatch.addVariable(new Variable("lastresult", "'<lastresult>'"));
        If ifTag = new If("typeof(application.lastresult$.markname) == 'string'");
        Script markScript = new Script();
        markScript.setText("\t\tlastresult = lastresult + '<mark name=\"' + application.lastresult$.markname + '\" offset=\"' + application.lastresult$.marktime + '\"/>';\r\n\t\tfor(var i = 0; i < application.lastresult$.length; i++)\r\n\t\t{\r\n\t\t\tlastresult = lastresult + '<result>';\r\n\t\t\tlastresult = lastresult + '<confidence>' + application.lastresult$[i].confidence + '</confidence>';\r\n\t\t\tlastresult = lastresult + '<utterance><![CDATA[' + application.lastresult$[i].utterance + ']]></utterance>';\r\n\t\t\tlastresult = lastresult + '<inputmode><![CDATA[' + application.lastresult$[i].inputmode + ']]></inputmode>';\r\n\t\t\tlastresult = lastresult + '<interpretation><![CDATA[' + application.lastresult$[i].interpretation + ']]></interpretation>';\r\n\t\t\tlastresult = lastresult + '</result>';\r\n\t\t}\r\n\t\tlastresult = lastresult + '</lastresult>';\r\n");
        ifTag.addScript(markScript);
        Else elseTag = new Else();
        Script noMarkScript = new Script();
        noMarkScript.setText("\t\tlastresult = lastresult + '<mark name=\"NONE\" offset=\"0\"/>';\r\n\t\tfor(var i = 0; i < application.lastresult$.length; i++)\r\n\t\t{\r\n\t\t\tlastresult = lastresult + '<result>';\r\n\t\t\tlastresult = lastresult + '<confidence>' + application.lastresult$[i].confidence + '</confidence>';\r\n\t\t\tlastresult = lastresult + '<utterance><![CDATA[' + application.lastresult$[i].utterance + ']]></utterance>';\r\n\t\t\tlastresult = lastresult + '<inputmode><![CDATA[' + application.lastresult$[i].inputmode + ']]></inputmode>';\r\n\t\t\tlastresult = lastresult + '<interpretation><![CDATA[' + application.lastresult$[i].interpretation + ']]></interpretation>';\r\n\t\t\tlastresult = lastresult + '</result>';\r\n\t\t}\r\n\t\tlastresult = lastresult + '</lastresult>';\r\n");
        elseTag.addScript(noMarkScript);
        ifTag.setElse(elseTag);
        noMatch.addIfClause(ifTag);
        Submit noMatchSubmit = new Submit(noMatchLink.toString(), new String[]{inputRequestCommand.getDataName(), "lastresult"});
        noMatchSubmit.setMethod("post");
        noMatch.addAction(noMatchSubmit);
        field.addEventHandler(noMatch);
        ILink hangupLink = links.createNextLink();
        int i5 = 0;
        while (i5 < parameterNames.length) {
            hangupLink.setParameters(parameterNames[i5], inputRequestCommand.getParameterValues(parameterNames[i5]));
            ++i5;
        }
        hangupLink.setParameter(inputRequestCommand.getResultName(), inputRequestCommand.getHangupResultValue());
        Catch disconnectCatch = new Catch("connection.disconnect.hangup");
        disconnectCatch.addAction(new Goto(hangupLink.toString()));
        field.addEventHandler(disconnectCatch);
        form.addFormElement(field);
        List events = ExtendedActionEventManager.getDefault().getExtendedEvents();
        for (String event : events) {
            ILink eventLink = links.createNextLink();
            int i6 = 0;
            while (i6 < parameterNames.length) {
                eventLink.setParameters(parameterNames[i6], inputRequestCommand.getParameterValues(parameterNames[i6]));
                ++i6;
            }
            eventLink.setParameter(inputRequestCommand.getResultName(), event);
            Catch eventCatch = new Catch(event);
            eventCatch.addAction(new Goto(eventLink.toString()));
            form.addEventHandler(eventCatch);
        }
        return this.createVXMLDocument(links, form);
    }

    protected IDocument renderSelectionRequest(ILinkFactory links, SelectionRequestCommand selectionRequestCommand) {
        String bargeIn = this.getNormalizedBoolean(selectionRequestCommand.getPropertyValue("barge-in"));
        TimeValue timeout = this.resolveTimeValue("initial-timeout", selectionRequestCommand.getPropertyValue("initial-timeout"));
        String inputMode = selectionRequestCommand.getPropertyValue("input-mode");
        if (inputMode == null || inputMode.length() == 0) {
            inputMode = "dtmf only";
        }
        String confidenceLevel = selectionRequestCommand.getPropertyValue("confidence-level");
        String sensitivity = selectionRequestCommand.getPropertyValue("sensitivity-level");
        String speedVsAccuracy = selectionRequestCommand.getPropertyValue("speed-vs-accuracy");
        TimeValue speechCompletionTimeout = this.resolveTimeValue("speech-complete-timeout", selectionRequestCommand.getPropertyValue("speech-complete-timeout"));
        TimeValue speechIncompleteTimeout = this.resolveTimeValue("speech-incomplete-timeout", selectionRequestCommand.getPropertyValue("speech-incomplete-timeout"));
        TimeValue maxSpeechLength = this.resolveTimeValue("max-speech-timeout", selectionRequestCommand.getPropertyValue("max-speech-timeout"));
        String maxNBest = selectionRequestCommand.getPropertyValue("max-n-best");
        TimeValue interDigitTimeout = this.resolveTimeValue("interdigit-timeout", selectionRequestCommand.getPropertyValue("interdigit-timeout"));
        TimeValue terminationTimeout = this.resolveTimeValue("termination-timeout", selectionRequestCommand.getPropertyValue("termination-timeout"));
        String terminationCharacter = selectionRequestCommand.getPropertyValue("termination-character");
        String grammarMode = null;
        OutputSet outputs = new OutputSet();
        int i = 0;
        while (i < selectionRequestCommand.getOutputCount()) {
            String outputValue = selectionRequestCommand.getOutputValue(i);
            switch (selectionRequestCommand.getOutputType(i)) {
                case 1: {
                    outputs.addOutput(this.generateAudioChain(links, outputValue));
                    break;
                }
                case 2: {
                    if (outputValue.startsWith("@@mark ")) {
                        outputs.addOutput(new SSMLMarkOutput(outputValue.substring(7)));
                        break;
                    }
                    outputs.addOutput(new TextOutput(outputValue));
                }
            }
            ++i;
        }
        Prompt prompt = new Prompt(outputs);
        if (bargeIn != null) {
            prompt.setBargeInEnabled(Boolean.valueOf(bargeIn));
        }
        prompt.setLanguage(this.getCurrentLocale());
        Menu menu = new Menu(selectionRequestCommand.getSelectionName(), prompt);
        if (bargeIn != null) {
            menu.setProperty("bargein", bargeIn);
        }
        if (timeout != null) {
            menu.setProperty("timeout", timeout.toTimeString(2));
        }
        if ("hybrid".equalsIgnoreCase(inputMode)) {
            menu.setProperty("inputmodes", "dtmf voice");
            menu.setProperty("com.telera.speechenabled", Boolean.TRUE.toString());
        }
        if ("dtmf only".equalsIgnoreCase(inputMode)) {
            grammarMode = "dtmf";
            menu.setProperty("inputmodes", "dtmf");
            menu.setProperty("com.telera.speechenabled", Boolean.FALSE.toString());
        } else {
            try {
                if (confidenceLevel != null && confidenceLevel.length() > 0) {
                    menu.setProperty("confidencelevel", new BigDecimal(confidenceLevel).divide(ONE_HUNDRED).toString());
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            try {
                if (sensitivity != null && sensitivity.length() > 0) {
                    menu.setProperty("sensitivity", new BigDecimal(sensitivity).divide(ONE_HUNDRED).toString());
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            try {
                if (speedVsAccuracy != null && speedVsAccuracy.length() > 0) {
                    menu.setProperty("speedvsaccuracy", new BigDecimal(speedVsAccuracy).divide(ONE_HUNDRED).toString());
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            if (speechCompletionTimeout != null) {
                menu.setProperty("completetimeout", speechCompletionTimeout.toTimeString(2));
            }
            if (speechIncompleteTimeout != null) {
                menu.setProperty("incompletetimeout", speechIncompleteTimeout.toTimeString(2));
            }
            if (maxSpeechLength != null) {
                menu.setProperty("maxspeechtimeout", maxSpeechLength.toTimeString(2));
            } else {
                menu.setProperty("maxspeechtimeout", "10s");
            }
            if (maxNBest != null && maxNBest.length() > 0) {
                menu.setProperty("maxnbest", maxNBest);
            }
        }
        if ("voice only".equalsIgnoreCase(inputMode)) {
            grammarMode = "voice";
            menu.setProperty("inputmodes", "voice");
            menu.setProperty("com.telera.speechenabled", Boolean.TRUE.toString());
        } else {
            if (interDigitTimeout != null) {
                menu.setProperty("interdigittimeout", interDigitTimeout.toTimeString(2));
            }
            if (terminationTimeout != null) {
                menu.setProperty("termtimeout", terminationTimeout.toTimeString(2));
            }
            if (terminationCharacter != null && terminationCharacter.length() > 0 && !"none".equalsIgnoreCase(terminationCharacter)) {
                menu.setProperty("termchar", terminationCharacter);
            } else {
                menu.setProperty("termchar", "");
            }
        }
        ILink nextLink = links.createNextLink();
        String[] parameterNames = selectionRequestCommand.getParameterNames();
        int i2 = 0;
        while (i2 < parameterNames.length) {
            nextLink.setParameters(parameterNames[i2], selectionRequestCommand.getParameterValues(parameterNames[i2]));
            ++i2;
        }
        nextLink.setParameter(selectionRequestCommand.getResultName(), selectionRequestCommand.getFilledResultValue());
        i2 = 0;
        while (i2 < selectionRequestCommand.getOptionCount()) {
            String silent = selectionRequestCommand.getOptionProperty(i2, "silent");
            silent = Boolean.TRUE.toString().equalsIgnoreCase(silent) ? Boolean.TRUE.toString() : (Boolean.FALSE.toString().equalsIgnoreCase(silent) ? Boolean.FALSE.toString() : null);
            String dtmf = selectionRequestCommand.getOptionProperty(i2, "dtmf");
            if (!Boolean.TRUE.toString().equals(silent)) {
                int j = 0;
                while (j < selectionRequestCommand.getOptionOutputCount(i2)) {
                    String optionOutputValue = selectionRequestCommand.getOptionOutputValue(i2, j);
                    switch (selectionRequestCommand.getOptionOutputType(i2, j)) {
                        case 1: {
                            outputs.addOutput(this.generateAudioChain(links, optionOutputValue));
                            break;
                        }
                        case 2: {
                            if (optionOutputValue.startsWith("@@mark ")) {
                                outputs.addOutput(new SSMLMarkOutput(optionOutputValue.substring(7)));
                                break;
                            }
                            outputs.addOutput(new TextOutput(optionOutputValue));
                        }
                    }
                    ++j;
                }
            }
            nextLink.setParameter(selectionRequestCommand.getSelectionName(), selectionRequestCommand.getOption(i2));
            Choice choice = new Choice(nextLink.toString());
            if (!"dtmf".equals(grammarMode)) {
                switch (selectionRequestCommand.getOptionInputType(i2)) {
                    case 1: {
                        choice.setGrammar(new ExternalGrammar("voice", links.createResourceLink(selectionRequestCommand.getOptionInputValue(i2)).toString()));
                        break;
                    }
                    case 2: {
                        choice.setGrammar(new RawInlineGrammar(selectionRequestCommand.getOptionInputValue(i2)));
                    }
                }
            }
            if (!"voice".equals(grammarMode)) {
                choice.setDTMF(dtmf == null ? "0" : dtmf);
            }
            menu.addChoice(choice);
            ++i2;
        }
        NoInput noInput = new NoInput();
        nextLink.setParameter(selectionRequestCommand.getResultName(), selectionRequestCommand.getNoInputResultValue());
        nextLink.setParameter(selectionRequestCommand.getSelectionName(), null);
        noInput.addAction(new Goto(nextLink.toString()));
        menu.addEventHandler(noInput);
        NoMatch noMatch = new NoMatch();
        nextLink.setParameter(selectionRequestCommand.getResultName(), selectionRequestCommand.getNoMatchResultValue());
        nextLink.setParameter(selectionRequestCommand.getSelectionName(), null);
        noMatch.addAction(new Goto(nextLink.toString()));
        menu.addEventHandler(noMatch);
        ILink hangupLink = links.createNextLink();
        int i3 = 0;
        while (i3 < parameterNames.length) {
            hangupLink.setParameters(parameterNames[i3], selectionRequestCommand.getParameterValues(parameterNames[i3]));
            ++i3;
        }
        hangupLink.setParameter(selectionRequestCommand.getResultName(), selectionRequestCommand.getHangupResultValue());
        Catch disconnectCatch = new Catch("connection.disconnect.hangup");
        disconnectCatch.addAction(new Goto(hangupLink.toString()));
        menu.addEventHandler(disconnectCatch);
        List events = ExtendedActionEventManager.getDefault().getExtendedEvents();
        for (String event : events) {
            ILink eventLink = links.createNextLink();
            int i4 = 0;
            while (i4 < parameterNames.length) {
                eventLink.setParameters(parameterNames[i4], selectionRequestCommand.getParameterValues(parameterNames[i4]));
                ++i4;
            }
            eventLink.setParameter(selectionRequestCommand.getResultName(), event);
            Catch eventCatch = new Catch(event);
            eventCatch.addAction(new Goto(eventLink.toString()));
            menu.addEventHandler(eventCatch);
        }
        return this.createVXMLDocument(links, menu);
    }

    protected IDocument renderDataRequest(ILinkFactory links, DataRequestCommand dataRequestCommand) {
        Form form = new Form("DataRequestForm");
        String bargeIn = this.getNormalizedBoolean(dataRequestCommand.getPropertyValue("barge-in"));
        String playBeep = this.getNormalizedBoolean(dataRequestCommand.getPropertyValue("play-beep"));
        String dtmfTerm = this.getNormalizedBoolean(dataRequestCommand.getPropertyValue("dtmf-termination"));
        String initialTimeout = dataRequestCommand.getPropertyValue("initial-timeout");
        String finalSilence = dataRequestCommand.getPropertyValue("final-silence-timeout");
        String maxRecordTime = dataRequestCommand.getPropertyValue("max-record-time");
        Recording recording = new Recording(dataRequestCommand.getDataName());
        recording.setFileType("audio/x-wav");
        recording.setProperty("inputmodes", "dtmf");
        if (playBeep != null) {
            recording.setBeepEnabled(Boolean.valueOf(playBeep));
        }
        if (dtmfTerm != null) {
            recording.setDtmfTermEnabled(Boolean.valueOf(dtmfTerm));
        }
        if (initialTimeout != null && initialTimeout.length() > 0) {
            recording.setTimeout(String.valueOf(initialTimeout) + "s");
        }
        if (finalSilence != null && finalSilence.length() > 0) {
            recording.setFinalSilence(String.valueOf(finalSilence) + "s");
        }
        if (maxRecordTime != null && maxRecordTime.length() > 0) {
            recording.setMaxtime(String.valueOf(maxRecordTime) + "s");
        } else {
            recording.setMaxtime("10s");
        }
        OutputSet outputs = new OutputSet();
        int i = 0;
        while (i < dataRequestCommand.getOutputCount()) {
            String outputValue = dataRequestCommand.getOutputValue(i);
            switch (dataRequestCommand.getOutputType(i)) {
                case 1: {
                    outputs.addOutput(this.generateAudioChain(links, outputValue));
                    break;
                }
                case 2: {
                    if (outputValue.startsWith("@@mark ")) {
                        outputs.addOutput(new SSMLMarkOutput(outputValue.substring(7)));
                        break;
                    }
                    outputs.addOutput(new TextOutput(outputValue));
                }
            }
            ++i;
        }
        Prompt prompt = new Prompt(outputs);
        if (bargeIn != null) {
            prompt.setBargeInEnabled(Boolean.valueOf(bargeIn));
        }
        prompt.setLanguage(this.getCurrentLocale());
        recording.setPrompt(prompt);
        String[] parameterNames = dataRequestCommand.getParameterNames();
        String[] submitVars = new String[parameterNames.length + 4];
        submitVars[0] = dataRequestCommand.getDataName();
        submitVars[1] = dataRequestCommand.getResultName();
        submitVars[2] = String.valueOf(dataRequestCommand.getDataName()) + "_termchar";
        submitVars[3] = "lastresult";
        Filled filled = new Filled();
        filled.addVariable(new Variable(dataRequestCommand.getResultName(), "'" + dataRequestCommand.getFilledResultValue() + "'"));
        filled.addVariable(new Variable(String.valueOf(dataRequestCommand.getDataName()) + "_termchar", String.valueOf(dataRequestCommand.getDataName()) + "$.termchar"));
        int i2 = 0;
        while (i2 < parameterNames.length) {
            submitVars[i2 + 4] = parameterNames[i2];
            String[] values = dataRequestCommand.getParameterValues(parameterNames[i2]);
            StringBuffer buf = new StringBuffer();
            int v = 0;
            while (v < values.length) {
                buf.append(values[v]);
                if (v < values.length - 1) {
                    buf.append(',');
                }
                ++v;
            }
            Variable paramVar = new Variable(parameterNames[i2], "'" + buf.toString() + "'");
            filled.addVariable(paramVar);
            ++i2;
        }
        filled.addVariable(new Variable("lastresult", "''"));
        ILink filledLink = links.createNextLink();
        Submit submit = new Submit(filledLink.toString(), submitVars);
        submit.setMethod("post");
        submit.setEncodingType("multipart/form-data");
        filled.addAction(submit);
        recording.addFilledHandler(filled);
        ILink noInputLink = links.createNextLink();
        int i3 = 0;
        while (i3 < parameterNames.length) {
            noInputLink.setParameters(parameterNames[i3], dataRequestCommand.getParameterValues(parameterNames[i3]));
            ++i3;
        }
        noInputLink.setParameter(dataRequestCommand.getResultName(), dataRequestCommand.getNoInputResultValue());
        NoInput noInput = new NoInput();
        noInput.addAction(new Submit(noInputLink.toString(), new String[]{dataRequestCommand.getDataName()}));
        recording.addEventHandler(noInput);
        form.addFormElement(recording);
        ILink hangupLink = links.createNextLink();
        int i4 = 0;
        while (i4 < parameterNames.length) {
            hangupLink.setParameters(parameterNames[i4], dataRequestCommand.getParameterValues(parameterNames[i4]));
            ++i4;
        }
        Catch disconnectCatch = new Catch("connection.disconnect.hangup");
        String[] disconnectVars = new String[parameterNames.length + 2];
        disconnectVars[0] = dataRequestCommand.getDataName();
        disconnectVars[1] = dataRequestCommand.getResultName();
        disconnectCatch.addVariable(new Variable(dataRequestCommand.getResultName(), "'" + dataRequestCommand.getHangupResultValue() + "'"));
        int i5 = 0;
        while (i5 < parameterNames.length) {
            disconnectVars[i5 + 2] = parameterNames[i5];
            String[] values = dataRequestCommand.getParameterValues(parameterNames[i5]);
            StringBuffer buf = new StringBuffer();
            int v = 0;
            while (v < values.length) {
                buf.append(values[v]);
                if (v < values.length - 1) {
                    buf.append(',');
                }
                ++v;
            }
            Variable paramVar = new Variable(parameterNames[i5], "'" + buf.toString() + "'");
            disconnectCatch.addVariable(paramVar);
            ++i5;
        }
        Submit disconnectSubmit = new Submit(hangupLink.toString(), disconnectVars);
        disconnectSubmit.setMethod("post");
        disconnectSubmit.setEncodingType("multipart/form-data");
        disconnectCatch.addAction(disconnectSubmit);
        recording.addEventHandler(disconnectCatch);
        List events = ExtendedActionEventManager.getDefault().getExtendedEvents();
        for (String event : events) {
            ILink eventLink = links.createNextLink();
            int i6 = 0;
            while (i6 < parameterNames.length) {
                eventLink.setParameters(parameterNames[i6], dataRequestCommand.getParameterValues(parameterNames[i6]));
                ++i6;
            }
            eventLink.setParameter(dataRequestCommand.getResultName(), event);
            Catch eventCatch = new Catch(event);
            eventCatch.addAction(new Goto(eventLink.toString()));
            form.addEventHandler(eventCatch);
        }
        return this.createVXMLDocument(links, form);
    }

    protected IDocument renderExternalReference(ILinkFactory links, ExternalReferenceCommand externalReferenceCommand) {
        Form form = new Form("ExternalReferenceForm");
        Subdialog subdialog = new Subdialog(externalReferenceCommand.getReferenceName());
        subdialog.setSourceURI(externalReferenceCommand.getReferenceURI());
        StringBuffer nameListBuffer = new StringBuffer();
        String[] sourceParameters = externalReferenceCommand.getURLParameterNames();
        int i = 0;
        while (i < sourceParameters.length) {
            String sourceParameterValue = externalReferenceCommand.getURLParameterValue(sourceParameters[i]);
            form.addVariable(new Variable(sourceParameters[i], sourceParameterValue));
            nameListBuffer.append(sourceParameters[i]);
            if (i != sourceParameters.length - 1) {
                nameListBuffer.append(' ');
            }
            ++i;
        }
        subdialog.setNameList(nameListBuffer.toString());
        String[] inputArgNames = externalReferenceCommand.getInputArgumentNames();
        int i2 = 0;
        while (i2 < inputArgNames.length) {
            subdialog.addParameter(new Parameter(inputArgNames[i2], externalReferenceCommand.getInputArgumentValue(inputArgNames[i2])));
            ++i2;
        }
        ILink nextLink = links.createNextLink();
        Filled filled = new Filled();
        ArrayList<String> submitNames = new ArrayList<String>();
        String[] parameterNames = externalReferenceCommand.getParameterNames();
        int i3 = 0;
        while (i3 < parameterNames.length) {
            submitNames.add(parameterNames[i3]);
            String[] parameterValues = externalReferenceCommand.getParameterValues(parameterNames[i3]);
            StringBuffer paramBuffer = new StringBuffer();
            int p = 0;
            while (p < parameterValues.length) {
                String val = parameterValues[p];
                paramBuffer.append(val);
                if (p < parameterValues.length - 1) {
                    paramBuffer.append(',');
                }
                ++p;
            }
            filled.addVariable(new Variable(parameterNames[i3], "'" + paramBuffer.toString() + "'"));
            ++i3;
        }
        submitNames.add(externalReferenceCommand.getResultName());
        filled.addVariable(new Variable(externalReferenceCommand.getResultName(), "'" + externalReferenceCommand.getFilledResultValue() + "'"));
        String[] outputArgNames = externalReferenceCommand.getOutputArgumentNames();
        int i4 = 0;
        while (i4 < outputArgNames.length) {
            submitNames.add(outputArgNames[i4]);
            filled.addVariable(new Variable(outputArgNames[i4], String.valueOf(externalReferenceCommand.getReferenceName()) + "." + externalReferenceCommand.getOutputArgumentValue(outputArgNames[i4])));
            ++i4;
        }
        Submit submit = new Submit(nextLink.toString(), submitNames.toArray(new String[submitNames.size()]));
        submit.setMethod("post");
        submit.setEncodingType("multipart/form-data");
        filled.addAction(submit);
        subdialog.addFilledHandler(filled);
        form.addFormElement(subdialog);
        ILink hangupLink = links.createNextLink();
        int i5 = 0;
        while (i5 < parameterNames.length) {
            hangupLink.setParameters(parameterNames[i5], externalReferenceCommand.getParameterValues(parameterNames[i5]));
            ++i5;
        }
        hangupLink.setParameter(externalReferenceCommand.getResultName(), externalReferenceCommand.getHangupResultValue());
        Catch disconnectCatch = new Catch("connection.disconnect.hangup");
        disconnectCatch.addAction(new Goto(hangupLink.toString()));
        form.addEventHandler(disconnectCatch);
        List events = ExtendedActionEventManager.getDefault().getExtendedEvents();
        for (String event : events) {
            ILink eventLink = links.createNextLink();
            int i6 = 0;
            while (i6 < parameterNames.length) {
                eventLink.setParameters(parameterNames[i6], externalReferenceCommand.getParameterValues(parameterNames[i6]));
                ++i6;
            }
            eventLink.setParameter(externalReferenceCommand.getResultName(), event);
            Catch eventCatch = new Catch(event);
            eventCatch.addAction(new Goto(eventLink.toString()));
            form.addEventHandler(eventCatch);
        }
        return this.createVXMLDocument(links, form);
    }

    protected IDocument renderTransferMessage(ILinkFactory links, TransferMessageCommand transferMessageCommand) {
        VXMLDocument document = new VXMLDocument();
        Form form = new Form("TransferMessageForm");
        form.addFormElement(new Transfer("TransferMessageElement", transferMessageCommand.getDestination()));
        document.addDialog(form);
        return document;
    }

    protected IDocument renderBridgeMessage(ILinkFactory links, BridgeMessageCommand bridgeMessageCommand) {
        Form form = new Form("BridgeMessageForm");
        Transfer tx = new Transfer("BridgeMessageElement", bridgeMessageCommand.getDestination());
        tx.setTransferType(bridgeMessageCommand.getTransferType());
        Filled filled = new Filled();
        If ifBusy = new If("BridgeMessageElement == 'busy'");
        ILink link = links.createNextLink();
        link.setParameter(bridgeMessageCommand.getResultName(), bridgeMessageCommand.getBusyResultValue());
        ifBusy.addAction(new Goto(link.toString()));
        ElseIf ifNetworkBusy = new ElseIf("BridgeMessageElement == 'network_busy'");
        link.setParameter(bridgeMessageCommand.getResultName(), bridgeMessageCommand.getBusyResultValue());
        ifNetworkBusy.addAction(new Goto(link.toString()));
        ifBusy.addElseIf(ifNetworkBusy);
        ElseIf ifNoAnswer = new ElseIf("BridgeMessageElement == 'noanswer'");
        link.setParameter(bridgeMessageCommand.getResultName(), bridgeMessageCommand.getUnavailableResultValue());
        ifNoAnswer.addAction(new Goto(link.toString()));
        ifBusy.addElseIf(ifNoAnswer);
        ElseIf ifUnknown = new ElseIf("BridgeMessageElement == 'unknown'");
        link.setParameter(bridgeMessageCommand.getResultName(), bridgeMessageCommand.getUnavailableResultValue());
        ifUnknown.addAction(new Goto(link.toString()));
        ifBusy.addElseIf(ifUnknown);
        filled.addIfClause(ifBusy);
        tx.addFilledHandler(filled);
        Catch noAuthCatch = new Catch("error.connection.noauthorization");
        ILink noAuthLink = links.createNextLink();
        noAuthLink.setParameter(bridgeMessageCommand.getResultName(), bridgeMessageCommand.getNoAuthResultValue());
        noAuthCatch.addAction(new Goto(noAuthLink.toString()));
        tx.addEventHandler(noAuthCatch);
        Catch badDestCatch = new Catch("error.connection.baddestination");
        ILink badDestLink = links.createNextLink();
        badDestLink.setParameter(bridgeMessageCommand.getResultName(), bridgeMessageCommand.getBadDestResultValue());
        badDestCatch.addAction(new Goto(badDestLink.toString()));
        tx.addEventHandler(badDestCatch);
        Catch noRouteCatch = new Catch("error.connection.noroute");
        ILink noRouteLink = links.createNextLink();
        noRouteLink.setParameter(bridgeMessageCommand.getResultName(), bridgeMessageCommand.getNoRouteResultValue());
        noRouteCatch.addAction(new Goto(noRouteLink.toString()));
        tx.addEventHandler(noRouteCatch);
        Catch noResourceCatch = new Catch("error.connection.noresource");
        ILink noResourceLink = links.createNextLink();
        noResourceLink.setParameter(bridgeMessageCommand.getResultName(), bridgeMessageCommand.getNoResourceResultValue());
        noResourceCatch.addAction(new Goto(noResourceLink.toString()));
        tx.addEventHandler(noResourceCatch);
        Catch badProtocolCatch = new Catch("error.connection.protocol");
        ILink badProtocolLink = links.createNextLink();
        badProtocolLink.setParameter(bridgeMessageCommand.getResultName(), bridgeMessageCommand.getProtocolResultValue());
        badProtocolCatch.addAction(new Goto(badProtocolLink.toString()));
        tx.addEventHandler(badProtocolCatch);
        Catch bridgeUnsupportedCatch = new Catch("error.unsupported.transfer.bridge");
        ILink bridgeUnsupportedLink = links.createNextLink();
        bridgeUnsupportedLink.setParameter(bridgeMessageCommand.getResultName(), bridgeMessageCommand.getBadBridgeResultValue());
        bridgeUnsupportedCatch.addAction(new Goto(bridgeUnsupportedLink.toString()));
        tx.addEventHandler(bridgeUnsupportedCatch);
        Catch uriUnsupportedCatch = new Catch("error.unsupported.uri");
        ILink uriUnsupportedLink = links.createNextLink();
        uriUnsupportedLink.setParameter(bridgeMessageCommand.getResultName(), bridgeMessageCommand.getBadUriResultValue());
        uriUnsupportedCatch.addAction(new Goto(uriUnsupportedLink.toString()));
        tx.addEventHandler(uriUnsupportedCatch);
        Catch transferCatch = new Catch("connection.disconnect.transfer");
        ILink transferLink = links.createNextLink();
        transferLink.setParameter(bridgeMessageCommand.getResultName(), bridgeMessageCommand.getTransferredResultValue());
        transferCatch.addAction(new Goto(transferLink.toString()));
        tx.addEventHandler(transferCatch);
        Catch disconnectCatch = new Catch("connection.disconnect.hangup");
        ILink hangupLink = links.createNextLink();
        hangupLink.setParameter(bridgeMessageCommand.getResultName(), bridgeMessageCommand.getHangupResultValue());
        disconnectCatch.addAction(new Goto(hangupLink.toString()));
        tx.addEventHandler(disconnectCatch);
        form.addFormElement(tx);
        List events = ExtendedActionEventManager.getDefault().getExtendedEvents();
        for (String event : events) {
            ILink eventLink = links.createNextLink();
            eventLink.setParameter(bridgeMessageCommand.getResultName(), event);
            Catch eventCatch = new Catch(event);
            eventCatch.addAction(new Goto(eventLink.toString()));
            form.addEventHandler(eventCatch);
        }
        return this.createVXMLDocument(links, form);
    }

    protected IDocument renderEndMessage(ILinkFactory links, EndMessageCommand endMessageCommand) {
        Form form = new Form("EndMessageForm");
        String[] variables = endMessageCommand.getVariableNames();
        int i = 0;
        while (i < variables.length) {
            form.addVariable(new Variable(variables[i], "'" + endMessageCommand.getVariable(variables[i]) + "'"));
            ++i;
        }
        Block block = new Block("EndMessageBlock");
        block.addAction(new Exit(variables));
        form.addFormElement(block);
        VXMLDocument document = this.createVXMLDocument(links, form);
        return document;
    }

    protected IDocument renderFinalDocument(ILinkFactory links, FinalCommand finalCommand) {
        Form form = new Form("FinalForm");
        String[] variables = finalCommand.getVariableNames();
        int i = 0;
        while (i < variables.length) {
            form.addVariable(new Variable(variables[i], "'" + finalCommand.getVariable(variables[i]) + "'"));
            ++i;
        }
        Block block = new Block("FinalBlock");
        block.addAction(new Return(variables));
        form.addFormElement(block);
        VXMLDocument document = this.createVXMLDocument(links, form);
        return document;
    }

    public String getInteractionTypeID() {
        return "org.eclipse.vtp.framework.interactions.voice.interaction";
    }

    public String getNormalizedBoolean(String parameter) {
        String ret = null;
        if (Boolean.TRUE.toString().equalsIgnoreCase(parameter)) {
            ret = Boolean.TRUE.toString();
        } else if (Boolean.FALSE.toString().equalsIgnoreCase(parameter)) {
            ret = Boolean.FALSE.toString();
        }
        return ret;
    }
}

