/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.voice.vxml;

import org.eclipse.vtp.framework.interactions.voice.vxml.Iota;
import org.eclipse.vtp.framework.interactions.voice.vxml.OneOf;
import org.eclipse.vtp.framework.util.XMLWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Item
extends Iota {
    private Object content;
    private int minimumRepeat = 0;
    private int maximumRepeat = 1;

    public Item(String content) throws NullPointerException {
        this.setContent(content);
    }

    public Item(OneOf content) throws NullPointerException {
        this.setContent(content);
    }

    public Object getContent() {
        return this.content;
    }

    public int getMinimumRepeat() {
        return this.minimumRepeat;
    }

    public int getMaximumRepeat() {
        return this.maximumRepeat;
    }

    public void setContent(String content) throws NullPointerException {
        if (content == null) {
            throw new IllegalArgumentException("content");
        }
        this.content = content;
    }

    public void setContent(OneOf content) throws NullPointerException {
        if (content == null) {
            throw new IllegalArgumentException("content");
        }
        this.content = content;
    }

    public void setMinimumRepeat(int minimumRepeat) throws IllegalArgumentException {
        if (minimumRepeat < 0) {
            throw new IllegalArgumentException("minimumRepeat");
        }
        this.minimumRepeat = minimumRepeat;
    }

    public void setMaximumRepeat(int maximumRepeat) throws IllegalArgumentException {
        if (maximumRepeat < 0) {
            throw new IllegalArgumentException("maximumRepeat");
        }
        this.maximumRepeat = maximumRepeat;
    }

    public void writeWidget(ContentHandler outputHandler) throws NullPointerException, SAXException {
        if (outputHandler == null) {
            throw new NullPointerException("outputHandler");
        }
        if (outputHandler instanceof XMLWriter) {
            ((XMLWriter)outputHandler).setCompactElements(true);
        }
        AttributesImpl attributes = new AttributesImpl();
        this.writeAttributes(attributes);
        outputHandler.startElement("http://www.w3.org/2001/vxml", "item", "item", attributes);
        this.writeContent(outputHandler);
        outputHandler.endElement("http://www.w3.org/2001/vxml", "item", "item");
        if (outputHandler instanceof XMLWriter) {
            ((XMLWriter)outputHandler).setCompactElements(false);
        }
    }

    protected void writeAttributes(AttributesImpl attributes) {
        this.writeAttribute(attributes, null, null, "repeat", "CDATA", String.valueOf(this.minimumRepeat) + "-" + this.maximumRepeat);
    }

    protected void writeContent(ContentHandler outputHandler) throws NullPointerException, SAXException {
        if (this.content instanceof OneOf) {
            ((OneOf)this.content).writeWidget(outputHandler);
        } else {
            String text = (String)this.content;
            outputHandler.characters(text.toCharArray(), 0, text.length());
        }
    }
}

