/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.voice.vxml;

import java.util.LinkedList;
import org.eclipse.vtp.framework.interactions.voice.vxml.Choice;
import org.eclipse.vtp.framework.interactions.voice.vxml.Dialog;
import org.eclipse.vtp.framework.interactions.voice.vxml.Prompt;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Menu
extends Dialog {
    private Prompt prompt;
    private final LinkedList<Choice> choices = new LinkedList();

    public Menu(String id, Prompt prompt) throws IllegalArgumentException, NullPointerException {
        super(id);
        this.setPrompt(prompt);
    }

    public Menu(String id, String scope, Prompt prompt) throws IllegalArgumentException, NullPointerException {
        super(id, scope);
        this.setPrompt(prompt);
    }

    public Prompt getPrompt() {
        return this.prompt;
    }

    Choice[] getChoices() {
        return this.choices.toArray(new Choice[this.choices.size()]);
    }

    public void setPrompt(Prompt prompt) throws NullPointerException {
        if (prompt == null) {
            throw new NullPointerException("prompt");
        }
        this.prompt = prompt;
    }

    public void addChoice(Choice choice) throws NullPointerException {
        if (choice == null) {
            throw new NullPointerException("choice");
        }
        this.choices.add(choice);
    }

    public void removeChoice(Choice choice) throws NullPointerException {
        if (choice == null) {
            throw new NullPointerException("choice");
        }
        this.choices.remove(choice);
    }

    public void writeWidget(ContentHandler outputHandler) throws NullPointerException, SAXException {
        if (outputHandler == null) {
            throw new NullPointerException("outputHandler");
        }
        AttributesImpl attributes = new AttributesImpl();
        this.writeAttributes(attributes);
        outputHandler.startElement("http://www.w3.org/2001/vxml", "menu", "menu", attributes);
        this.writeProperties(outputHandler);
        this.writePrompt(outputHandler);
        this.writeChoices(outputHandler);
        this.writeEventHandlers(outputHandler);
        outputHandler.endElement("http://www.w3.org/2001/vxml", "menu", "menu");
    }

    protected void writePrompt(ContentHandler outputHandler) throws NullPointerException, SAXException {
        if (this.prompt != null) {
            this.prompt.writeWidget(outputHandler);
        }
    }

    protected void writeChoices(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.writeChildren(outputHandler, this.choices);
    }
}

