/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.util;

public class QuickSort {
    public static Comparable[] comparableSort(Comparable[] comps) {
        return QuickSort.comparableSort(comps, 0, comps.length - 1);
    }

    private static Comparable[] comparableSort(Comparable[] comps, int src, int end) {
        Comparable tmp_comp = null;
        int es = end - src;
        if (comps == null) {
            return null;
        }
        if (es < 1) {
            return comps;
        }
        if (es == 1) {
            if (comps[src].compareTo(comps[end]) > 0) {
                tmp_comp = comps[src];
                comps[src] = comps[end];
                comps[end] = tmp_comp;
            }
            return comps;
        }
        int cent = es / 2 + src;
        Comparable pivot = comps[cent];
        int det = 0;
        if (comps[src].compareTo(pivot) > 0) {
            det += 4;
        }
        if (pivot.compareTo(comps[end]) > 0) {
            det += 2;
        }
        if (comps[end].compareTo(comps[src]) > 0) {
            ++det;
        }
        switch (det) {
            case 0: {
                pivot = comps[src];
                comps[src] = comps[end];
                break;
            }
            case 1: {
                comps[cent] = comps[end];
                break;
            }
            case 2: {
                pivot = comps[src];
                comps[src] = comps[end];
                break;
            }
            case 3: {
                pivot = comps[end];
                break;
            }
            case 4: {
                pivot = comps[end];
                break;
            }
            case 5: {
                pivot = comps[src];
                comps[src] = comps[end];
                break;
            }
            case 6: {
                comps[cent] = comps[end];
                break;
            }
            case 7: {
                pivot = comps[src];
                comps[src] = comps[end];
            }
        }
        comps[end] = pivot;
        int lp = src;
        int rp = end - 1;
        while (rp > lp) {
            int resl = comps[lp].compareTo(pivot);
            int resr = comps[rp].compareTo(pivot);
            if (resl >= 0 && resr < 0) {
                tmp_comp = comps[rp];
                comps[rp] = comps[lp];
                comps[lp] = tmp_comp;
                --rp;
                ++lp;
                continue;
            }
            if (resl >= 0) {
                --rp;
                continue;
            }
            if (resr < 0) {
                ++lp;
                continue;
            }
            if (resl >= 0 || resr < 0) continue;
            --rp;
            ++lp;
        }
        if (rp == lp) {
            if (comps[lp].compareTo(pivot) > 0) {
                if (lp == src) {
                    return comps;
                }
                QuickSort.comparableSort(comps, src, lp - 1);
                QuickSort.comparableSort(comps, lp, end);
            } else {
                QuickSort.comparableSort(comps, src, lp);
                QuickSort.comparableSort(comps, lp + 1, end);
            }
        } else {
            QuickSort.comparableSort(comps, src, rp);
            QuickSort.comparableSort(comps, lp, end);
        }
        return comps;
    }
}

