/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.util;

import java.util.regex.Pattern;

public class VariableNameValidator {
    public static Boolean followsVtpNamingRules(String name) {
        if (VariableNameValidator.isVtpReservedWord(name).booleanValue()) {
            return false;
        }
        return Pattern.matches("[\\p{L}_\\$][\\p{L}_\\$\\p{Digit}]*", name);
    }

    public static Boolean followsEcmaNamingRules(String name) {
        if (VariableNameValidator.isEcmaReservedWord(name).booleanValue()) {
            return false;
        }
        return Pattern.matches("[\\p{L}_\\$][\\p{L}_\\$\\p{Digit}]*", name);
    }

    public static Boolean isVtpReservedWord(String name) {
        String[] keywords = new String[]{"Platform", "LastResult"};
        int b = 0;
        while (b < keywords.length) {
            if (name.equals(keywords[b])) {
                return true;
            }
            ++b;
        }
        return false;
    }

    public static Boolean isEcmaReservedWord(String name) {
        String[] nullLiterals = new String[]{"null"};
        String[] booleanLiterals = new String[]{"true", "false"};
        String[] keywords = new String[]{"break", "else", "new", "var", "case", "finally", "return", "void", "catch", "for", "switch", "while", "continue", "function", "this", "with", "default", "if", "throw", "delete", "in", "try", "do", "instanceof", "typeof"};
        String[] futureReservedWords = new String[]{"abstract", "enum", "int", "short", "boolean", "export", "interface", "static", "byte", "extends", "long", "super", "char", "final", "native", "synchronized", "class", "float", "package", "throws", "const", "goto", "private", "transient", "debugger", "implements", "protected", "volatile", "double", "import", "public"};
        int b = 0;
        while (b < nullLiterals.length) {
            if (name.equals(nullLiterals[b])) {
                return true;
            }
            ++b;
        }
        b = 0;
        while (b < booleanLiterals.length) {
            if (name.equals(booleanLiterals[b])) {
                return true;
            }
            ++b;
        }
        b = 0;
        while (b < keywords.length) {
            if (name.equals(keywords[b])) {
                return true;
            }
            ++b;
        }
        b = 0;
        while (b < futureReservedWords.length) {
            if (name.equals(futureReservedWords[b])) {
                return true;
            }
            ++b;
        }
        return false;
    }
}

