/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.webservices.configurations;

import java.util.List;
import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.framework.webservices.configurations.WebServiceConstants;
import org.eclipse.vtp.framework.webservices.configurations.document.InputDocumentStructure;
import org.w3c.dom.Element;

public class WebServiceConfiguration
implements IConfiguration,
WebServiceConstants {
    private String serviceType = "soap";
    private String urlType = "static";
    private String url = null;
    private String soapActionType = "static";
    private String soapAction = null;
    private InputDocumentStructure inputStructure = new InputDocumentStructure();
    private String variableName = "ws_output";
    private boolean process = false;
    private String outputScriptText = null;

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getURLType() {
        return this.urlType;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String urlType, String url) {
        this.urlType = urlType;
        this.url = url;
    }

    public String getSoapActionType() {
        return this.soapActionType;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String soapActionType, String soapAction) {
        this.soapActionType = soapActionType;
        this.soapAction = soapAction;
    }

    public InputDocumentStructure getInputStructure() {
        return this.inputStructure;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public boolean shouldProcess() {
        return this.process;
    }

    public void setShouldProcess(boolean process) {
        this.process = process;
    }

    public String getOutputScriptText() {
        return this.outputScriptText;
    }

    public void setOutputScriptText(String outputScriptText) {
        this.outputScriptText = outputScriptText;
    }

    public void load(Element configurationElement) {
        List outputElementList;
        List inputStructureElementList;
        List serviceElementList = XMLUtilities.getElementsByTagName((Element)configurationElement, (String)"service-info", (boolean)true);
        if (serviceElementList.size() > 0) {
            Element serviceElement = (Element)serviceElementList.get(0);
            this.serviceType = serviceElement.getAttribute("service-type");
            this.soapActionType = serviceElement.getAttribute("soap-action-type");
            this.soapAction = serviceElement.getAttribute("soap-action");
            this.urlType = serviceElement.getAttribute("url-type");
            this.url = serviceElement.getAttribute("url");
        }
        if ((inputStructureElementList = XMLUtilities.getElementsByTagName((Element)configurationElement, (String)"input-structure", (boolean)true)).size() > 0) {
            this.inputStructure.readConfiguration((Element)inputStructureElementList.get(0));
        }
        if ((outputElementList = XMLUtilities.getElementsByTagName((Element)configurationElement, (String)"output", (boolean)true)).size() > 0) {
            Element outputElement = (Element)outputElementList.get(0);
            this.variableName = outputElement.getAttribute("variable");
            this.process = "true".equals(outputElement.getAttribute("process"));
            try {
                this.outputScriptText = XMLUtilities.getElementTextData((Element)outputElement, (boolean)true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void save(Element configurationElement) {
        Element serviceElement = configurationElement.getOwnerDocument().createElementNS(null, "service-info");
        configurationElement.appendChild(serviceElement);
        serviceElement.setAttribute("service-type", this.serviceType);
        serviceElement.setAttribute("soap-action-type", this.soapActionType);
        serviceElement.setAttribute("soap-action", this.soapAction);
        serviceElement.setAttribute("url-type", this.urlType);
        serviceElement.setAttribute("url", this.url);
        Element inputStructureElement = configurationElement.getOwnerDocument().createElementNS(null, "input-structure");
        configurationElement.appendChild(inputStructureElement);
        this.inputStructure.writeConfiguration(inputStructureElement);
        Element outputElement = configurationElement.getOwnerDocument().createElementNS(null, "output");
        configurationElement.appendChild(outputElement);
        outputElement.setAttribute("variable", this.variableName);
        outputElement.setAttribute("process", this.process ? "true" : "false");
        outputElement.setTextContent(this.outputScriptText);
    }
}

