/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.webservices.configurations.document;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.vtp.framework.common.IBrand;
import org.eclipse.vtp.framework.webservices.configurations.document.BindingValue;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ElementAttributeDocumentItem {
    private String name = null;
    private Map<String, BindingValue> brandBindings = new TreeMap<String, BindingValue>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BindingValue getBrandBinding(IBrand brand) {
        return this.brandBindings.get(brand.getId());
    }

    public void readConfiguration(Element attributeItemElement) {
        NodeList brandBindingElementList = attributeItemElement.getElementsByTagName("brand-binding");
        int i = 0;
        while (i < brandBindingElementList.getLength()) {
            Element brandBindingElement = (Element)brandBindingElementList.item(i);
            String brandId = brandBindingElement.getAttribute("id");
            BindingValue value = new BindingValue();
            value.readConfiguration(brandBindingElement);
            this.brandBindings.put(brandId, value);
            ++i;
        }
    }

    public void writeConfiguration(Element attributeItemElement) {
        for (Map.Entry<String, BindingValue> entry : this.brandBindings.entrySet()) {
            String brandId = entry.getKey();
            BindingValue brandBinding = entry.getValue();
            Element brandBindingElement = attributeItemElement.getOwnerDocument().createElementNS(null, "brand-binding");
            attributeItemElement.appendChild(brandBindingElement);
            brandBindingElement.setAttribute("id", brandId);
            brandBinding.writeConfiguration(brandBindingElement);
        }
    }
}

