/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.attacheddata.ui.configuration.request;

import org.eclipse.vtp.modules.attacheddata.ui.configuration.request.AttachedDataBindingItem;
import org.eclipse.vtp.modules.attacheddata.ui.configuration.request.AttachedDataItemEntry;
import org.eclipse.vtp.modules.attacheddata.ui.configuration.request.AttachedDataManager;
import org.eclipse.vtp.modules.attacheddata.ui.configuration.request.GenericBinding;
import org.eclipse.vtp.modules.attacheddata.ui.configuration.request.GenericBindingItem;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AttachedDataBinding
extends GenericBinding {
    public AttachedDataBinding(AttachedDataManager manager, String name) {
        super(manager, name);
    }

    public AttachedDataBindingItem getAttachedDataItem(String brand, String interactionType, String language) {
        AttachedDataBindingItem attachedDataBinding = (AttachedDataBindingItem)super.getItem(brand, interactionType, language);
        if (attachedDataBinding == null) {
            attachedDataBinding = new AttachedDataBindingItem();
        }
        return attachedDataBinding;
    }

    public void putAttachedDataItem(String brand, String interactionType, String language, AttachedDataBindingItem item) {
        super.putItem(brand, interactionType, language, item);
    }

    @Override
    protected GenericBindingItem readBindingItem(Element itemConfiguration) {
        AttachedDataBindingItem item = new AttachedDataBindingItem();
        NodeList contentList = itemConfiguration.getChildNodes();
        int i = 0;
        while (i < contentList.getLength()) {
            if (contentList.item(i) instanceof Element) {
                AttachedDataItemEntry entry = new AttachedDataItemEntry();
                Element entryElement = (Element)contentList.item(i);
                entry.setName(entryElement.getAttribute("name"));
                entry.setValue(entryElement.getAttribute("value"));
                item.addEntry(entry);
            }
            ++i;
        }
        return item;
    }

    @Override
    protected void writeBindingItem(GenericBindingItem item, Element itemConfiguration) {
        for (AttachedDataItemEntry entry : ((AttachedDataBindingItem)item).getEntries()) {
            if (entry.getValue() == null) continue;
            Element entryElement = itemConfiguration.getOwnerDocument().createElement("entry");
            itemConfiguration.appendChild(entryElement);
            entryElement.setAttribute("name", entry.getName());
            entryElement.setAttribute("value", entry.getValue());
        }
    }
}

