/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.attacheddata.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.vtp.desktop.model.core.FieldType;
import org.eclipse.vtp.desktop.model.core.design.IDesignConnector;
import org.eclipse.vtp.desktop.model.core.design.ObjectDefinition;
import org.eclipse.vtp.desktop.model.core.design.ObjectField;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.modules.attacheddata.ui.configuration.post.AttachedDataItemEntry;

public class AttachedDataEntryDialog
extends Dialog {
    AttachedDataItemEntry entry = new AttachedDataItemEntry();
    Button mapRadio = null;
    Combo mapCombo = null;
    Button singleRadio = null;
    Text nameField = null;
    Button staticButton = null;
    Text staticField = null;
    Button expressionButton = null;
    Text expressionField = null;
    Button variableButton = null;
    TreeViewer variableViewer = null;
    IDesignConnector connector = null;
    String exitPath = null;
    List<Variable> incomingVariables = new ArrayList<Variable>();
    List<Variable> incomingMaps = new ArrayList<Variable>();

    public AttachedDataEntryDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(0x10870 | AttachedDataEntryDialog.getDefaultOrientation());
    }

    public AttachedDataEntryDialog(IShellProvider parentShell) {
        super(parentShell);
        this.setShellStyle(0x10870 | AttachedDataEntryDialog.getDefaultOrientation());
    }

    public void setConnector(IDesignConnector connector, String exitPath) {
        this.connector = connector;
        this.exitPath = exitPath;
    }

    public void setEntry(AttachedDataItemEntry entry) {
        this.entry = entry;
    }

    public AttachedDataItemEntry getEntry() {
        return this.entry;
    }

    protected Control createDialogArea(Composite parent) {
        List vars = this.connector.getOrigin().getDesign().getVariablesFrom(this.connector.getOrigin(), this.exitPath);
        block0: for (Variable v : vars) {
            int i = 0;
            while (i < this.incomingVariables.size()) {
                if (this.incomingVariables.get(i).getName().compareToIgnoreCase(v.getName()) > 0) {
                    this.incomingVariables.add(i, v);
                    continue block0;
                }
                ++i;
            }
            this.incomingVariables.add(v);
        }
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(1808));
        comp.setLayout((Layout)new GridLayout(1, false));
        this.mapRadio = new Button(comp, 16);
        this.mapRadio.setText("Add all values from a Map");
        this.mapRadio.setLayoutData((Object)new GridData(768));
        System.out.println("Data Type " + this.entry.getDataType());
        this.mapRadio.setSelection(this.entry.getDataType() == 4);
        Composite mapComp = new Composite(comp, 0);
        mapComp.setLayoutData((Object)new GridData(768));
        mapComp.setLayout((Layout)new GridLayout(2, false));
        Label mapLabel = new Label(mapComp, 0);
        mapLabel.setText("Use this map");
        mapLabel.setLayoutData((Object)new GridData());
        this.mapCombo = new Combo(mapComp, 12);
        this.mapCombo.setLayoutData((Object)new GridData(768));
        for (Variable v : this.incomingVariables) {
            if (!v.getType().hasBaseType() || v.getType().getPrimitiveType() != FieldType.Primitive.MAP) continue;
            this.incomingMaps.add(v);
            this.mapCombo.add(v.getName());
        }
        if (this.incomingMaps.size() == 0) {
            this.mapCombo.setEnabled(false);
            this.mapRadio.setEnabled(false);
        } else if (this.entry.getValue() == null) {
            this.mapCombo.select(0);
        } else {
            int i = 0;
            while (i < this.incomingMaps.size()) {
                Variable v = this.incomingMaps.get(i);
                if (v.getName().equals(this.entry.getValue())) {
                    this.mapCombo.select(i);
                }
                ++i;
            }
        }
        this.singleRadio = new Button(comp, 16);
        this.singleRadio.setText("Add a single value");
        this.singleRadio.setLayoutData((Object)new GridData(768));
        this.singleRadio.setSelection(this.entry.getDataType() != 4);
        Composite singleComp = new Composite(comp, 0);
        singleComp.setLayoutData((Object)new GridData(1808));
        singleComp.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(singleComp, 0);
        nameLabel.setText("Attached Data Name");
        GridData layoutData = new GridData();
        layoutData.verticalIndent = 10;
        nameLabel.setLayoutData((Object)layoutData);
        this.nameField = new Text(singleComp, 2052);
        if (this.entry.getDataType() != 4) {
            this.nameField.setText(this.entry.getName() == null ? "" : this.entry.getName());
        }
        layoutData = new GridData(768);
        layoutData.verticalIndent = 10;
        this.nameField.setLayoutData((Object)layoutData);
        this.staticButton = new Button(singleComp, 16);
        this.staticButton.setText("Use this value");
        this.staticButton.setSelection(this.entry.getDataType() == 0);
        this.staticButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!AttachedDataEntryDialog.this.staticButton.getSelection()) {
                    AttachedDataEntryDialog.this.staticField.setText("");
                } else {
                    AttachedDataEntryDialog.this.entry.setValue("");
                    AttachedDataEntryDialog.this.entry.setDataType(0);
                }
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.staticButton.setLayoutData((Object)gd);
        this.staticField = new Text(singleComp, 2052);
        if (this.entry.getDataType() == 0) {
            this.staticField.setText(this.entry.getValue() == null ? "" : this.entry.getValue());
        }
        gd = new GridData(768);
        gd.horizontalIndent = 15;
        gd.horizontalSpan = 2;
        this.staticField.setLayoutData((Object)gd);
        this.expressionButton = new Button(singleComp, 16);
        this.expressionButton.setText("Use this Javascript expression");
        this.expressionButton.setSelection(this.entry.getDataType() == 1);
        this.expressionButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!AttachedDataEntryDialog.this.expressionButton.getSelection()) {
                    AttachedDataEntryDialog.this.expressionField.setText("");
                } else {
                    AttachedDataEntryDialog.this.entry.setValue("");
                    AttachedDataEntryDialog.this.entry.setDataType(1);
                }
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.expressionButton.setLayoutData((Object)gd);
        this.expressionField = new Text(singleComp, 2052);
        if (this.entry.getDataType() == 1) {
            this.expressionField.setText(this.entry.getValue() == null ? "" : this.entry.getValue());
        }
        gd = new GridData(768);
        gd.horizontalIndent = 15;
        gd.horizontalSpan = 2;
        this.expressionField.setLayoutData((Object)gd);
        this.variableButton = new Button(singleComp, 16);
        this.variableButton.setText("Use the contents of this variable");
        this.variableButton.setSelection(this.entry.getDataType() == 2);
        this.variableButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!AttachedDataEntryDialog.this.variableButton.getSelection()) {
                    AttachedDataEntryDialog.this.variableViewer.setSelection((ISelection)new StructuredSelection(null));
                } else {
                    AttachedDataEntryDialog.this.entry.setValue("");
                    AttachedDataEntryDialog.this.entry.setDataType(2);
                }
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.variableButton.setLayoutData((Object)gd);
        Tree variableTable = new Tree(singleComp, 68100);
        variableTable.setHeaderVisible(true);
        TreeColumn nameColumn = new TreeColumn(variableTable, 0);
        nameColumn.setText("Variable Name");
        nameColumn.setWidth(225);
        TreeColumn typeColumn = new TreeColumn(variableTable, 0);
        typeColumn.setText("Type");
        typeColumn.setWidth(125);
        gd = new GridData(768);
        gd.horizontalIndent = 15;
        gd.horizontalSpan = 2;
        gd.widthHint = 350;
        gd.heightHint = 400;
        variableTable.setLayoutData((Object)gd);
        this.variableViewer = new TreeViewer(variableTable);
        this.variableViewer.setContentProvider((IContentProvider)new VariableContentProvider());
        this.variableViewer.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider());
        this.variableViewer.setInput((Object)this);
        if (this.variableButton.getSelection()) {
            int i = 0;
            while (i < this.incomingVariables.size()) {
                Variable v = this.incomingVariables.get(i);
                if (v.getName().equals(this.entry.getValue())) {
                    this.variableViewer.setSelection((ISelection)new StructuredSelection((Object)v));
                } else if (this.entry.getValue() != null && this.entry.getValue().startsWith(v.getName())) {
                    List objectFields = v.getFields();
                    int f = 0;
                    while (f < objectFields.size()) {
                        ObjectField of = (ObjectField)objectFields.get(f);
                        if (of.getPath().equals(this.entry.getValue())) {
                            this.variableViewer.setSelection((ISelection)new StructuredSelection((Object)of));
                        }
                        ++f;
                    }
                }
                ++i;
            }
        }
        return comp;
    }

    protected void okPressed() {
        if (this.mapRadio.getSelection()) {
            this.entry.setName("All items in");
            this.entry.setDataType(4);
            this.entry.setValue(this.incomingMaps.get(this.mapCombo.getSelectionIndex()).getName());
        } else {
            this.entry.setName(this.nameField.getText());
            if (this.staticButton.getSelection()) {
                this.entry.setValue(this.staticField.getText());
            } else if (this.expressionButton.getSelection()) {
                this.entry.setValue(this.expressionField.getText());
            } else {
                System.err.println(((StructuredSelection)this.variableViewer.getSelection()).getFirstElement());
                this.entry.setValue(((ObjectDefinition)((StructuredSelection)this.variableViewer.getSelection()).getFirstElement()).getPath());
            }
        }
        super.okPressed();
    }

    public class VariableContentProvider
    implements ITreeContentProvider {
        public Object[] getElements(Object inputElement) {
            return AttachedDataEntryDialog.this.incomingVariables.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof Variable) {
                return null;
            }
            return ((ObjectField)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return true;
        }

        public Object[] getChildren(Object parentElement) {
            return ((ObjectDefinition)parentElement).getFields().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class VariableLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((ObjectDefinition)element).getName();
            }
            FieldType ft = ((ObjectDefinition)element).getType();
            String ret = "";
            ret = String.valueOf(ret) + ft.getName();
            if (ft.hasBaseType()) {
                ret = " Of " + ft.getBaseTypeName();
            }
            return ret;
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

